/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.IOException;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.impl.ComponentProperty;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.xml.XmlWriter;

public abstract class ProcessObjectImpl
extends ProjectObjectContainerImpl
implements ModelObject,
Localizable.Mutable {
    protected ModificationAwareLocaleStringMap documentation;
    protected LocaleStringMap label;
    protected ModificationAwareLocaleStringMap useCaseDocumentation;
    private LocaleStringMap description = LocaleStringMap.create();
    private String language_d;
    private Process process;

    protected ProcessObjectImpl(Process process) {
        this(process.getProject(), process);
    }

    protected ProcessObjectImpl(Project project, Process process) {
        super(project);
        this.process = process;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.process;
    }

    public void setLanguage(String lang) {
        this.language_d = lang;
    }

    public String getLanguage() {
        return this.language_d;
    }

    @Override
    public void setDocumentation(ModificationAwareLocaleStringMap documentation) {
        this.documentation = documentation;
    }

    @Override
    public void setDescription(LocaleStringMap description) {
        this.description = description;
    }

    @Override
    public LocaleStringMap getDocumentationMap() {
        if (this.documentation == null) {
            this.documentation = this.createLocaleStringMap();
        }
        return this.documentation;
    }

    @Override
    public void setUseCaseDocumentation(ModificationAwareLocaleStringMap useCaseDocumentation) {
        this.useCaseDocumentation = useCaseDocumentation;
    }

    @Override
    public LocaleStringMap getUseCaseDocumentationMap() {
        if (this.useCaseDocumentation == null) {
            this.useCaseDocumentation = this.createLocaleStringMap();
        }
        return this.useCaseDocumentation;
    }

    @Override
    public Localizable.Mutable asMutableLocalizable() {
        return this;
    }

    @Override
    public void setLabelMap(LocaleStringMap label) {
        this.label = label;
    }

    @Override
    public LocaleStringMap getLabelMap() {
        if (this.label == null) {
            this.label = LocaleStringMap.create();
        }
        return this.label;
    }

    @Override
    public String getDefaultLabel() {
        return this.getString(this.getLabelMap(), this.getId());
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getLabelMap().getString(locale);
    }

    @Override
    public void setDefaultLabel(String text) {
        this.setString(this.getLabelMap(), text);
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        return this.description;
    }

    @Override
    public void setDefaultDescription(String text) {
        this.setString(this.getDescriptionMap(), text);
    }

    @Override
    public String getDefaultDescription() {
        return this.getString(this.getDescriptionMap(), "");
    }

    public void writeProperties(XmlWriter xml) throws IOException {
        for (String s : this.getComponentProperties().keySet()) {
            xml.printAttribute(s, this.getProperty(s));
        }
    }

    public void copyPropertiesFrom(ProcessObjectImpl fuegoInfo) {
        for (String s : fuegoInfo.getComponentProperties().keySet()) {
            this.setProperty(s, fuegoInfo.getProperty(s));
        }
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    protected ProcessContent getProcessContent() {
        return (ProcessContent)this.process;
    }

    protected boolean getBooleanValue(ComponentProperty property) {
        return this.getBooleanValue(property.getKey());
    }

    protected boolean getBooleanValue(String value) {
        String o = this.getProperty(value);
        return o != null && Boolean.valueOf(o) != false;
    }

    protected int getIntValue(ComponentProperty property) {
        String result = this.getProperty(property);
        if (result == null) {
            return 0;
        }
        return Integer.valueOf(result);
    }

    protected void removeModificationListener(Features oldFeatures) {
        if (oldFeatures == null) {
            return;
        }
        ModificationListener<Feature> listener = this.getModificationListener();
        for (PersistentFeature persistentFeature : oldFeatures.persistentFeatures()) {
            persistentFeature.removeModificationListener(listener);
        }
    }

    private ModificationAwareLocaleStringMap createLocaleStringMap() {
        ModificationAwareLocaleStringMap result = ModificationAwareLocaleStringMap.create(this);
        result.addModificationListener(new ModificationListener<ProjectObject>(){

            @Override
            public void objectModified(ModificationEvent<ProjectObject> event) {
                ProcessObjectImpl.this.fireObjectChanged(ProcessObjectImpl.this, ProjectEvent.CHANGE(ProcessObjectImpl.this, null, event.getOldValue(), event.getNewValue()));
            }
        });
        return result;
    }
}

