/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.Collection;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.deployment.ProcessDeployment;

public class ProcessIdsConverterUtils {
    public static String projectToDeploymentProcessId(String projectProcessId, Collection<ProcessDeployment> processesDeployments) {
        for (ProcessDeployment processDeployment : processesDeployments) {
            if (!processDeployment.getProcessName().equals(projectProcessId)) continue;
            return processDeployment.getId();
        }
        return null;
    }

    public static String deployedToProjectProcessId(String deployedProcessId) {
        return ProcessDeploymentUtils.getProcessNameFromDeploymentId(deployedProcessId);
    }

    public static String deploymentToProjectProcessId(ProcessDeployment processDeployment) {
        String papiProcessId = ProcessIdsConverterUtils.deployedToPapiProcessId(processDeployment);
        return ProcessIdsConverterUtils.papiToProjectProcessId(papiProcessId);
    }

    public static String deployedToPapiProcessId(ProcessDeployment processDeployment) {
        return ProcessDeploymentUtils.getDeployedProcessId(processDeployment);
    }

    public static String papiToDeployedProcessId(String papiProcessId) {
        return ProcessDeploymentUtils.getProcessNameFromDeploymentId(papiProcessId);
    }

    public static String projectToPapiProcessId(String projectProcessId, Collection<ProcessDeployment> processesDeployments) {
        ProcessDeployment processDeployment = null;
        for (ProcessDeployment currentDeployment : processesDeployments) {
            if (!currentDeployment.getProcessName().equals(projectProcessId)) continue;
            processDeployment = currentDeployment;
        }
        return ProcessIdsConverterUtils.deployedToPapiProcessId(processDeployment);
    }

    public static String papiToProjectProcessId(String papiProcessId) {
        String deployedProcessId = ProcessIdsConverterUtils.papiToDeployedProcessId(papiProcessId);
        return ProcessIdsConverterUtils.deployedToProjectProcessId(deployedProcessId);
    }

    public static String getConsolidatedPapiId(ProcessDeployment processDeployment) {
        return ProcessIdsConverterUtils.getConsolidatedPapiId(ProcessIdsConverterUtils.deployedToPapiProcessId(processDeployment));
    }

    public static String getConsolidatedPapiId(String papiProcessId) {
        int versionIndexOf = papiProcessId.indexOf("#");
        if (versionIndexOf == -1) {
            return papiProcessId;
        }
        return papiProcessId.substring(0, versionIndexOf);
    }
}

