/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.Locale;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum Priority implements I18nProvider
{
    LOWEST(ProjectMsg.LOWEST),
    LOW(ProjectMsg.LOW),
    NORMAL(ProjectMsg.NORMAL),
    HIGH(ProjectMsg.HIGH),
    HIGHEST(ProjectMsg.HIGHEST);

    private transient Msg msg;

    private Priority(Msg msg) {
        this.msg = msg;
    }

    public static Priority valueOf(int n) {
        return Priority.values()[n];
    }

    public static Priority compatibleValueOf(int n) {
        return Priority.values()[n == 0 ? 4 : n - 1];
    }

    public boolean isHighest() {
        return this == HIGHEST;
    }

    public boolean isHigh() {
        return this == HIGH;
    }

    public boolean isNormal() {
        return this == NORMAL;
    }

    public boolean isLow() {
        return this == LOW;
    }

    public boolean isLowest() {
        return this == LOWEST;
    }

    public int intValue() {
        return this.ordinal();
    }

    public int compatibleIntValue() {
        return this.ordinal() + 1;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }
}

