/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.PredefinedVariable;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class PredefinedVariablesHelper {
    public static final PredefinedVariableElement LOOP_COUNTER = new PredefinedVariableElement("loopCounter", CatalogType.Default.getInt(), ProjectMsg.PREDEF_VAR_DESC_LOOP_COUNTER);
    public static final PredefinedVariableElement STATE = new PredefinedVariableElement("state", CatalogType.Default.getString(), ProjectMsg.PREDEF_VAR_DESC_STATE);
    public static final PredefinedVariableElement NUMBER_OF_INSTANCES = new PredefinedVariableElement("numberOfInstances", CatalogType.Default.getInt(), ProjectMsg.PREDEF_VAR_DESC_NUMBER_OF_INSTANCES);
    public static final PredefinedVariableElement NUMBER_OF_ACTIVE_INSTANCES = new PredefinedVariableElement("numberOfActiveInstances", CatalogType.Default.getInt(), ProjectMsg.PREDEF_VAR_DESC_NUMBER_OF_ACTIVE_INSTANCES);
    public static final PredefinedVariableElement NUMBER_OF_COMPLETED_INSTANCES = new PredefinedVariableElement("numberOfCompletedInstances", CatalogType.Default.getInt(), ProjectMsg.PREDEF_VAR_DESC_NUMBER_OF_COMPLETED_INSTANCES);
    public static final PredefinedVariableElement NUMBER_OF_TERMINATED_INSTANCES = new PredefinedVariableElement("numberOfTerminatedInstances", CatalogType.Default.getInt(), ProjectMsg.PREDEF_VAR_DESC_NUMBER_OF_TERMINATED_INSTANCES);
    public static final PredefinedVariableElement INPUT_DATAITEM = new PredefinedVariableElement("inputDataItem", CatalogType.Default.getAny(), ProjectMsg.PREDEF_VAR_DESC_INPUT_DATAITEM);
    public static final PredefinedVariableElement OUTPUT_DATAITEM = new PredefinedVariableElement("outputDataItem", CatalogType.Default.getAny(), ProjectMsg.PREDEF_VAR_DESC_OUTPUT_DATAITEM);
    public static final PredefinedVariableElement LOOP_DATAINPUT = new PredefinedVariableElement("loopDataInput", CatalogType.Default.getAny(), ProjectMsg.PREDEF_VAR_DESC_LOOP_DATAINPUT);
    public static final PredefinedVariableElement LOOP_DATAOUTPUT = new PredefinedVariableElement("loopDataOutput", CatalogType.Default.getAny(), ProjectMsg.PREDEF_VAR_DESC_LOOP_DATAOUTPUT);
    public static final PredefinedVariableElement ACTIVATION_COUNT = new PredefinedVariableElement("activationCount", CatalogType.Default.getInt(), ProjectMsg.PREDEF_VAR_DESC_ACTIVATION_COUNT);
    public static final PredefinedVariableElement COMPLETION_CONDITION = new PredefinedVariableElement("completionCondition", CatalogType.Default.getAny(), Msg.QUOTE(""));

    private PredefinedVariablesHelper() {
    }

    public static Sequence<DataDeclaration> appendPredefinedVariablesForContainer(@NotNull Sequence<DataDeclaration> dataDeclarations, @NotNull DataDeclarationContainer container) {
        ArrayList<DataDeclaration> result = new ArrayList<DataDeclaration>();
        HashSet<String> added = new HashSet<String>();
        for (DataDeclaration local : dataDeclarations) {
            result.add(local);
            added.add(local.getName());
        }
        for (DataDeclaration predefinedVariable : PredefinedVariablesHelper.getPredefinedVariablesForProjectObject(container, container)) {
            if (!added.add(predefinedVariable.getName())) continue;
            result.add(predefinedVariable);
        }
        return CollectionUtils.asSequence(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Sequence<DataDeclaration> getPredefinedVariablesForProjectObject(@NotNull DataDeclarationContainer predefinedParent, @NotNull ProjectObject projectObject) {
        ArrayList<DataDeclaration> result = new ArrayList<DataDeclaration>();
        if (Process.class.isAssignableFrom(projectObject.getRawClass())) return CollectionUtils.asSequence(result);
        if (Activity.class.isAssignableFrom(projectObject.getRawClass())) {
            DataDeclarationType type = DataDeclarationType.ACTIVITY_PREDEFINED_VARIABLE;
            Activity activity = (Activity)projectObject;
            if (activity.getLoopCharacteristicsType() == LoopCharacteristicsType.MULTIINSTANCE) {
                DataDeclaration dataOutput;
                MultiInstance multiInstance = activity.getLoopCharacteristics().as(MultiInstance.class);
                PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, LOOP_COUNTER, type, true);
                PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, NUMBER_OF_INSTANCES, type, true);
                PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, NUMBER_OF_ACTIVE_INSTANCES, type, true);
                PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, NUMBER_OF_COMPLETED_INSTANCES, type, true);
                PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, NUMBER_OF_TERMINATED_INSTANCES, type, true);
                DataDeclaration dataInput = multiInstance.getLoopDataInput();
                if (dataInput != null) {
                    PredefinedVariableElement loopDataInputElement = new PredefinedVariableElement(LOOP_DATAINPUT.getName(), dataInput.getType(), LOOP_DATAINPUT.getDescription());
                    PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, loopDataInputElement, type, true);
                    CatalogType inputElementType = dataInput.getType().getElementType();
                    if (inputElementType != null) {
                        PredefinedVariableElement inputDataItemElement = new PredefinedVariableElement(INPUT_DATAITEM.getName(), inputElementType, INPUT_DATAITEM.getDescription());
                        PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, inputDataItemElement, type, false);
                    }
                }
                if ((dataOutput = multiInstance.getLoopDataOutput()) != null) {
                    PredefinedVariableElement loopDataOutputElement = new PredefinedVariableElement(LOOP_DATAOUTPUT.getName(), dataOutput.getType(), LOOP_DATAOUTPUT.getDescription());
                    PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, loopDataOutputElement, type, true);
                    CatalogType outputElementType = dataOutput.getType().getElementType();
                    if (outputElementType != null) {
                        PredefinedVariableElement outputDataItemElement = new PredefinedVariableElement(OUTPUT_DATAITEM.getName(), outputElementType, OUTPUT_DATAITEM.getDescription());
                        PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, outputDataItemElement, type, false);
                    }
                }
            } else if (activity.getLoopCharacteristicsType() == LoopCharacteristicsType.LOOP) {
                PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, LOOP_COUNTER, type, true);
            }
            if (!activity.getRawClass().isAssignableFrom(UserTask.class)) return CollectionUtils.asSequence(result);
        }
        if (!ComplexGateway.class.isAssignableFrom(projectObject.getRawClass())) return CollectionUtils.asSequence(result);
        DataDeclarationType type = DataDeclarationType.GATEWAY_PREDEFINED_VARIABLE;
        PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, STATE, type, true);
        PredefinedVariablesHelper.addPredefinedVariableToList(predefinedParent, result, ACTIVATION_COUNT, type, true);
        return CollectionUtils.asSequence(result);
    }

    private static void addPredefinedVariableToList(@NotNull DataDeclarationContainer container, @NotNull List<DataDeclaration> list, @NotNull PredefinedVariableElement element, @NotNull DataDeclarationType type, boolean isReadOnly) {
        PredefinedVariable predefinedVariable = new PredefinedVariable(container, element.getName(), element.getType(), type, element.getDescription());
        predefinedVariable.setReadOnly(isReadOnly);
        list.add(predefinedVariable);
    }

    public static class PredefinedVariableElement {
        private final Msg description;
        private final String name;
        private final CatalogType type;

        PredefinedVariableElement(@NotNull String name, @NotNull CatalogType type, @NotNull Msg description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public CatalogType getType() {
            return this.type;
        }

        public Msg getDescription() {
            return this.description;
        }
    }
}

