/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.geom.Point;
import oracle.bpm.log.Log;
import oracle.bpm.project.FeaturesByMeasurement;
import oracle.bpm.project.MeasurementReferenceFeature;
import oracle.bpm.project.MeasurementTypeFeature;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.TransitionReferenceFeature;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasurementImpl
extends ProcessObjectImpl
implements Serializable,
Cloneable,
Measurement {
    private ArrayList<ProjectDataObject> businessIndicators = new ArrayList();
    private NodeContainer container;
    private Features features;
    private IntFeature h = IntFeature.create("h", 0);
    private IntFeature w = IntFeature.create("w", 0);
    private IntFeature x = IntFeature.create("x", 0);
    private IntFeature y = IntFeature.create("y", 0);
    static final long serialVersionUID = 7035407680783135711L;
    static final long serialCheck = 6623176170146735726L;

    public MeasurementImpl(@NotNull Process process, @NotNull NodeContainer container, @Nullable String id) {
        super(process);
        this.setId(id);
        this.container = container;
        this.addModificationListener(this.x, this.y, this.w, this.h);
        this.initFeatures();
    }

    public static String getBAMMeasurementMarkId(String markId) {
        return markId + "[MARK]";
    }

    public void setLocation(String s) {
        this.setLocation(new Point(s));
    }

    @Override
    public Sequence<ProjectDataObject> getBusinessIndicators() {
        if (this.getMeasurementType() == MeasurementType.STOP) {
            return this.getRelatedProjectDataObjects();
        }
        return CollectionUtils.asSequence(this.businessIndicators);
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        Feature<T> tFeature = this.getFeature(clazz);
        return tFeature.getValue();
    }

    public void afterAdd() throws ProjectException {
    }

    public void afterRemove() throws ProjectException {
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
    }

    public boolean isDuplicated(List list) {
        for (Object aList : list) {
            MeasurementImpl fuegoActivity = (MeasurementImpl)aList;
            if (!this.getLabelMap().getString().equals(fuegoActivity.getDefaultLabel()) || this.getId().equals(fuegoActivity.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocaleStringMap getLabelMap() {
        Measurement relatedMeasurement = this.getRelatedMeasurement();
        if (this.getMeasurementType() == MeasurementType.STOP && relatedMeasurement != null && relatedMeasurement != this) {
            return relatedMeasurement.getLabelMap();
        }
        LocaleStringMap labels = super.getLabelMap();
        if (labels.getString() == null) {
            labels.setString(this.getId());
        }
        return labels;
    }

    @Override
    public void setRelatedMeasurement(Measurement relatedMeasurement) {
        if (this.getMeasurementType() == MeasurementType.STOP) {
            if (relatedMeasurement == null) {
                throw new IllegalArgumentException("A STOP measurement mark cannot be related to a null measurement.");
            }
            if (relatedMeasurement.getMeasurementType() != MeasurementType.START) {
                throw new IllegalArgumentException("A STOP measurement mark can only be related to a START measurement.");
            }
        }
        MeasurementReferenceFeature measurementReference = this.getFeature(MeasurementReferenceFeature.class);
        measurementReference.setValue(relatedMeasurement.getId());
    }

    @Override
    public Measurement getRelatedMeasurement() {
        MeasurementReferenceFeature measurementReference = this.getFeature(MeasurementReferenceFeature.class);
        return this.getProcess().findDescendant(Measurement.class, measurementReference.getValue());
    }

    public void setTransition(String t) {
        TransitionReferenceFeature referenceFeature = this.getFeature(TransitionReferenceFeature.class);
        referenceFeature.setValue(t);
    }

    @Override
    public SequenceFlow getTransition() {
        TransitionReferenceFeature referenceFeature = this.getFeature(TransitionReferenceFeature.class);
        return this.getParentObject().findSequenceFlow(referenceFeature.getValue());
    }

    @Override
    public void setTransition(SequenceFlow sequenceFlow) {
        this.setTransition(sequenceFlow != null ? sequenceFlow.getId() : null);
    }

    @Override
    public void setMeasurementType(MeasurementType type) {
        this.getFeature(MeasurementTypeFeature.class).setValue(type);
    }

    @Override
    public void setLocation(Point point) {
        this.x.setValue(point.getX());
        this.y.setValue(point.getY());
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }

    public void setType(String typeName) {
        this.setMeasurementType(MeasurementType.valueOf((String)typeName));
    }

    @Override
    public MeasurementType getMeasurementType() {
        return (MeasurementType)this.getFeature(MeasurementTypeFeature.class).getValue();
    }

    @Override
    public void addBusinessIndicator(ProjectDataObject projectDataObject) throws ProjectException {
        if (this.getMeasurementType() != MeasurementType.STOP) {
            this.businessIndicators.add(projectDataObject);
        } else if (this.getRelatedMeasurement() != null && !this.getRelatedMeasurement().containsBusinessIndicator(projectDataObject)) {
            this.getRelatedMeasurement().addBusinessIndicator(projectDataObject);
        }
    }

    public void check(ProjectMessageListener listener, CheckOptions options) throws ModelException {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.logWarning(e);
            return null;
        }
    }

    @Override
    public boolean containsBusinessIndicator(ProjectDataObject projectDataObject) {
        return this.businessIndicators.contains(projectDataObject);
    }

    public String toString() {
        return this.getLabelMap().getString();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public int getWidth() {
        return this.w.getValue();
    }

    @Override
    public int getHeight() {
        return this.h.getValue();
    }

    @Override
    public int getX() {
        return this.x.getValue();
    }

    @Override
    public int getY() {
        return this.y.getValue();
    }

    @Override
    public Lane getLane() {
        return null;
    }

    @Override
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void setX(int x) {
        this.x.setValue(x);
    }

    @Override
    public void setY(int y) {
        this.y.setValue(y);
    }

    @Override
    public void setHeight(int height) {
        this.h.setValue(height);
    }

    @Override
    public void setWidth(int width) {
        this.w.setValue(width);
    }

    @Override
    public Class getRawClass() {
        return Measurement.class;
    }

    @Override
    public void setLane(Lane lane) {
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MEASUREMENT;
    }

    @Override
    public void afterAdd(ProjectObjectContainer objectContainer) throws ProjectException {
        this.container = (NodeContainer)objectContainer;
    }

    @Override
    public NodeContainer getParentObject() {
        return this.container;
    }

    @Override
    public void applyFrom(@NotNull Measurement measurement) throws ProjectException {
        this.copy((MeasurementImpl)measurement, this);
    }

    @Override
    public void removeBusinessIndicator(ProjectDataObject unnasignedBusinessIndicator) {
        this.businessIndicators.remove(unnasignedBusinessIndicator);
    }

    private void copy(@NotNull MeasurementImpl source, @NotNull MeasurementImpl target) {
        target.setId(source.getId());
        target.setDefaultLabel(source.getDefaultLabel());
        target.getFeatures().copyFrom(source.getFeatures());
        target.setLabelMap(source.getLabelMap().clone());
        target.setDescription(source.getDescriptionMap().clone());
        target.setTransition(source.getTransition());
        target.setWidth(source.getWidth());
        target.setHeight(source.getHeight());
        target.setX(source.getX());
        target.setY(source.getY());
    }

    private Sequence<ProjectDataObject> getRelatedProjectDataObjects() {
        Measurement relatedMeasurement = this.getRelatedMeasurement();
        if (relatedMeasurement != null) {
            return relatedMeasurement.getBusinessIndicators();
        }
        return CollectionUtils.emptySequence();
    }

    private void initFeatures() {
        this.features = FeaturesByMeasurement.get(this);
        this.addModificationListener(this.features);
    }
}

