/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Any;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.compile.exceptions.ParametricRoleMustHaveAParameterException;
import oracle.bpm.project.compile.exceptions.RoleNotFoundException;
import oracle.bpm.project.model.ModelObjectType;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public class LaneImpl
extends ProcessObjectImpl
implements Serializable,
Lane.Mutable {
    private ModificationAwareLocaleStringMap description;
    private boolean isParametric;
    private ModificationAwareLocaleStringMap labelMap;
    private IntFeature offset = IntFeature.create("offset", 0);
    private transient String paramName_d;
    private transient int prevSize = 200;
    private IntFeature size = IntFeature.create("size", 200);
    static final long serialVersionUID = -7303628107123112676L;
    private static HashMap<String, String> predefinedRolesById = new HashMap();
    private static HashMap<String, String> predefinedRolesByLabel = new HashMap();
    public static final String ALL_ROLE = "$All";
    public static int MAX_ROLE_NAME = 15;
    public static int MAX_ROLE_DESC = 30;
    public static int FIRST = 0;
    public static int LAST = 1;
    public static int MIDDLE = 2;
    static final long serialCheck = -5115812233367903589L;

    public LaneImpl(ProcessContent process) {
        super(process);
        this.addModificationListener(this.size, this.offset);
    }

    public static String findParameterName(Process content, String roleName) {
        String result = null;
        for (Lane lane : content.getLanes()) {
            if (!lane.getId().equals(roleName)) continue;
            result = lane.getParamName();
        }
        return result;
    }

    public static String getAutomaticHandlerDisplayName() {
        return ProjectMsg.AUTOMATIC_HANDLER_ROLE.getString();
    }

    public static String getAllRoleDisplayName() {
        return ProjectMsg.ALL_ROLE.getString();
    }

    public static String getIdForDisplayName(String displayName) {
        return predefinedRolesByLabel.get(displayName);
    }

    public static boolean isPredefined(String name) {
        return predefinedRolesById.get(name) != null;
    }

    @Override
    public String getDefaultLabel() {
        return this.getName();
    }

    @Override
    public void addedActivity(FlowNode node) {
        this.events().objectChanged();
    }

    @Override
    public String getName() {
        Role role = this.getRole();
        return role != null ? role.getName() : this.getId();
    }

    @Override
    public Features getFeatures() {
        return null;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        return null;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return null;
    }

    public void afterAdd() throws ProjectException {
    }

    public void afterRemove() throws ProjectException {
    }

    @Override
    public void removedActivity(FlowNode fuegoNode) {
        this.events().objectChanged();
    }

    @Override
    @NotNull
    public Sequence<FlowNode> getActivities() {
        Predicate<FlowNode> equalsLane = new Predicate<FlowNode>(){

            @Override
            public boolean check(FlowNode flowNode) {
                return flowNode.getLane() == LaneImpl.this;
            }
        };
        return this.getProcess().getFlowNodes().select(equalsLane);
    }

    public List<FlowNode> getActivityList() {
        TreeMap<String, FlowNode> map = new TreeMap<String, FlowNode>();
        FlowNodeIterator iterator = this.activities();
        while (iterator.hasNext()) {
            FlowNode activity = iterator.nextActivity();
            map.put(activity.getId(), activity);
        }
        return new ArrayList<FlowNode>(map.values());
    }

    public boolean isAll() {
        return this.getId().equals(ALL_ROLE);
    }

    public ModelObjectType getComponentType() {
        return ModelObjectType.LANE;
    }

    @Override
    public void setSize(int size) {
        this.size.setValue(size);
    }

    public boolean isAdjustable() {
        return false;
    }

    @Override
    public int getOffset() {
        return this.offset.getValue();
    }

    @Override
    public String getParamName() {
        return this.paramName_d;
    }

    @Override
    public boolean isAutomatic() {
        return this.getId().equals("AutomaticHandler");
    }

    @Override
    public boolean isHidden() {
        return this.size.getValue() == 1;
    }

    @Override
    @NotNull
    public Lane.Mutable asMutable() {
        return this;
    }

    public void setParamVar(String name) {
        this.paramName_d = name;
    }

    public void setParameterName(String name) {
        String oldValue = this.paramName_d;
        this.paramName_d = name;
        if (Any.equals(oldValue, this.paramName_d)) {
            this.events().objectChanged("paramName", oldValue, this.paramName_d);
        }
    }

    @Override
    public boolean isParametric() {
        if (this.project != null) {
            Role role = this.getRole();
            this.isParametric = role != null && role.isParametric();
        }
        return this.isParametric;
    }

    public void setPrevWidth(int w) {
        this.prevSize = w;
    }

    public int getPrevSize() {
        return this.prevSize;
    }

    @Override
    public int getSize() {
        return this.size.getValue();
    }

    @Override
    public void setOffset(int newOffset) {
        NavigableMap<Integer, Lane> lanes = this.getProcessContent().getLanesInternal();
        Lane lane = (Lane)lanes.get(this.offset.getValue());
        if (lane != null && lane.equals(this)) {
            lanes.remove(this.offset.getValue());
        }
        this.offset.setValue(newOffset);
        lanes.put(newOffset, this);
    }

    public FlowNodeIterator activities() {
        return new FlowNodeIterator(false);
    }

    public FlowNodeIterator activitiesInColumn() {
        return new FlowNodeIterator(true);
    }

    @Override
    public Path getPath() {
        return this.getParentObject().getPath().create(this.getId());
    }

    public void check(ProjectMessageListener listener) throws ModelException {
        if (!this.isAutomatic() && this.getRole() == null) {
            RoleNotFoundException e = new RoleNotFoundException((Lane)this);
            if (listener != null) {
                listener.reportError(this, (ProjectException)e);
            } else {
                throw e;
            }
        }
        if (this.isParametric() && (this.getParamName() == null || "".equals(this.getParamName()))) {
            ParametricRoleMustHaveAParameterException ex = new ParametricRoleMustHaveAParameterException((Lane)this);
            if (listener != null) {
                listener.reportError(this, (ProjectException)ex);
            } else {
                throw ex;
            }
        }
    }

    public boolean contains(int coordinate) {
        return coordinate >= this.getOffset() && coordinate < this.getOffset() + this.getSize();
    }

    public boolean contains(FlowNode a) {
        return this.contains(a.getX());
    }

    public void dumpMetaData(BufferedWriter bufferedWriter) throws IOException {
        String desc;
        Locale langId;
        bufferedWriter.write("      Name:   " + this.getId());
        bufferedWriter.newLine();
        bufferedWriter.write("      Virtual:     " + this.isAutomatic());
        bufferedWriter.newLine();
        if (this.isParametric()) {
            bufferedWriter.write("  Param Name:     " + this.getParamName());
            bufferedWriter.newLine();
        }
        bufferedWriter.write("      * Role Label *");
        bufferedWriter.newLine();
        Set<Map.Entry<Locale, String>> labelIt = this.getLabelMap().entrySet();
        for (Map.Entry<Locale, String> entry : labelIt) {
            langId = entry.getKey();
            desc = entry.getValue();
            if (desc == null || "".equals(desc)) continue;
            bufferedWriter.write("      Language:       " + langId.getLanguage());
            bufferedWriter.newLine();
            bufferedWriter.write("      Description:    " + desc.trim());
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        bufferedWriter.write("      * Role Description *");
        bufferedWriter.newLine();
        labelIt = this.getDescriptionMap().entrySet();
        for (Map.Entry<Locale, String> entry : labelIt) {
            langId = entry.getKey();
            desc = entry.getValue();
            if (desc == null || "".equals(desc)) continue;
            bufferedWriter.write("      Language:       " + langId.getLanguage());
            bufferedWriter.newLine();
            bufferedWriter.write("      Description:    " + desc.trim());
            bufferedWriter.newLine();
        }
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    public String toString() {
        return " Name " + this.getLabelMap().getString() + " Location " + this.getOffset() + " Width " + this.getSize();
    }

    @Override
    public Role getRole() {
        Organization organization;
        Role role = null;
        Project p = this.getProject();
        if (p != null && p.isOpen() && (organization = p.getOrganization()) != null) {
            role = organization.findRoleById(this.getId());
        }
        return role;
    }

    public boolean existRole() {
        Role role = this.getRole();
        if (role == null) {
            System.out.println("LaneImpl.existRole() roleInfo=" + this.getId());
        }
        return role != null;
    }

    @Override
    public void setLabelMap(LocaleStringMap labelMap) {
        if (this.labelMap == null) {
            this.labelMap = this.createLocaleStringMap();
        }
        this.labelMap.replaceValues(labelMap);
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        if (this.description == null) {
            this.description = this.createLocaleStringMap();
        }
        return this.description;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.LANE;
    }

    @Override
    public Class getRawClass() {
        return Lane.class;
    }

    @Override
    public void setParamName(String name) {
        this.setParameterName(name);
    }

    @Override
    public void setIsParametric(boolean parametric) {
        this.isParametric = parametric;
    }

    public void setParametric(String parametric) {
        this.setIsParametric(Boolean.valueOf(parametric));
    }

    @Override
    protected void idChanged(String previousId) {
        if (this.getId() != null && ("0".equals(this.getId()) || this.getId().startsWith("9999"))) {
            this.setId(previousId);
        }
    }

    protected void fixRoleLocations(int fromX, int shift) {
        Sequence<Lane> lanes = this.getProcess().getLanes();
        if (!lanes.contains(this)) {
            return;
        }
        for (Lane lane : lanes) {
            int loc;
            if (lane == this || (loc = lane.getOffset()) < fromX) continue;
            lane.asMutable().setOffset(loc + shift);
        }
    }

    protected int fixX(int xcoordinate, boolean before) {
        int maxX = 0;
        for (Lane lane : this.getProcess().getLanes()) {
            if (lane == this) continue;
            int leftX = lane.getOffset();
            int rigthX = leftX + lane.getSize();
            if (xcoordinate >= leftX && xcoordinate < rigthX) {
                return before ? leftX : rigthX;
            }
            maxX = Math.max(maxX, rigthX);
        }
        return maxX;
    }

    private void syncLabelsWithRole() {
        if (this.labelMap == null) {
            this.labelMap = this.createLocaleStringMap();
        }
        if (this.getRole() != null) {
            this.labelMap.replaceValues(this.getRole().getLabelMap());
        }
    }

    private ModificationAwareLocaleStringMap createLocaleStringMap() {
        ModificationAwareLocaleStringMap result = new ModificationAwareLocaleStringMap(this);
        result.setString(this.getId());
        result.addModificationListener(new ModificationListener<ProjectObject>(){

            @Override
            public void objectModified(ModificationEvent<ProjectObject> event) {
                LaneImpl.this.fireObjectChanged(LaneImpl.this, ProjectEvent.CHANGE(LaneImpl.this, null, event.getOldValue(), event.getNewValue()));
            }
        });
        return result;
    }

    static {
        predefinedRolesById.put("AutomaticHandler", LaneImpl.getAutomaticHandlerDisplayName());
        predefinedRolesById.put(ALL_ROLE, LaneImpl.getAllRoleDisplayName());
        predefinedRolesByLabel.put(LaneImpl.getAutomaticHandlerDisplayName(), "AutomaticHandler");
        predefinedRolesByLabel.put(LaneImpl.getAllRoleDisplayName(), ALL_ROLE);
    }

    public class FlowNodeIterator
    implements Iterator<FlowNode> {
        private boolean inColumn;
        private Iterator it;
        private FlowNode next;

        public FlowNodeIterator(boolean inColumn) {
            this.inColumn = inColumn;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FlowNode next() {
            return this.nextActivity();
        }

        public FlowNode nextActivity() {
            FlowNode result = this.next;
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            this.it = LaneImpl.this.getProcess().getFlowNodes().iterator();
            this.advance();
        }

        private void advance() {
            while (this.it.hasNext()) {
                ActivityImpl a = (ActivityImpl)this.it.next();
                if (a.getLane() != null && !a.getLane().getId().equals(LaneImpl.this.getId()) || this.inColumn && !LaneImpl.this.contains(a)) continue;
                this.next = a;
                return;
            }
            this.next = null;
        }
    }
}

