/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.log.Log;
import oracle.bpm.util.Identifier;
import org.xml.sax.Attributes;

public class GenericContent {
    private List<String> warningList = new ArrayList<String>();
    private static final Class[] STRING_ARRAY = new Class[]{String.class};

    public String getClassName() {
        String className = this.getClass().getName();
        int indexOfDot = className.lastIndexOf(46);
        if (indexOfDot >= 0) {
            className = className.substring(indexOfDot + 1);
        }
        return className;
    }

    public GenericContent[][] getContents() {
        Method[] mtds = this.getClass().getMethods();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Method mtd : mtds) {
            if (mtd.getReturnType().getComponentType() == null || mtd.getReturnType().getComponentType() != Void.class) {
                // empty if block
            }
            String name = mtd.getName();
            Class<?> returnType = mtd.getReturnType();
            if (!name.startsWith("get") || name.equals("getContents") || !mtd.getReturnType().isArray() || mtd.getParameterTypes().length != 0 || mtd.getReturnType().getComponentType() == null || returnType.getComponentType() == Void.class || !GenericContent.class.isAssignableFrom(mtd.getReturnType().getComponentType())) continue;
            try {
                list.add(mtd.invoke((Object)this, (Object[])null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace();
            }
        }
        return (GenericContent[][])list.toArray((T[])new GenericContent[list.size()][]);
    }

    public StringList getIgnoredPropertiesGetters() {
        return StringList.create("getIgnoredPropertiesGetters", "getWarningMessage", "getWarnings");
    }

    public Properties getProperties() {
        Method[] mtds;
        Properties props = new Properties();
        for (Method mtd : mtds = this.getClass().getMethods()) {
            Object o;
            String name;
            block9: {
                name = mtd.getName();
                if (this.getIgnoredPropertiesGetters().contains(name) || !name.startsWith("get") || name.equals("getProperties") || name.equals("getClassName") || mtd.getReturnType() == Void.class || mtd.getReturnType().isArray() || mtd.getDeclaringClass() == Object.class || !Modifier.isPublic(mtd.getModifiers()) || mtd.getParameterTypes().length != 0) continue;
                String setterName = name.replaceFirst("get", "set");
                try {
                    this.getClass().getMethod(setterName, STRING_ARRAY);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                catch (SecurityException e) {
                    continue;
                }
                try {
                    o = mtd.invoke((Object)this, new Object[0]);
                    if (o == null) {
                    }
                    break block9;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    if (e.getCause() == null) continue;
                    e.getCause().printStackTrace();
                }
                continue;
            }
            props.put(name.substring(3), o.toString());
        }
        return props;
    }

    public String getWarningMessage() {
        String result = "";
        if (this.getWarnings().size() > 0) {
            for (String s : this.getWarnings()) {
                result = result + s.replace('\n', ' ') + "\n";
            }
        }
        return result;
    }

    public List<String> getWarnings() {
        return this.warningList;
    }

    public void setProperties(Attributes props) throws InvocationTargetException, IllegalAccessException {
        this.setProperties(props, null);
    }

    public void setProperties(Attributes props, List validValues) throws InvocationTargetException, IllegalAccessException {
        int length = props.getLength();
        for (int i = 0; i < length; ++i) {
            String key = props.getQName(i);
            String value = props.getValue(i);
            this.setProperty(key, value, validValues);
        }
    }

    public void setProperty(String key, String value) throws InvocationTargetException, IllegalAccessException {
        this.setProperty(key, value, null);
    }

    public void setProperty(String key, String value, List validValues) throws InvocationTargetException, IllegalAccessException {
        Class<?> cl = this.getClass();
        Object[] arg = new Object[1];
        if (validValues != null && !validValues.contains(key)) {
            Log.logDebug("key = " + key);
            Log.logDebug(new Exception("Stack trace"));
            return;
        }
        String methodName = "set".concat(Identifier.capitalize(key));
        try {
            Method m = cl.getMethod(methodName, STRING_ARRAY);
            arg[0] = value;
            m.invoke((Object)this, arg);
        }
        catch (NoSuchMethodException e) {
            this.getWarnings().add("No method " + e.getMessage() + " in class: " + this.getClass().getName() + ". Will ignore property: " + key);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t != null) {
                Log.logWarning(t);
            }
            throw e;
        }
        catch (SecurityException e) {
            Log.logWarning(e);
        }
    }
}

