/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.Environment;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.log.Log;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.FuegoProcessList;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.ProjectSearchResult;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.ResourceFilesContainerImpl;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.compiler.ProjectCompiler;
import oracle.bpm.project.dashboard.DashboardModelImpl;
import oracle.bpm.project.dashboard.WidgetDataModelImpl;
import oracle.bpm.project.dashboard.WidgetModelImpl;
import oracle.bpm.project.events.EventSource;
import oracle.bpm.project.fojsp.WebRootContainerImpl;
import oracle.bpm.project.forms.FormsContainerImpl;
import oracle.bpm.project.model.BusinessParametersContainer;
import oracle.bpm.project.model.CompiledProject;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectGenerateEvents;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogAdapter;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.configuration.ProjectConfigurationManager;
import oracle.bpm.project.model.dashboard.DashboardModel;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.project.model.deployment.Deployment;
import oracle.bpm.project.model.deployment.DeploymentImpl;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.fojsp.WebRootContainer;
import oracle.bpm.project.model.forms.FormsContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.presentations.PresentationManager;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.presentation.views.ViewManager;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.BusinessParametersContainerImpl;
import oracle.bpm.project.organization.OrganizationImpl;
import oracle.bpm.project.preferences.ProjectPreferencesImpl;
import oracle.bpm.project.presentation.presentations.PresentationManagerAdapter;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.CatalogListener;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.LazyHolder;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuegoProject
extends ResourceContainerImpl
implements CompiledProject {
    @Nullable
    private BusinessParametersContainer businessParametersContainer;
    @NotNull
    private final Map<String, CatalogObject> catalogObjects = new HashMap<String, CatalogObject>();
    @Nullable
    private List<DashboardModel> dashboardList;
    @Nullable
    private Collection<ProjectDataObject> defaultDataObjects;
    private ObjectPropertyListener dependencyPropertyListener;
    @Nullable
    private DeploymentImpl deployment;
    @Nullable
    private FormsContainer formsRoot;
    private FolderContainer modelsRoot;
    private boolean open;
    @Nullable
    private Organization organization;
    private final LazyHolder<ProjectPreferences> preferencesHolder = this.buildPreferencesHolder();
    @Nullable
    private PresentationManager presentationManager;
    @NotNull
    private final LazyHolder<ComponentCatalog> projectCatalogHolder = this.buildCatalogHolder();
    private ProjectConfigurationManager projectConfigurationManager;
    private ProjectLoader projectLoader;
    private Process projectModel;
    private String projectName;
    private ProjectWriter projectWriter;
    private ProjectRepository repository;
    @Nullable
    private ResourceFilesContainer resourceFilesContainer;
    @Nullable
    private SimulationsContainer simulationsContainer;
    private ViewManager viewManager;
    @Nullable
    private WebRootContainer webRootContainer;
    @Nullable
    private List<WidgetModel> widgetList;

    protected FuegoProject(String projectName) {
        super(null);
        this.project = this;
        this.projectName = projectName;
        this.events().enable();
    }

    public static FuegoProject getFrom(TypeRef ref) {
        FuegoProject result = null;
        if (ref instanceof ProjectObject) {
            result = (FuegoProject)FuegoProject.getFrom((ProjectObject)ref);
        } else if (ref != null) {
            int kind = ref.getKind();
            if (kind == 11 || kind == 17) {
                MutableComponentCatalog catalog = (MutableComponentCatalog)ref.getCatalog();
                if (catalog != null) {
                    result = (FuegoProject)catalog.getOwner();
                }
            } else {
                result = FuegoProject.getFrom((TypeRef)ref.get().getParent());
            }
        }
        return result;
    }

    public static FuegoProject create(String projectName) {
        return new FuegoProject(projectName);
    }

    public static FuegoProject createInMemory(String projectName) {
        FuegoProject project = new FuegoProject(projectName);
        try {
            Process projectModel = ProjectResourceObjectFactory.createProjectProcess(project, "default", true);
            project.setProjectModel(projectModel);
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
        return project;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getProjectModel().getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getProjectModel().getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getProjectModel().getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getProjectModel().getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this;
    }

    @Override
    public Path getPath() {
        return Path.ROOT;
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
        switch (newObject.getProjectObjectType()) {
            case MODEL_CONTAINER: {
                break;
            }
            case PROJECT: {
                break;
            }
            case PROJECT_SIMULATION: {
                this.getSimulations().replaceProjectSimulation((ProjectSimulation)newObject);
                break;
            }
            case UDDI_PROCESS_PUBLICATION: {
                break;
            }
            case VIEW_ACTIVITY_INSTANCES: {
                View oldView = this.getViewManager().getView(newObject.getId());
                this.viewManager.replaceChild(oldView, newObject);
                break;
            }
            case VIEW_APPLICATIONS: {
                View oldAppView = this.getViewManager().getView(newObject.getId());
                this.viewManager.replaceChild(oldAppView, newObject);
                break;
            }
            case VIEW_ATTACHMENTS: {
                View oldAttachmentView = this.getViewManager().getView(newObject.getId());
                this.viewManager.replaceChild(oldAttachmentView, newObject);
                break;
            }
            case VIEW_FOLDERS: {
                View oldFolderView = this.getViewManager().getView(newObject.getId());
                this.viewManager.replaceChild(oldFolderView, newObject);
                break;
            }
            case VIEW_INSTANCES: {
                View oldInstanceView = this.getViewManager().getView(newObject.getId());
                this.viewManager.replaceChild(oldInstanceView, newObject);
                break;
            }
            case PRESENTATION: {
                Presentation oldObject = this.getPresentationManager().getPresentation(newObject.getId());
                this.presentationManager.replaceChild(oldObject, newObject);
                break;
            }
            case WIDGET: {
                break;
            }
            case ACTIVITY: {
                break;
            }
            case ALL: {
                break;
            }
            case ATTRIBUTE: {
                break;
            }
            case ATTRIBUTE_GROUP: {
                break;
            }
            case COMPONENT: {
                break;
            }
            case CONFIGURATION: {
                break;
            }
            case CONFIGURATION_MANAGER: {
                break;
            }
            case CONNECTOR: {
                break;
            }
            case CORRELATION: {
                break;
            }
            case DASHBOARD: {
                break;
            }
            case ENGINE: {
                break;
            }
            case EXTERNAL_RESOURCE: {
                break;
            }
            case BPM_OBJECT: {
                break;
            }
            case INSTANCE_VARIABLE: {
                break;
            }
            case LANE: {
                break;
            }
            case MAPPING: {
                break;
            }
            case MEASUREMENT: {
                break;
            }
            case METHOD: {
                break;
            }
            case MODEL: {
                Process model = (Process)newObject;
                if (ProcessContent.isDefaultProcess(model)) {
                    this.replaceProjectModel(this.getProjectModel(), model);
                    break;
                }
                model.getParentObject().replace(newObject);
                break;
            }
            case MODEL_SIMULATION: {
                this.getSimulations().replaceModelSimulation((ModelSimulation)newObject);
                break;
            }
            case NOTE: {
                break;
            }
            case OU: {
                ((OrganizationImpl)this.getOrganization()).replaceOrganizationalUnit((OrganizationalUnit)newObject);
                break;
            }
            case ORGANIZATIONAL_CHART: {
                ((OrganizationImpl)this.getOrganization()).replaceOrganizationalChart((OrganizationalChart)newObject);
                break;
            }
            case ORGANIZATION_ROLE: {
                ((OrganizationImpl)this.getOrganization()).replaceRole((Role)newObject);
                break;
            }
            case ORGANIZATION_GROUP: {
                ((OrganizationImpl)this.getOrganization()).replaceGroup((Group)newObject);
                break;
            }
            case PARTICIPANT: {
                ((OrganizationImpl)this.getOrganization()).replaceParticipant((Participant)newObject);
                break;
            }
            case CALENDAR_RULE: {
                ((OrganizationImpl)this.getOrganization()).replaceCalendarRule((CalendarRule)newObject);
                break;
            }
            case HOLIDAY_RULE: {
                ((OrganizationImpl)this.getOrganization()).replaceHolidayRule((HolidayRule)newObject);
                break;
            }
            case BUSINESS_PARAMETER: {
                this.businessParametersContainer.replaceBusinessParameter((BusinessParameter)newObject);
                break;
            }
            case BUSINESS_VARIABLE: {
                break;
            }
            case EXTERNAL_VARIABLE: {
                break;
            }
            case PROCESS_DEPLOYMENT: {
                break;
            }
            case PROCESS_WEB_SERVICE: {
                break;
            }
            case REFERRAL: {
                break;
            }
            case SCHEDULE: {
                break;
            }
            case SIMULATION_ACTIVITY: {
                break;
            }
            case SIMULATION_RESOURCE: {
                break;
            }
            case SIMULATION_TRANSITION: {
                break;
            }
            case TASK: {
                break;
            }
            case TOPOLOGY: {
                break;
            }
            case TRANSFORMATION: {
                break;
            }
            case TRANSFORMATION_MAPPING: {
                break;
            }
            case TRANSFORMATION_METHOD: {
                break;
            }
        }
    }

    @Override
    public void setLoader(ProjectLoader projectLoader) {
        this.projectLoader = projectLoader;
    }

    @Override
    @Nullable
    public ProjectLoader getLoader() {
        return this.projectLoader;
    }

    @Override
    public ProjectWriter getWriter() {
        return this.projectWriter;
    }

    @Override
    public void setWriter(ProjectWriter projectWriter) {
        this.projectWriter = projectWriter;
    }

    public FuegoProcessList findProjectVariableUsages(String varName, ProgressMonitor monitor) {
        FuegoProcessList processes = this.getAllProcesses();
        FuegoProcessList list = FuegoProcessList.create(processes);
        int amount = processes.size();
        int progress = 0;
        for (Process process : processes) {
            monitor.info(ProjectMsg.ANALYZING(process.getId()));
            monitor.progress(progress++ * 100 / amount);
        }
        return list;
    }

    public void dependencyChange() {
        ComponentCatalog catalog = this.projectCatalogHolder.getIfSet();
        if (catalog == null) {
            return;
        }
        MutableComponentCatalog defaultCatalog = this.getDefaultCatalog();
        ((MutableComponentCatalog)catalog).redefineParent(defaultCatalog);
    }

    public MutableComponentCatalog getDefaultCatalog() {
        Project parentProject = this.getDependency();
        return parentProject != null && parentProject.isOpen() ? (MutableComponentCatalog)parentProject.getComponentCatalog() : TypeUtils.getDefaultCatalog();
    }

    public ProjectSearchResult[] findRoleUsages(String roleName, ProgressMonitor monitor) {
        ArrayList<ProjectSearchResult> result = new ArrayList<ProjectSearchResult>();
        FuegoProcessList processes = this.getAllProcesses();
        int amount = processes.size();
        int progress = 0;
        for (Process process : processes) {
            monitor.progress(progress++ * 100 / amount);
            monitor.info(ProjectMsg.ANALYZING(process.getPath().toString()));
            ArrayList<Lane> roleList = new ArrayList<Lane>();
            for (Lane lane : process.getLanes()) {
                if (!lane.getDefaultLabel().equals(roleName)) continue;
                roleList.add(lane);
            }
            if (roleList.isEmpty()) continue;
            Object[] roles = roleList.toArray(new ModelObject[roleList.size()]);
            result.add(new ProjectSearchResult(roleName, this, process, roles));
        }
        return result.toArray(new ProjectSearchResult[result.size()]);
    }

    public FuegoProcessList getAllProcesses() {
        return FuegoProject.getRecursiveProcesses(this.getModelsRoot());
    }

    public ConnectorService getConnectorService(Environment environment) {
        return this.getProjectConfigurationManager().getConnectorService(environment);
    }

    @Override
    public Locale getDefaultLanguage() {
        return this.getPreferences().getDefaultLanguage();
    }

    @Override
    public Collection<Locale> getAvailableLanguages() {
        return Collections.unmodifiableCollection(this.getPreferences().getAvailableLanguages());
    }

    @Override
    public boolean isDefault() {
        return this.getLoader() != null && this == this.getLoader().getProjectRepository().getDefaultProject();
    }

    public void setName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getName() {
        return this.projectName;
    }

    public String getNextValidNameForProcess(String name, @Nullable SchemaType type) {
        String validName;
        String nextValidName = validName = Identifier.valid(name);
        int i = 1;
        while (this.getProcessByName(nextValidName, type) != null) {
            nextValidName = validName + i;
            ++i;
        }
        return nextValidName;
    }

    public String getNextValidNameForProcess(String name) {
        return this.getNextValidNameForProcess(name, null);
    }

    @Override
    public FolderContainer getModelsRoot() {
        if (this.modelsRoot == null) {
            FolderContainer folderContainer = this.getObject(this, FolderContainer.class, Path.PROCESSES.getName());
            this.setModelsRoot(folderContainer);
        }
        return this.modelsRoot;
    }

    @NotNull
    public WebRootContainer getWebRootContainer() {
        WebRootContainer result = this.webRootContainer;
        if (result == null) {
            this.webRootContainer = result = new WebRootContainerImpl((Project)this, Path.WEB_ROOT.getName());
        }
        return result;
    }

    public Collection<ExternalResource> getExternalResources() {
        return this.getProjectConfigurationManager().getExternalResources();
    }

    public ExternalResource.Mutable createExternalResource(String extResourceId, ConfigType subType) {
        return this.getProjectConfigurationManager().createExternalResource(extResourceId, subType);
    }

    public void addExternalResource(ExternalResource externalResource) throws ProjectException {
        this.getProjectConfigurationManager().addExternalResource(externalResource);
    }

    public ExternalResource findDeclaredExternalResource(String resourceId) {
        return this.getProjectConfigurationManager().findDeclaredExternalResource(resourceId);
    }

    @Override
    public Collection<Process> getProcesses() {
        return FuegoProject.getRecursiveProcesses(this.getModelsRoot());
    }

    public Collection<Process> getModels(SchemaType type) {
        FuegoProcessList processesOfType = this.getProcessesOfType(type);
        return new ArrayList<Process>(processesOfType);
    }

    public Process createProcess(String id) {
        try {
            return this.getModelsRoot().createModel(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Process createEmptyProcess(String id) {
        try {
            return this.getModelsRoot().createEmptyModel(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Process createCallableSubProcess(String id) {
        try {
            return this.getModelsRoot().createCallableSubprocess(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Process createCallableEmptySubProcess(String id) {
        try {
            return this.getModelsRoot().createEmptyCallableSubprocess(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addProcess(Process model) throws ProjectException {
        this.getModelsRoot().addChild(model);
    }

    @Override
    public Collection<ProjectDataObject> getProjectDataObjects() {
        ArrayList<ProjectDataObject> dataObjects = new ArrayList<ProjectDataObject>();
        for (DataObject variable : this.getProjectModel().getDataObjects()) {
            dataObjects.add((ProjectDataObject)variable);
        }
        return Collections.unmodifiableCollection(dataObjects);
    }

    @Override
    public Collection<ProjectDataObject> getDefaultVariables() {
        Collection<ProjectDataObject> result = this.defaultDataObjects;
        if (result == null) {
            this.defaultDataObjects = result = ProjectVariableImpl.createInstanceDefaults(this);
        }
        return result;
    }

    @Override
    public Collection<ProjectDataObject> getAllVariables() {
        Collection<ProjectDataObject> allDataObjects = CollectionFactory.createCollection();
        allDataObjects.addAll(this.getDefaultVariables());
        allDataObjects.addAll(this.getProjectDataObjects());
        return allDataObjects;
    }

    @Override
    public ProjectDataObject createVariable(String variableId, CatalogType type) {
        int length = -1;
        if (ProjectVariableImpl.isSupportSize(type)) {
            length = type.getLength() > -1 ? type.getLength() : ProjectVariableImpl.getDefaultLength(type);
        }
        int scale = -1;
        if (ProjectVariableImpl.isSupportScale(type)) {
            scale = type.getScale() > -1 ? type.getScale() : ProjectVariableImpl.getDefaultScale(type);
        }
        TypeDescription newType = TypeFactory.forKind((int)type.getKind(), (int)length, (int)scale).primitiveEquivalent(type.isPrimitive());
        return (ProjectDataObject)this.getProjectModel().createDataObject(variableId, CatalogObjectImpl.get((TypeRef)newType));
    }

    @Override
    public void addDataObject(ProjectDataObject dataObject) throws ProjectException {
        if (!FuegoProject.isValidType(dataObject)) {
            throw new ProjectException(dataObject, ProjectModelMsg.INVALID_CONVERT_PROJECT_VARIABLE_TYPE(dataObject.getDefaultLabel()));
        }
        this.getProjectModel().addDataObject(dataObject);
    }

    @Override
    public void removeDataObject(ProjectDataObject dataObject) throws ProjectException {
        this.getProjectModel().removeDataObject(dataObject);
    }

    @Override
    public ProjectDataObject findDataObject(String variableId) {
        for (ProjectDataObject dataObject : this.getDefaultVariables()) {
            if (!dataObject.getId().equals(variableId)) continue;
            return dataObject;
        }
        return (ProjectDataObject)this.getProjectModel().findDataObject(variableId);
    }

    @Override
    public Process getProjectModel() {
        if (this.projectModel == null) {
            Process model = this.findChild(Process.class, "default");
            if (model == null) {
                try {
                    model = ProjectResourceObjectFactory.createProjectProcess(this.project, "default", true);
                }
                catch (ProjectException e) {
                    throw new RuntimeException(e);
                }
            }
            this.projectModel = model;
        }
        return this.projectModel;
    }

    @Override
    public ActivityGuide getActivityGuide() {
        return this.findChild(ActivityGuide.class, "activityGuide");
    }

    @Override
    public boolean isTemplate() {
        return this.getPreferences().isTemplate();
    }

    @Override
    public ProjectGenerateEvents getGenerateEvents() {
        return this.getPreferences().getKeyPerformanceIndicatorsContainer().getGenerateEvents();
    }

    @Override
    public Sequence<ProjectDataObject> getBusinessIndicators() {
        ArrayList<ProjectDataObject> businessIndicators = new ArrayList<ProjectDataObject>();
        for (ProjectDataObject projectDataObject : this.getProjectDataObjects()) {
            if (!projectDataObject.isBusiness()) continue;
            businessIndicators.add(projectDataObject);
        }
        return CollectionUtils.asSequence(businessIndicators);
    }

    @Override
    public Sequence<ProjectDataObject> getNonBusinessIndicators() {
        ArrayList<ProjectDataObject> projectDataObjects = new ArrayList<ProjectDataObject>();
        for (ProjectDataObject projectDataObject : this.project.getProjectDataObjects()) {
            if (projectDataObject.isBusiness()) continue;
            projectDataObjects.add(projectDataObject);
        }
        return CollectionUtils.asSequence(projectDataObjects);
    }

    @Override
    @NotNull
    public CatalogType getCatalogType(@NotNull TypeRef typeRef) {
        return CatalogTypeImpl.get(typeRef);
    }

    @Override
    @Nullable
    public CatalogObject findCatalogObject(String typeName) throws AmbiguousTypeNameException {
        TypeRef typeRef = this.getComponentCatalog().find(typeName);
        if (typeRef == null) {
            return null;
        }
        return CatalogObjectImpl.create(this, typeRef);
    }

    @Override
    public CatalogObject findSchemaElement(@NotNull XmlElementType xmlElementType, @NotNull String namespace, @NotNull String nativeName) {
        CatalogObject result = null;
        String id = UUIDFactory.createXmlId((XmlElementType)xmlElementType, (String)namespace, (String)nativeName).getId();
        TypeRef typeRef = this.getComponentCatalog().findById(ComponentType.XML, id);
        if (typeRef != null) {
            result = CatalogObjectImpl.create(this, typeRef);
        }
        return result;
    }

    @Override
    public ProjectPreferences getPreferences() {
        return this.preferencesHolder.get();
    }

    @Override
    @Nullable
    public ViewManager getViewManager() {
        return null;
    }

    @Override
    @NotNull
    public PresentationManager getPresentationManager() {
        PresentationManager result = this.presentationManager;
        if (result == null) {
            this.presentationManager = result = new PresentationManagerAdapter(this);
        }
        return result;
    }

    public Process getProcessByName(@Nullable String name, @Nullable SchemaType type) {
        if (name != null && !"".equals(name)) {
            for (Process process : type != null ? this.getProcessesOfType(type) : this.getAllProcesses()) {
                if (!name.equalsIgnoreCase(process.getId())) continue;
                return process;
            }
        }
        return null;
    }

    public FuegoProcessList getProcessesOfType(SchemaType ... schemaType) {
        return FuegoProject.getRecursiveProcesses(this.getModelsRoot());
    }

    public MutableComponentCatalog getComponentCatalog() {
        return (MutableComponentCatalog)this.projectCatalogHolder.get();
    }

    @Override
    @Deprecated
    public List<TypeRef> getBusinessCatalog() throws ProjectException {
        MutableComponentCatalog catalog = this.getComponentCatalog();
        ObjectTypeDescription root = catalog.getRoot();
        ArrayList<TypeRef> types = new ArrayList<TypeRef>();
        for (TypeRef ref : root.getInnerTypeRefs()) {
            if ("Ext".equals(ref.getName())) continue;
            types.add(ref);
        }
        return types;
    }

    public ProjectConfigurationManager getProjectConfigurationManager() {
        return this.projectConfigurationManager;
    }

    @Override
    public void dispose() throws ProjectException {
        ComponentCatalog catalog;
        if (this.getLoader() != null) {
            this.getLoader().dispose();
        }
        if (this.getWriter() != null) {
            this.getWriter().dispose();
        }
        if ((catalog = this.projectCatalogHolder.getIfSet()) != null) {
            catalog.dispose();
        }
        this.close();
    }

    @NotNull
    public List<WidgetModel> getWidgetsList() {
        try {
            this.loadWidgets();
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        List<WidgetModel> result = this.widgetList;
        if (result == null) {
            this.widgetList = result = new ArrayList<WidgetModel>();
        }
        return result;
    }

    @Override
    public DashboardModel createDashboard() {
        return new DashboardModelImpl(this);
    }

    @Override
    public WidgetModel createWidget() {
        WidgetModelImpl widgetModel = new WidgetModelImpl(this);
        try {
            this.events().preObjectAdded(widgetModel, (ProjectObject)this);
            this.getWidgetsList().add((WidgetModel)((Object)widgetModel));
            this.events().postObjectAdded(widgetModel, (ProjectObject)this);
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        return widgetModel;
    }

    @Override
    public void setWidgets(List<WidgetModel> list) {
        for (WidgetModel widgetModel : list) {
            WidgetModelImpl widget = (WidgetModelImpl)((Object)widgetModel);
            widget.setProject(this);
            ((WidgetDataModelImpl)widget.getDataModel()).setProject(this);
        }
        this.widgetList = list;
    }

    @Override
    public void setDashboards(List<DashboardModel> list) {
        this.dashboardList = list;
    }

    public void removeWidget(WidgetModel widgetToRemove) throws ProjectException {
        this.events().preObjectRemoved(widgetToRemove, (ProjectObject)this);
        this.getWidgetsList().remove(widgetToRemove);
        this.events().postObjectRemoved(widgetToRemove, (ProjectObject)this);
    }

    @Override
    public Organization getOrganization() {
        Organization result = this.organization;
        if (result == null) {
            this.organization = result = this.findChild(Organization.class, "organization");
        }
        return result;
    }

    @Override
    @NotNull
    public Deployment getDeployment() {
        DeploymentImpl result = this.deployment;
        if (result == null) {
            this.deployment = result = new DeploymentImpl(this);
        }
        return result;
    }

    @Override
    public void setComponentCatalog(ComponentCatalog repository) {
        this.projectCatalogHolder.set(repository);
    }

    @Override
    public CatalogObject createCatalogObject(TypeRef typeRef) {
        return CatalogObjectImpl.create(this, typeRef);
    }

    @Override
    public CompiledProject compile() throws ProjectException {
        ProjectCompiler compiler = ProjectCompiler.createDefault(this);
        FuegoCompiler fuegoCompiler = new FuegoCompiler();
        final Any.Holder exceptionHolder = new Any.Holder();
        compiler.setCatalogCompiler((CilCompiler)fuegoCompiler);
        compiler.addCompilationListener(new ProjectCompilationListener(){

            @Override
            public void onError(ProjectException exception) {
                exceptionHolder.value = exception;
            }

            @Override
            public void onInfo(ProjectException exception) {
            }

            @Override
            public void onWarning(ProjectException exception) {
            }

            @Override
            public void onCheckStarted(ProjectObject projectObject) {
            }

            @Override
            public void onCheckFinished(ProjectObject projectObject) {
            }

            @Override
            public boolean onInterruptionCheck() {
                return false;
            }
        });
        compiler.compile(null);
        if (exceptionHolder.value != null) {
            throw (ProjectException)exceptionHolder.value;
        }
        return this;
    }

    @Override
    public Process findProcess(String modelName) {
        return this.getProcessByName(modelName, null);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean isOpen) {
        this.open = isOpen;
    }

    @Override
    public CatalogModule getCatalogRoot() {
        return CatalogObjectImpl.create((TypeRef)this.getComponentCatalog().getRoot()).asModule();
    }

    @Override
    public void setId(String id) {
    }

    public String toString() {
        return "FuegoProject(" + this.getName() + ')';
    }

    @NotNull
    public List<DashboardModel> getDashboardList() {
        try {
            this.getLoader().loadDashboards();
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        List<DashboardModel> result = this.dashboardList;
        if (result == null) {
            this.dashboardList = result = new ArrayList<DashboardModel>();
        }
        for (DashboardModel dashboard : result) {
            DashboardModelImpl dashboardModel = (DashboardModelImpl)((Object)dashboard);
            dashboardModel.loadLocalizedDescriptions();
            dashboardModel.loadLocalizedTitles();
        }
        return result;
    }

    @Override
    @Nullable
    public Project getDependency() {
        ProjectRepository repository;
        Project prj;
        List ids = Collections.emptyList();
        Project result = null;
        if (!ids.isEmpty() && (prj = (repository = this.getLoader().getProjectRepository()).getProject((String)ids.get(0))) != null) {
            result = prj;
        }
        return result;
    }

    @Override
    public void addProjectPreferences(ProjectPreferences projectPreferences) throws ProjectException {
        this.events().preObjectAdded(projectPreferences, (ProjectObject)this);
        this.preferencesHolder.set(projectPreferences);
        projectPreferences.addPropertyObserver("j2eeMode", new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                FuegoProject.this.events().objectChanged();
            }
        });
        this.dependencyPropertyListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                FuegoProject.this.dependencyChange();
            }
        };
        projectPreferences.addPropertyObserver("dependencies", this.dependencyPropertyListener);
        this.events().postObjectAdded(projectPreferences, (ProjectObject)this);
    }

    @Override
    public void removeProjectPreferences() throws ProjectException {
        ProjectPreferences projectPreferences = this.preferencesHolder.getIfSet();
        if (projectPreferences != null) {
            this.events().preObjectRemoved(projectPreferences, (ProjectObject)this);
            this.preferencesHolder.reset();
            this.events().postObjectRemoved(projectPreferences, (ProjectObject)this);
        }
    }

    @Override
    public ProjectPreferences createProjectPreferences(String projectId) {
        return new ProjectPreferencesImpl(this, projectId);
    }

    @Override
    public void removeChild(ProjectObject object) throws ProjectException {
        assert (object.getParentObject() == this);
        if (object instanceof Process) {
            if (ProcessContent.isDefaultProcess((Process)object)) {
                this.events().preObjectRemoved(object, (ProjectObject)this);
                this.setProjectModel(null);
                this.events().postObjectRemoved(object, (ProjectObject)this);
            } else {
                this.getModelsRoot().removeChild(object);
            }
        } else {
            super.removeChild(object);
        }
    }

    @Override
    public SimulationsContainer getSimulations() {
        if (this.simulationsContainer == null) {
            this.simulationsContainer = this.findChild(SimulationsContainer.class, Path.SIMULATIONS.getName());
        }
        return this.simulationsContainer;
    }

    @Override
    @NotNull
    public BusinessParametersContainer getBusinessParametersContainer() {
        BusinessParametersContainer result = this.businessParametersContainer;
        if (result == null) {
            this.businessParametersContainer = result = new BusinessParametersContainerImpl(this.project);
        }
        return result;
    }

    public <P extends ProjectObject> P getObject(@NotNull ResourceContainer container, @NotNull Class<P> objectClass, @NotNull String id) {
        try {
            return this.getLoader().getObject(container, objectClass, id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            Log.logWarning(ProjectMsg.CANNOT_LOAD_OBJECT(objectClass.toString(), id));
            return null;
        }
    }

    @Override
    @NotNull
    public ResourceFilesContainer getResourceFilesContainer() {
        ResourceFilesContainer result = this.resourceFilesContainer;
        if (result == null) {
            this.resourceFilesContainer = result = new ResourceFilesContainerImpl(this);
        }
        return result;
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        Sequence<DataDeclaration> result = this.getProjectModel().getLocalDeclarations();
        return PredefinedVariablesHelper.appendPredefinedVariablesForContainer(result, this);
    }

    @Override
    @Nullable
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return this.getLocalDeclarations();
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return this.getProjectModel().findLocalDeclaration(name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return this.getProjectModel().findDeclaration(name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return this.getProjectModel().findDeclarationPath(path);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.getProjectModel().createDeclaration(name, type);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.getProjectModel().createDeclaration(name, type, accessType);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.getProjectModel().addDeclaration(dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.getProjectModel().removeDeclaration(dataDeclaration);
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        this.getProjectModel().clearDeclarations();
    }

    @Override
    public <T extends ProjectObject> T createFromXml(Class<T> iface, String xml) throws ProjectException {
        return this.getLoader().createFromXml(iface, xml);
    }

    @Override
    public ProjectRepository getRepository() {
        return this.repository;
    }

    @Nullable
    public CatalogObject findExistingCatalogObject(@Nullable String typeName) {
        return this.catalogObjects.get(typeName);
    }

    public void setRepository(ProjectRepository repository) {
        this.repository = repository;
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        ProjectObjectList<ProjectObject> list = new ProjectObjectList<ProjectObject>();
        list.add(this.getModelsRoot());
        list.add(this.getObject(this, ActivityGuide.class, "activityGuide"));
        list.add(this.getObject(this, Organization.class, "organization"));
        list.add(this.getCatalogRoot());
        list.add(this.getFormsRoot());
        list.add(this.getDeployment());
        list.add(this.getObject(this, FolderContainer.class, Path.SIMULATIONS.getName()));
        list.add(this.getObject(this, Process.class, "default"));
        list.add(this.getResourceFilesContainer());
        List<BpelProcess> bpelProcesses = this.getLoader().getChildrenByType(this, BpelProcess.class);
        for (BpelProcess bpelProcess : bpelProcesses) {
            list.add(bpelProcess);
        }
        return list;
    }

    CatalogObject createCatalogObjectInternal(TypeRef typeRef) {
        CatalogObject result = this.catalogObjects.get(typeRef.getText());
        if (result == null) {
            result = CatalogObjectImpl.newInstance(typeRef, this.project);
            if (!typeRef.get().isUnknown()) {
                this.catalogObjects.put(typeRef.getText(), result);
            }
        }
        return result;
    }

    private static Project getFrom(ProjectObject ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 'ref' cannot be null");
        }
        Project result = ref.getProject();
        assert (result != null) : "Type ref has no component catalog " + ref.getId();
        return result;
    }

    private static boolean isValidType(ProjectDataObject dataObject) {
        boolean result = false;
        CatalogType variableType = dataObject.getType();
        for (TypeDescription type : ProjectVariableImpl.getValidTypes()) {
            if (variableType.getKind() != type.getKind()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<Process> getProcesses(FolderContainer node, boolean recursive) {
        ArrayList<Process> result = new ArrayList<Process>();
        FuegoProject.addProcesses(result, node, recursive);
        return result;
    }

    private static void addProcesses(List<Process> list, FolderContainer node, boolean recursive) {
        Sequence<Process> models = node.getChildrenByType(Process.class);
        for (Process process : models) {
            list.add(process);
        }
        if (recursive) {
            Sequence<FolderContainer> containers = node.getChildrenByType(FolderContainer.class);
            for (FolderContainer child : containers) {
                FuegoProject.addProcesses(list, child, recursive);
            }
        }
    }

    private static FuegoProcessList getRecursiveProcesses(FolderContainer node) {
        List<Process> list = FuegoProject.getProcesses(node, true);
        return FuegoProcessList.create(list);
    }

    private LazyHolder<ProjectPreferences> buildPreferencesHolder() {
        return new LazyHolder<ProjectPreferences>(){

            @Override
            @NotNull
            protected ProjectPreferences init() {
                ProjectPreferences result = FuegoProject.this.createProjectPreferences(Path.PREFERENCES.getName());
                this.set(result);
                ProjectLoader projectLoader = FuegoProject.this.project.getLoader();
                try {
                    List objects;
                    List<Object> list = objects = projectLoader == null ? Collections.emptyList() : projectLoader.getAllObjects(ProjectPreferences.class);
                    if (!objects.isEmpty()) {
                        FuegoProject.this.getProject().addProjectPreferences((ProjectPreferences)objects.get(0));
                    }
                }
                catch (ProjectException e) {
                    Log.logDebug(e);
                }
                return result;
            }
        };
    }

    private LazyHolder<ComponentCatalog> buildCatalogHolder() {
        return new LazyHolder<ComponentCatalog>(){

            @Override
            @NotNull
            protected ComponentCatalog init() {
                ProjectLoader loader = FuegoProject.this.getLoader();
                try {
                    loader.loadCatalog(null);
                }
                catch (ProjectException e) {
                    Log.logSevere(e);
                }
                ComponentCatalog result = (ComponentCatalog)this.getIfSet();
                if (result != null) {
                    result.addListener((CatalogListener)new CatalogAdapter(){

                        @Override
                        public void typeRemoved(String typeName) {
                            FuegoProject.this.catalogObjects.remove(typeName);
                        }
                    });
                }
                ((ProjectObjectImpl)((Object)FuegoProject.this.getCatalogRoot())).events().enable();
                assert (result != null);
                return result;
            }
        };
    }

    private void setModelsRoot(FolderContainer folderContainer) {
        this.modelsRoot = folderContainer;
        if (folderContainer != null && ((EventSource)((Object)folderContainer)).events() != null) {
            ((EventSource)((Object)folderContainer)).events().enable();
        }
    }

    @NotNull
    private FormsContainer getFormsRoot() {
        FormsContainer result = this.formsRoot;
        if (result == null) {
            this.formsRoot = result = new FormsContainerImpl(this);
        }
        return result;
    }

    private void setProjectModel(Process model) {
        this.projectModel = model;
    }

    private void replaceProjectModel(Process oldProcess, Process newModel) {
        this.setProjectModel(newModel);
        this.events().objectReplaced(oldProcess, newModel);
    }

    private void close() {
        if (this.projectConfigurationManager != null) {
            this.projectConfigurationManager.getConfigurationManager().destroy();
            this.projectConfigurationManager = null;
        }
        if (this.dependencyPropertyListener != null) {
            this.getPreferences().addPropertyObserver("dependencies", this.dependencyPropertyListener);
        }
        this.clearLists();
        this.setLoader(null);
        this.setWriter(null);
        this.open = false;
        this.preferencesHolder.reset();
        this.deployment = null;
    }

    private void clearLists() {
        this.webRootContainer = null;
        this.events().clear();
        this.organization = null;
        this.viewManager = null;
        this.presentationManager = null;
        ComponentCatalog componentCatalog = this.projectCatalogHolder.getIfSet();
        if (componentCatalog != null) {
            componentCatalog.removeListeners();
            this.projectCatalogHolder.reset();
        }
        if (this.widgetList != null) {
            this.widgetList.clear();
        }
        if (this.dashboardList != null) {
            this.dashboardList.clear();
        }
    }

    private void loadWidgets() throws ProjectException {
        this.project.setWidgets(this.project.getLoader().getAllObjects(WidgetModel.class));
    }
}

