/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class FolderContainerImpl
extends ResourceContainerImpl
implements FolderContainer {
    private ResourceContainer container;

    public FolderContainerImpl(@NotNull Project project, ResourceContainer container, @NotNull String id) {
        super(project);
        this.container = container;
        this.setId(id);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.FOLDER;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            Path parentPath = this.getParentObject().getPath();
            this.path = parentPath.create(this.getId());
        }
        return this.path;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.container;
    }

    @Override
    public FolderContainer createContainer(String id) throws ProjectException {
        return new FolderContainerImpl(this.getProject(), this, id);
    }

    @Override
    protected void beforeDelete() throws ProjectException {
        super.beforeDelete();
        ProjectObjectList<ProjectObject> children = this.children().copy();
        for (ProjectObject child : children) {
            child.delete();
        }
    }
}

