/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationContainerProvider;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public abstract class DataDeclarationComposite
extends ProjectObjectImpl
implements DataDeclarationContainer {
    public DataDeclarationComposite(@NotNull Project project) {
        super(project);
    }

    public static DataDeclarationComposite createContainersComposite(@NotNull Project project, @NotNull List<DataDeclarationContainer> containers) {
        return new DataDeclarationContainersComposite(project, containers);
    }

    public static DataDeclarationComposite createProvidersComposite(@NotNull Project project, @NotNull List<DataDeclarationContainerProvider> providers) {
        return new DataDeclarationProvidersComposite(project, providers);
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return this.getLocalDeclarations();
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        HashMap<String, DataDeclaration> result = new HashMap<String, DataDeclaration>();
        for (DataDeclarationContainer container : this.getCompositeContainers()) {
            for (DataDeclaration declaration : container.getDeclarations()) {
                if (result.containsKey(declaration.getName())) continue;
                result.put(declaration.getName(), declaration);
            }
        }
        return CollectionUtils.asSequence(result.values());
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String query) {
        return DataDeclarationImpl.findDeclarationPath(this, query);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return false;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        throw new UnsupportedOperationException();
    }

    protected abstract Sequence<DataDeclarationContainer> getCompositeContainers();

    public static class DataDeclarationProvidersComposite
    extends DataDeclarationComposite {
        private List<DataDeclarationContainerProvider> providers;

        public DataDeclarationProvidersComposite(@NotNull Project project, @NotNull List<DataDeclarationContainerProvider> providers) {
            super(project);
            this.providers = providers;
        }

        @Override
        protected Sequence<DataDeclarationContainer> getCompositeContainers() {
            ArrayList<DataDeclarationContainer> result = new ArrayList<DataDeclarationContainer>();
            for (DataDeclarationContainerProvider provider : this.providers) {
                result.add(provider.getDataDeclarationContainer());
            }
            return CollectionUtils.asSequence(result);
        }
    }

    public static class DataDeclarationContainersComposite
    extends DataDeclarationComposite {
        private List<DataDeclarationContainer> containers;

        public DataDeclarationContainersComposite(@NotNull Project project, @NotNull List<DataDeclarationContainer> containers) {
            super(project);
            this.containers = containers;
        }

        @Override
        protected Sequence<DataDeclarationContainer> getCompositeContainers() {
            return CollectionUtils.asSequence(this.containers);
        }
    }
}

