/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.geom.Point;
import oracle.bpm.project.ActivityReferenceFeature;
import oracle.bpm.project.FeaturesByCounter;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;

public class CounterImpl
extends ProcessObjectImpl
implements Counter {
    private Features features;
    private IntFeature x = IntFeature.create("x", 0);
    private IntFeature y = IntFeature.create("y", 0);

    protected CounterImpl(String id, Process process) {
        super(process);
        this.setId(id);
        this.addModificationListener(this.x, this.y);
        this.initFeatures();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        Feature<T> tFeature = this.getFeature(clazz);
        return tFeature.getValue();
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public void addBusinessIndicator(ProjectDataObject dataObject) throws ProjectException {
        if (!dataObject.isBusiness() || dataObject.getBusinessVariableType() != BusinessVariableType.COUNTER && dataObject.getBusinessVariableType() != BusinessVariableType.MEASURE) {
            throw new IllegalArgumentException("Data object is not a Business Indicator or is not a Counter type of Business Indicator.");
        }
        this.addChild(dataObject);
    }

    @Override
    public Sequence<ProjectDataObject> getBusinessIndicators() {
        return this.getChildrenByType(ProjectDataObject.class);
    }

    @Override
    public ProjectDataObject findBusinessIndicator(String businessIndicatorId) {
        return this.findChild(ProjectDataObject.class, businessIndicatorId);
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public int getX() {
        return this.x.getValue();
    }

    @Override
    public int getY() {
        return this.y.getValue();
    }

    @Override
    public Lane getLane() {
        return null;
    }

    @Override
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void setX(int x) {
        this.x.setValue(x);
    }

    @Override
    public void setY(int y) {
        this.y.setValue(y);
    }

    @Override
    public void setHeight(int height) {
    }

    @Override
    public void setWidth(int width) {
    }

    @Override
    public void setLane(Lane lane) {
    }

    @Override
    public void setLocation(Point point) {
        this.x.setValue(point.getX());
        this.y.setValue(point.getY());
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProcess();
    }

    @Override
    public void setActivity(Activity activity) {
        ActivityReferenceFeature activityRefFeature = this.getFeature(ActivityReferenceFeature.class);
        activityRefFeature.setValue(activity != null ? activity.getId() : null);
    }

    @Override
    public Activity getActivity() {
        ActivityReferenceFeature activityRefFeature = this.getFeature(ActivityReferenceFeature.class);
        String activityValue = activityRefFeature.getValue();
        return this.getProcess().findDescendant(Activity.class, activityValue);
    }

    @Override
    public String getActivityId() {
        ActivityReferenceFeature activityRefFeature = this.getFeature(ActivityReferenceFeature.class);
        return activityRefFeature.getValue();
    }

    private void initFeatures() {
        this.features = FeaturesByCounter.get();
        this.addModificationListener(this.features);
    }
}

