/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.Collection;
import java.util.TreeMap;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerImpl
extends ResourceObjectImpl
implements Container.Mutable,
ResourceObject {
    private TreeMap<String, Container> childDirNodes = new TreeMap();
    private boolean isRoot = false;
    private Container parent;

    public ContainerImpl(Project project, Container parent) {
        super(project);
        this.parent = parent;
    }

    @Override
    public Collection<Container> getContainers() {
        return this.childDirNodes.values();
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    public Container findContainer(String containerName) {
        return this.childDirNodes.get(containerName);
    }

    @Override
    public void addContainer(Container container) throws ProjectException {
        this.events().preObjectAdded(container, (ProjectObject)this);
        this.childDirNodes.put(container.getId(), container);
        this.events().postObjectAdded(container, (ProjectObject)this);
    }

    @Override
    @NotNull
    public Container.Mutable asMutable() {
        return this;
    }

    @Override
    public Container removeContainer(String containerName) throws ProjectException {
        Container container = this.findContainer(containerName);
        this.removeContainer(container);
        return container;
    }

    @Override
    public void removeContainer(Container container) throws ProjectException {
        this.events().preObjectRemoved(container, (ProjectObject)this);
        this.childDirNodes.remove(container.getId());
        this.events().postObjectRemoved(container, (ProjectObject)this);
    }

    @Override
    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public void addDefaultContainer(Container container) {
        this.childDirNodes.put(container.getId(), container);
    }

    private TreeMap<String, Container> getContainersMap() {
        return this.childDirNodes;
    }
}

