/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.cil.CilException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.compile.CilError;
import oracle.bpm.project.compile.CompilationError;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.SourceCode;
import oracle.bpm.util.FixOption;

public class CilMessageListener
implements ProjectMessageListener,
Serializable {
    private List messages_d = new ArrayList();
    private int type_d;
    static final long serialVersionUID = -97903633966554485L;
    static final long serialCheck = 6949342219230300281L;

    public List getMessages() {
        return this.messages_d;
    }

    public void setType(int t) {
        this.type_d = t;
    }

    public void reportError(CilException e) {
        String lineStr = " line: " + e.getLine() + " col: " + e.getColumn();
        if (e.getLine() < 0) {
            lineStr = "";
        }
        String errorMsg = "" + lineStr + " " + e.getMessage();
        CilMessageListener.printException("Error", e);
        this.messages_d.add(new CilError(this.type_d, e.getMemberName(), errorMsg));
    }

    @Override
    public void reportError(ProjectObject source, ProjectException e) {
        System.err.println("[Error] Source : " + source + " exception: " + e.getMessage());
        CompilationError error = new CompilationError();
        error.setException((Exception)e);
        error.setSource(source);
        error.setType(CoreMsg.ERROR);
        this.messages_d.add(error);
    }

    public void reportWarning(CilException e) {
        String lineStr = " line: " + e.getLine() + " col: " + e.getColumn();
        if (e.getLine() < 0) {
            lineStr = "";
        }
        System.err.println("[Warning] method: " + e.getMemberName() + lineStr + " " + e.getMessage());
    }

    @Override
    public void reportWarning(ProjectObject source, ProjectException e) {
        System.err.println("[Warning] method: " + source + " exception: " + e.getMessage());
    }

    private static String getLineForError(char[] code, int line, int col, int length) {
        String lineText;
        try {
            String[] lines = Str.valueOf(code).split("\n");
            String selectedLine = lines[line - 1];
            int tabCount = Str.count(selectedLine.substring(0, col), '\t');
            selectedLine = Str.replace(selectedLine, "\t", "    ");
            lineText = "Line : " + selectedLine + "\n";
            lineText = lineText + "       " + Str.valueOf(' ', col - 1 + tabCount * 3);
            for (int i = 0; i < length; ++i) {
                lineText = lineText + "^";
            }
            lineText = lineText + "\n";
        }
        catch (IndexOutOfBoundsException ioub) {
            lineText = "WARNING: Wrong line or column number for this error!";
        }
        return lineText;
    }

    private static void checkFix(CilException e) {
        if (e.isFixable()) {
            FixOption[] options = e.getFixOptions();
            for (int i = 0; i < options.length; ++i) {
                FixOption option = options[i];
                System.out.println("FIX  : [" + option.getDescription() + "]");
            }
        }
    }

    private static void printException(String kind, CilException e) {
        int line = e.getLine();
        int col = e.getColumn();
        System.err.println("\n" + kind + ": " + e.getMemberName() + ":" + line + ":" + col + ":" + e.getMessage());
        MethodTypeDescription member = (MethodTypeDescription)e.getMember();
        if (member != null && member.getCodeText() != null) {
            SourceCode code = e.getSourceCode();
            if (code == null) {
                code = member.getCode();
            }
            CilMessageListener.printLine(code != null ? code.getText() : new char[]{}, line, col, e.getLength());
        }
        if (e.isInternal()) {
            System.err.println("Cause:");
            e.getCause().printStackTrace(System.err);
        }
        CilMessageListener.checkFix(e);
    }

    private static void printLine(char[] code, int line, int col, int length) {
        System.err.println(CilMessageListener.getLineForError(code, line, col, length));
    }
}

