/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class CatalogTypeImpl
extends ProjectObjectContainerImpl
implements CatalogType {
    protected TypeRef delegate;

    public CatalogTypeImpl(Project project, TypeRef delegate) {
        super(project);
        this.delegate = delegate.getRef();
        this.initErrors(delegate.get());
    }

    public static CatalogType get(TypeRef typeRef) {
        CatalogType result = typeRef.get().isObject() ? CatalogObjectImpl.create(typeRef) : CatalogType.Default.get(typeRef);
        return result;
    }

    @Override
    public TypeDescription getDelegate() {
        return this.delegate.get();
    }

    @Override
    public boolean equality(CatalogType type) {
        return this.getDelegate().equality(type.getDelegate());
    }

    @Override
    public boolean equality(TypeDescription type) {
        return this.getDelegate().equality(type);
    }

    @Override
    public int getLength() {
        return this.getDelegate().getLength();
    }

    @Override
    public int getScale() {
        return this.getDelegate().getScale();
    }

    @Override
    public String getText() {
        return this.getDelegate().getText();
    }

    @Override
    public int getKind() {
        return this.getDelegate().getKind();
    }

    @Override
    public boolean isPredefined() {
        return this.getDelegate().isPredefined();
    }

    @Override
    public boolean isException() {
        return Modifier.isException((long)this.getDelegate().getModifiers());
    }

    @Override
    public boolean isNumber() {
        return this.getDelegate().isNumber();
    }

    @Override
    public boolean equivalent(CatalogType type) {
        return this.getDelegate().equivalent(type.getDelegate());
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public void setElementType(CatalogType type) {
    }

    @Override
    public void setIndexType(CatalogType type) {
    }

    @Override
    public void setOrdered(boolean ordered) {
    }

    @Override
    public CatalogType primitiveEquivalent(boolean primitive) {
        TypeDescription result = this.getDelegate().primitiveEquivalent(primitive);
        if (result != this.getDelegate()) {
            return CatalogType.Default.get((TypeRef)result);
        }
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return null;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public CatalogType getIndexType() {
        return CatalogType.Default.get((TypeRef)this.getDelegate().getIndexType());
    }

    @Override
    public CatalogType getElementType() {
        return CatalogType.Default.get((TypeRef)this.getDelegate().getElementType());
    }

    @Override
    public boolean isMember() {
        return this.getDelegate().isMember();
    }

    @Override
    public boolean isAbstract() {
        return this.getDelegate().isAbstract();
    }

    @Override
    public boolean isString() {
        return this.getDelegate().isString();
    }

    @Override
    public boolean isBoolean() {
        return this.getDelegate().isBool();
    }

    @Override
    public boolean isInt() {
        return this.getDelegate().isInt();
    }

    @Override
    public boolean isReal() {
        return this.getDelegate().isReal();
    }

    @Override
    public boolean isDecimal() {
        return this.getDelegate().isDecimal();
    }

    @Override
    public boolean isTime() {
        return this.getDelegate().isTime();
    }

    @Override
    public boolean isArray() {
        return this.getDelegate().isArray();
    }

    @Override
    public boolean isVoid() {
        return this.getDelegate().isVoid();
    }

    @Override
    public boolean isAny() {
        return this.getDelegate().isAny();
    }

    @Override
    public boolean isNull() {
        return this.getDelegate().isNull();
    }

    @Override
    public boolean isObject() {
        return this.getDelegate().isObject();
    }

    @Override
    public boolean isCollection() {
        return this.getDelegate().isCollection();
    }

    @Override
    public boolean isBinary() {
        return this.getDelegate().isBinary();
    }

    @Override
    public boolean isAssignableFrom(CatalogType type) {
        return this.getDelegate().isAssignableFrom(type.getDelegate());
    }

    @Override
    public CatalogMember asMember() {
        return this.as(CatalogMember.class);
    }

    @Override
    public CatalogObject asObject() {
        return this.as(CatalogObject.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogTypeImpl that = (CatalogTypeImpl)o;
        return Any.equals(this.project, that.project) && (Any.equals(this.getDelegate(), that.getDelegate()) || Any.equals(this.getText(), that.getText()));
    }

    @Override
    public boolean isHidden() {
        return Modifier.isHidden((long)this.getDelegate().getModifiers());
    }

    @Override
    public boolean isUnknown() {
        return this.getDelegate().isUnknown();
    }

    @Override
    public TypeRef getDynamicRef() {
        return this.delegate;
    }

    protected void updateDelegate(TypeRef updatedType) {
        this.delegate = updatedType;
        this.clear();
    }

    private void initErrors(@NotNull TypeDescription td) {
        if (td.hasErrors()) {
            List errors = td.getErrors();
            ArrayList<ProjectException> projectExceptions = new ArrayList<ProjectException>(errors.size());
            for (TypeError error : errors) {
                projectExceptions.add(ProjectException.wrap((ProjectObject)this, error.shortDesc()));
            }
            this.setErrors(projectExceptions);
        }
    }
}

