/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lib.Expression;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.project.BPMNTypes;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.LoopCharacteristicsContainer;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.activities.FeaturesByBPMNType;
import oracle.bpm.project.activities.FeaturesByEventTrigger;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.interfaces.ProcessOperationWrapperImpl;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.ConversationFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.InstantiateFeature;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.IsInterruptingFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.features.ParticipantFeature;
import oracle.bpm.project.model.features.ProcessCommunicationFeature;
import oracle.bpm.project.model.features.RelatedProcessNameFeature;
import oracle.bpm.project.model.features.ScriptTaskFeature;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ActivityGenerateEvents;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventBasedGatewayType;
import oracle.bpm.project.model.processes.EventBasedGatewayTypeFeature;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.ExpressionFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.MessageEventDefinition;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.ParticipantReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ReinitiatePolicy;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.EventTriggerTypeFeature;
import oracle.bpm.project.model.processes.activities.GatewayDirectionFeature;
import oracle.bpm.project.model.processes.activities.GenerateEventsFeature;
import oracle.bpm.project.model.processes.activities.LoopCharacteristicsTypeFeature;
import oracle.bpm.project.model.processes.activities.MergingGatewayFeature;
import oracle.bpm.project.model.processes.activities.WaitForInteractionFeature;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.ErrorEventDefinitionImpl;
import oracle.bpm.project.process.LoopImpl;
import oracle.bpm.project.process.MessageEventDefinitionImpl;
import oracle.bpm.project.process.MultiInstanceImpl;
import oracle.bpm.project.process.SignalEventDefinitionImpl;
import oracle.bpm.project.process.TerminateEventDefinitionImpl;
import oracle.bpm.project.process.TimerEventDefinitionImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityImpl
extends ProcessObjectImpl
implements Serializable,
Cloneable,
Activity,
ManualTask,
ReceiveTask,
SendTask,
ScriptTask,
UserTask,
ServiceTask,
CallActivity,
BusinessRuleTask,
Gateway,
ParallelGateway,
ExclusiveGateway,
InclusiveGateway,
EventBasedGateway,
ComplexGateway,
Event,
StartEvent,
EndEvent,
ThrowEvent,
CatchEvent,
BoundaryEvent {
    public transient int relPosition_d;
    protected NodeContainer container;
    protected LocaleStringMap description = LocaleStringMap.create();
    protected Features features;
    protected IntFeature height = IntFeature.create("height", 21);
    protected IntFeature width = IntFeature.create("width", 21);
    protected IntFeature x = IntFeature.create("x", 0);
    protected IntFeature y = IntFeature.create("y", 0);
    private BpmnType bpmntype;
    private EventDefinition definition;
    private DataDeclarationContainer inputArgumentsContainer;
    private LoopCharacteristics loopCharacteristics;
    private DataDeclarationContainer loopCharacteristicsContainer;
    private OperationReference operationRef = new OperationReferenceAdapter();
    private DataDeclarationContainer outputArgumentsContainer;
    private ParticipantReference participantRef = new ParticipantReferenceAdapter();
    private static final long serialVersionUID = -3614895649074258587L;
    public static final int ACTIVITY_DEFAULT_HEIGHT = 21;
    public static final int ACTIVITY_DEFAULT_WIDTH = 21;

    public ActivityImpl(Process content, NodeContainer container, BpmnType type, EventTriggerType triggerType) {
        this(content, container, type, triggerType, null);
    }

    public ActivityImpl(Process content, NodeContainer container, BpmnType type, EventTriggerType triggerType, String id) {
        super(content.getProject(), content);
        this.container = container;
        if (id == null) {
            id = ModelUtils.nextIdFor(type, this);
        }
        this.setId(id);
        this.setActivityType(type, triggerType);
        this.addModificationListener(this.x, this.y, this.width, this.height);
    }

    public static String getValidActivityName(String value) {
        int index;
        String validName = value;
        if (value.indexOf(32) != -1) {
            validName = Identifier.valid(value);
        }
        if ((index = value.indexOf(46)) != -1) {
            validName = validName.substring(0, index) + "$" + validName.substring(index + 1);
        }
        return validName;
    }

    @Override
    public void setMergeGateway(Gateway gateway) {
        this.getFeature(MergingGatewayFeature.class).setValue(gateway.getId());
    }

    @Override
    public Gateway getMergeGateway() {
        return this.getFeature(MergingGatewayFeature.class).getAssociatedNode();
    }

    @Override
    public void setReinitiate(boolean value) {
        this.getFeature(UserTaskFeature.class).setReInitiate(value);
    }

    @Override
    public ReinitiatePolicy getReinitiatePolicy() {
        return this.getFeature(UserTaskFeature.class).getReinitiatePolicy();
    }

    @Override
    public void setReinitiatePolicy(ReinitiatePolicy policy) {
        this.getFeature(UserTaskFeature.class).setReinitiatePolicy(policy);
    }

    @Override
    public boolean isManualStart() {
        return this.getFeature(UserTaskFeature.class).isManualStart();
    }

    @Override
    @Deprecated
    public void setManualStart(boolean value) {
        this.getFeature(UserTaskFeature.class).setManualStart(value);
    }

    @Override
    public boolean usesTransformations() {
        return this.getFeature(UserTaskFeature.class).usesTransformations();
    }

    @Override
    public void setUsesTransformations(boolean value) {
        if (this.usesTransformations() == value) {
            return;
        }
        this.getFeature(UserTaskFeature.class).setUsesTransformations(value);
        this.clearDataAssociations();
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.features.getValue(clazz);
    }

    @Override
    public CatchEvent asCatchEvent() {
        ActivityImpl result = null;
        if (this.isCatchEvent()) {
            result = this;
        }
        return result;
    }

    @Override
    public ThrowEvent asThrowEvent() {
        ActivityImpl result = null;
        if (this.isThrowEvent()) {
            result = this;
        }
        return result;
    }

    @Override
    public int getX() {
        return this.x.getValue();
    }

    @Override
    public int getY() {
        return this.y.getValue();
    }

    @Override
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void setX(int x) {
        this.x.setValue(x);
    }

    @Override
    public void setY(int y) {
        this.y.setValue(y);
    }

    @Override
    public void setHeight(int height) {
        this.height.setValue(height);
    }

    @Override
    public int getHeight() {
        return this.height.getValue();
    }

    @Override
    public void setWidth(int width) {
        this.width.setValue(width);
    }

    @Override
    public int getWidth() {
        return this.width.getValue();
    }

    public Activity toActivity() {
        this.updateActivityType(BpmnType.ABSTRACT_ACTIVITY, null);
        return this;
    }

    @Override
    public void setLocation(@NotNull Point location) {
        this.x.setValue(location.getX());
        this.y.setValue(location.getY());
    }

    @Override
    public void afterAdd(ProjectObjectContainer objectContainer) throws ProjectException {
        this.container = (NodeContainer)objectContainer;
    }

    @Override
    public Sequence<SequenceFlow> getOutgoingSequenceFlows() {
        return ModelUtils.getOutgoingSequenceFlows(this);
    }

    @Override
    public Sequence<SequenceFlow> getIncomingSequenceFlows() {
        return ModelUtils.getIncomingSequenceFlows(this);
    }

    @Override
    public Sequence<ConditionalFlow> getOutgoingConditionalFlows() {
        Predicate<SequenceFlow> conditionals = new Predicate<SequenceFlow>(){

            @Override
            public boolean check(SequenceFlow sequenceFlow) {
                return sequenceFlow.isConditionalFlow();
            }
        };
        Function<SequenceFlow, ConditionalFlow> function = new Function<SequenceFlow, ConditionalFlow>(){

            @Override
            public ConditionalFlow eval(SequenceFlow sequenceFlow) {
                return sequenceFlow.asConditionalFlow();
            }
        };
        return this.getOutgoingSequenceFlows().select(conditionals).map(function);
    }

    @Override
    public Lane getLane() {
        Lane lane;
        Lane result = null;
        int offset = this.getOffsetInLane();
        Map.Entry<Integer, Lane> entry = this.getProcessContent().getLanesInternal().floorEntry(offset);
        if (entry != null && offset - (lane = entry.getValue()).getOffset() < lane.getSize()) {
            result = lane;
        }
        return result;
    }

    @Override
    public boolean isActivity() {
        return this.getBpmnType() != null && this.getBpmnType().isActivity();
    }

    @Override
    public boolean isEvent() {
        return this.getBpmnType() != null && this.getBpmnType().isEvent();
    }

    @Override
    public boolean isGateway() {
        return this.getBpmnType() != null && this.getBpmnType().isGateway();
    }

    @Override
    public boolean isConversationMember() {
        return this.isEvent() && this.getEventTriggerType() != null && this.getEventTriggerType().equals(EventTriggerType.MESSAGE) || this.isSendTask() || this.isReceiveTask() || this.isServiceTask();
    }

    @Override
    public boolean isProcessCommunicationMember() {
        return this.getFeature(ProcessCommunicationFeature.class) != null;
    }

    @Override
    public <T extends FlowNode> T asAnyNode(Class<T> clazz) {
        Class<? extends FlowElement> actClass = this.getBpmnType().getBpmnClass();
        if (clazz.isAssignableFrom(actClass)) {
            return (T)((FlowNode)clazz.cast(this));
        }
        return null;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ACTIVITY;
    }

    @Override
    public Class getRawClass() {
        return this.getBpmnType().getBpmnClass();
    }

    @Override
    @Nullable
    public <T extends Activity> T asActivity(Class<T> clazz) {
        BpmnType type = BPMNTypes.getBpmnTypeFor(clazz);
        if (type == this.getBpmnType()) {
            switch (type) {
                case ABSTRACT_ACTIVITY: {
                    return (T)((Activity)clazz.cast(this.toActivity()));
                }
                case CALL_ACTIVITY: {
                    return (T)((Activity)clazz.cast(this.toCallActivity()));
                }
                case RECEIVE_TASK: {
                    return (T)((Activity)clazz.cast(this.toReceiveTask()));
                }
                case SCRIPT_TASK: {
                    return (T)((Activity)clazz.cast(this.toScriptTask()));
                }
                case SEND_TASK: {
                    return (T)((Activity)clazz.cast(this.toSendTask()));
                }
                case SERVICE_TASK: {
                    return (T)((Activity)clazz.cast(this.toServiceTask()));
                }
                case SUBPROCESS: {
                    return (T)((Activity)clazz.cast(this));
                }
                case USER_TASK: {
                    return (T)((Activity)clazz.cast(this.toUserTask()));
                }
                case BUSINESS_RULE_TASK: {
                    return (T)((Activity)clazz.cast(this.toBusinessRuleTask()));
                }
            }
        }
        return null;
    }

    @Override
    public Class<? extends Activity> getActivityClass() {
        return this.getBpmnType().getBpmnClass();
    }

    @Override
    public Sequence<BoundaryEvent> getActivityBoundaryEvents() {
        return ModelUtils.getBoundaryEventsFor(this);
    }

    @Override
    public LoopCharacteristicsType getLoopCharacteristicsType() {
        LoopCharacteristicsTypeFeature loopCharacteristicsTypeFeature = this.getFeature(LoopCharacteristicsTypeFeature.class);
        return loopCharacteristicsTypeFeature != null ? (LoopCharacteristicsType)loopCharacteristicsTypeFeature.getValue() : null;
    }

    @Override
    public void setLoopCharacteristicsType(@NotNull LoopCharacteristicsType loopCharacteristicsType) {
        LoopCharacteristicsTypeFeature loopCharacteristicsTypeFeature = this.getFeature(LoopCharacteristicsTypeFeature.class);
        if (loopCharacteristicsTypeFeature != null) {
            LoopCharacteristicsType value = (LoopCharacteristicsType)loopCharacteristicsTypeFeature.getValue();
            if (loopCharacteristicsType != null && value != loopCharacteristicsType) {
                loopCharacteristicsTypeFeature.setValue(loopCharacteristicsType);
                this.updateLoopCharacteristics();
            }
        }
    }

    @Override
    public LoopCharacteristics getLoopCharacteristics() {
        return this.loopCharacteristics;
    }

    @Override
    public DataDeclarationContainer getLoopCharacteristicsContainer() {
        return this.loopCharacteristicsContainer;
    }

    @Override
    public boolean isSubprocess() {
        return this.getBpmnType() == BpmnType.SUBPROCESS;
    }

    @Override
    public boolean isUserTask() {
        return this.getBpmnType() == BpmnType.USER_TASK;
    }

    @Override
    public boolean isServiceTask() {
        return this.getBpmnType() == BpmnType.SERVICE_TASK;
    }

    @Override
    public boolean isReceiveTask() {
        return this.getBpmnType() == BpmnType.RECEIVE_TASK;
    }

    @Override
    public boolean isSendTask() {
        return this.getBpmnType() == BpmnType.SEND_TASK;
    }

    @Override
    public boolean isScriptTask() {
        return this.getBpmnType() == BpmnType.SCRIPT_TASK;
    }

    @Override
    public boolean isManualTask() {
        return this.getBpmnType() == BpmnType.MANUAL_TASK;
    }

    @Override
    public boolean isBusinessRuleTask() {
        return this.getBpmnType() == BpmnType.BUSINESS_RULE_TASK;
    }

    @Override
    public boolean isCallActivity() {
        return this.getBpmnType() == BpmnType.CALL_ACTIVITY;
    }

    @Override
    public void setLabelMap(LocaleStringMap label) {
        this.getLabelMap().putAll(label);
    }

    @Override
    public LocaleStringMap getLabelMap() {
        if (this.label == null) {
            this.label = ActivityLocaleStringMap.create(this);
        }
        return this.label;
    }

    @Override
    public void setDescription(LocaleStringMap description) {
        this.description = description;
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public String toString() {
        return this.getLabelMap().getString();
    }

    @Override
    public void setLane(Lane lane) {
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = this.getParentObject().getPath().create(this.getId());
        }
        return this.path;
    }

    @Override
    public Activity toAbstract() {
        this.updateActivityType(BpmnType.ABSTRACT_ACTIVITY, null);
        return this;
    }

    @Override
    public UserTask toUserTask() {
        this.updateActivityType(BpmnType.USER_TASK, null);
        return this;
    }

    @Override
    public ServiceTask toServiceTask() {
        this.updateActivityType(BpmnType.SERVICE_TASK, null);
        return this;
    }

    @Override
    public ReceiveTask toReceiveTask() {
        this.updateActivityType(BpmnType.RECEIVE_TASK, null);
        return this;
    }

    @Override
    public BusinessRuleTask toBusinessRuleTask() {
        this.updateActivityType(BpmnType.BUSINESS_RULE_TASK, null);
        return this;
    }

    @Override
    public ManualTask toManualTask() {
        this.updateActivityType(BpmnType.MANUAL_TASK, null);
        return this;
    }

    @Override
    public SendTask toSendTask() {
        this.updateActivityType(BpmnType.SEND_TASK, null);
        return this;
    }

    @Override
    public ScriptTask toScriptTask() {
        this.updateActivityType(BpmnType.SCRIPT_TASK, null);
        return this;
    }

    @Override
    public Subprocess toSubprocess() {
        return null;
    }

    @Override
    public CallActivity toCallActivity() {
        this.updateActivityType(BpmnType.CALL_ACTIVITY, null);
        return this;
    }

    @Override
    public ParallelGateway toParallel() {
        this.updateActivityType(BpmnType.PARALLEL_GATEWAY, null);
        return this;
    }

    @Override
    public ExclusiveGateway toExclusive() {
        this.updateActivityType(BpmnType.EXCLUSIVE_GATEWAY, null);
        return this;
    }

    @Override
    public InclusiveGateway toInclusive() {
        this.updateActivityType(BpmnType.INCLUSIVE_GATEWAY, null);
        return this;
    }

    @Override
    public EventBasedGateway toEventBased() {
        this.updateActivityType(BpmnType.EVENT_BASED_GATEWAY, null);
        return this;
    }

    @Override
    public ComplexGateway toComplexGateway() {
        this.updateActivityType(BpmnType.COMPLEX_GATEWAY, null);
        return this;
    }

    @Override
    public void setDirection(GatewayDirection gatewayDirection) {
        GatewayDirectionFeature gatewayDirectionFeature = this.getFeature(GatewayDirectionFeature.class);
        gatewayDirectionFeature.setValue(gatewayDirection);
    }

    @Override
    public BpmnType getBpmnType() {
        return this.bpmntype;
    }

    @Override
    public GatewayDirection getDirection() {
        return (GatewayDirection)this.getFeature(GatewayDirectionFeature.class).getValue();
    }

    @Override
    public void setMergingGateway(Gateway gateway) {
        ModelUtils.setPairedAssociatedGateways(this, gateway);
    }

    @Override
    @Nullable
    public Gateway getMergingGateway() {
        FlowNode node = ModelUtils.getAssociatedFlowNode(this);
        return node != null ? node.asAnyNode(Gateway.class) : null;
    }

    @Override
    public ThrowEvent toThrow(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.THROW_INTERMEDIATE_EVENT, triggerType);
        return this;
    }

    @Override
    public CatchEvent toCatch(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.CATCH_INTERMEDIATE_EVENT, triggerType);
        return this;
    }

    @Override
    public StartEvent toStart(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.START_EVENT, triggerType);
        return this;
    }

    @Override
    public void setBoundaryActivity(Activity act) {
        ModelUtils.setAssociatedFlowNodes(this, act);
    }

    @Override
    public EndEvent toEnd(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.END_EVENT, triggerType);
        this.setEventTriggerType(triggerType);
        return this;
    }

    @Override
    public void setEventTriggerType(EventTriggerType triggerType) {
        EventTriggerTypeFeature eventTriggerTypeFeature = this.getFeature(EventTriggerTypeFeature.class);
        EventTriggerType value = (EventTriggerType)eventTriggerTypeFeature.getValue();
        eventTriggerTypeFeature.setValue(triggerType);
        if (triggerType != null && value != triggerType) {
            this.updateFeatures(triggerType);
            this.updateEventDefinition(triggerType);
            this.clearDataAssociations();
        }
    }

    @Override
    @Nullable
    public EventDefinition getEventDefinition() {
        return this.definition;
    }

    @Override
    public EventTriggerType getEventTriggerType() {
        EventTriggerTypeFeature triggerTypeFeature = this.getFeature(EventTriggerTypeFeature.class);
        return triggerTypeFeature != null ? (EventTriggerType)triggerTypeFeature.getValue() : null;
    }

    @Override
    public boolean isCatchEvent() {
        return this.getBpmnType() == BpmnType.CATCH_INTERMEDIATE_EVENT || this.getBpmnType() == BpmnType.START_EVENT || this.getBpmnType() == BpmnType.BOUNDARY_EVENT;
    }

    @Override
    public boolean isThrowEvent() {
        return this.getBpmnType() == BpmnType.THROW_INTERMEDIATE_EVENT || this.getBpmnType() == BpmnType.END_EVENT;
    }

    @Override
    public boolean isStart() {
        return this.getBpmnType() == BpmnType.START_EVENT;
    }

    @Override
    public boolean isIntermediate() {
        return this.getBpmnType() == BpmnType.CATCH_INTERMEDIATE_EVENT || this.getBpmnType() == BpmnType.THROW_INTERMEDIATE_EVENT;
    }

    @Override
    @Nullable
    public <T extends Gateway> T asGateway(Class<T> clazz) {
        BpmnType type = BPMNTypes.getBpmnTypeFor(clazz);
        if (type == this.getBpmnType()) {
            switch (type) {
                case COMPLEX_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toComplexGateway()));
                }
                case EXCLUSIVE_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toExclusive()));
                }
                case INCLUSIVE_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toInclusive()));
                }
                case PARALLEL_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toParallel()));
                }
                case EVENT_BASED_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toEventBased()));
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Activity getBoundaryActivity() {
        FlowNode node = ModelUtils.getAssociatedFlowNode(this);
        return node != null ? node.asAnyNode(Activity.class) : null;
    }

    @Override
    public void setInstantiate(boolean instantiate) {
        this.getFeature(InstantiateFeature.class).setValue(instantiate);
    }

    @Override
    public void setType(EventBasedGatewayType type) {
        this.getFeature(EventBasedGatewayTypeFeature.class).setValue(type);
    }

    @Override
    public EventBasedGatewayType getType() {
        return (EventBasedGatewayType)((Object)this.getFeature(EventBasedGatewayTypeFeature.class).getValue());
    }

    @Override
    public boolean isInstantiate() {
        return this.getFeature(InstantiateFeature.class).getValue();
    }

    @Override
    public void setCancelActivity(boolean cancel) {
        this.setIsInterrupting(cancel);
    }

    @Override
    public boolean cancelActivity() {
        return this.isInterrupting();
    }

    @Override
    public void setIsInterrupting(boolean isInterrupting) {
        this.getFeature(IsInterruptingFeature.class).setValue(isInterrupting);
    }

    @Override
    public boolean isInterrupting() {
        return this.getEventTriggerType() == EventTriggerType.ERROR || this.getFeature(IsInterruptingFeature.class).getValue() != false;
    }

    @Override
    public String getOperationName() {
        switch (this.getBpmnType()) {
            case RECEIVE_TASK: 
            case SEND_TASK: 
            case SERVICE_TASK: 
            case BUSINESS_RULE_TASK: {
                return this.getFeature(ParticipantFeature.class).getOperationName();
            }
        }
        if (this.isConversationMember()) {
            return this.getFeature(ParticipantFeature.class).getOperationName();
        }
        return null;
    }

    @Override
    public CatalogMember getOperation() {
        ParticipantFeature feature = this.getFeature(ParticipantFeature.class);
        CatalogMember result = null;
        if (feature != null) {
            result = feature.getOperation();
        }
        return result;
    }

    @Override
    public void setOperationName(String operationName) {
        switch (this.getBpmnType()) {
            case RECEIVE_TASK: 
            case SEND_TASK: 
            case SERVICE_TASK: {
                this.getFeature(ParticipantFeature.class).setOperationName(operationName);
            }
        }
    }

    public void setServiceName(String serviceName) {
        this.getFeature(ParticipantFeature.class).setParticipantName(serviceName);
    }

    @Override
    public CatalogObject getParticipant() {
        CatalogObject result = null;
        ParticipantFeature feature = this.getFeature(ParticipantFeature.class);
        if (feature != null) {
            result = feature.getParticipant();
        }
        return result;
    }

    @Override
    public DataAssociationSet getOutputDataAssociationSet() {
        return this.getFeature(OutgoingDataAssociationFeature.class) != null ? this.getFeature(OutgoingDataAssociationFeature.class).getDataAssociationSet() : null;
    }

    @Override
    public String getParticipantName() {
        return this.getFeature(ParticipantFeature.class).getParticipantName();
    }

    @Override
    public void setScript(String code) {
        this.getFeature(ScriptTaskFeature.class).setScript(code);
    }

    @Override
    public String getScript() {
        return this.getFeature(ScriptTaskFeature.class).getScript();
    }

    @Override
    public void setSubject(Expression subject) {
        this.getFeature(UserTaskFeature.class).setSubject(subject);
    }

    @Override
    public Expression getSubject() {
        return this.getFeature(UserTaskFeature.class).getSubject();
    }

    @Override
    public void setPriority(int priority) {
        this.getFeature(UserTaskFeature.class).setPriority(priority);
    }

    @Override
    public int getPriority() {
        return this.getFeature(UserTaskFeature.class).getPriority();
    }

    @Override
    public void setInitiator(Expression initiator) {
        this.getFeature(UserTaskFeature.class).setInitiator(initiator);
    }

    @Override
    public Expression getInitiator() {
        return this.getFeature(UserTaskFeature.class).getInitiator();
    }

    @Override
    public void setOwner(Expression owner) {
        this.getFeature(UserTaskFeature.class).setOwner(owner);
    }

    @Override
    public Expression getOwner() {
        return this.getFeature(UserTaskFeature.class).getOwner();
    }

    @Override
    public void setIdentificationKey(Expression idKey) {
        this.getFeature(UserTaskFeature.class).setIdentificationKey(idKey);
    }

    @Override
    public Expression getIdentificationKey() {
        return this.getFeature(UserTaskFeature.class).getIdentificationKey();
    }

    @Override
    public void setIdentificationContext(Expression idContext) {
        this.getFeature(UserTaskFeature.class).setIdentificationContext(idContext);
    }

    @Override
    public Expression getIdentificationContext() {
        return this.getFeature(UserTaskFeature.class).getIdentificationContext();
    }

    @Override
    public void setApplicationContext(Expression appContext) {
        this.getFeature(UserTaskFeature.class).setApplicationContext(appContext);
    }

    @Override
    public Expression getApplicationContext() {
        return this.getFeature(UserTaskFeature.class).getApplicationContext();
    }

    @Override
    public void setHumanTask(HumanTask humanTask) throws ProjectException {
        if (ModelUtils.isSameObjectId(this.getHumanTask(), humanTask)) {
            return;
        }
        this.getFeature(UserTaskFeature.class).setHumanTask(humanTask);
        this.clearDataAssociations();
    }

    @Override
    public HumanTask getHumanTask() {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        return userTaskFeature != null ? userTaskFeature.getHumanTask() : null;
    }

    @Override
    public void setHumanTaskType(HumanTaskType humanTaskType) {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        if (userTaskFeature != null) {
            userTaskFeature.setHumanTaskType(humanTaskType != null ? humanTaskType : HumanTaskType.DEFAULT);
        }
    }

    @Override
    public HumanTaskType getHumanTaskType() {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        return userTaskFeature != null ? userTaskFeature.getHumanTaskType() : null;
    }

    @Override
    public boolean isReinitiate() {
        return this.getFeature(UserTaskFeature.class).isReInitiateFeature();
    }

    @Override
    public DataAssociationSet getInputDataAssociationSet() {
        return this.getFeature(IncomingDataAssociationFeature.class) != null ? this.getFeature(IncomingDataAssociationFeature.class).getDataAssociationSet() : null;
    }

    @Override
    public Process getCalledElement() {
        String processName;
        Process result = null;
        if (this.getFeature(RelatedProcessNameFeature.class) != null && (processName = this.getFeature(RelatedProcessNameFeature.class).getValue()) != null) {
            result = this.project.findProcess(processName);
        }
        return result;
    }

    @Override
    public void setCalledElement(Process callableSubprocess) {
        if (ModelUtils.isSameObjectId(this.getCalledElement(), callableSubprocess)) {
            return;
        }
        if (this.getFeature(RelatedProcessNameFeature.class) != null) {
            String value = callableSubprocess != null ? callableSubprocess.getId() : null;
            this.getFeature(RelatedProcessNameFeature.class).setValue(value);
            this.clearDataAssociations();
        }
    }

    @Override
    public String getCalledElementName() {
        return this.getFeature(RelatedProcessNameFeature.class).getValue();
    }

    @Override
    public void setCalledElementName(String callableSubprocessName) {
        this.getFeature(RelatedProcessNameFeature.class).setValue(callableSubprocessName);
    }

    @Override
    public void setParticipant(CatalogObject service) throws ProjectException {
        this.getFeature(ParticipantFeature.class).setParticipant(service);
    }

    @Override
    public void setOperation(CatalogMember operation) throws ProjectException {
        if (ModelUtils.isSameObjectInstance(this.getOperation(), operation)) {
            return;
        }
        this.getFeature(ParticipantFeature.class).setOperation(operation);
        this.clearDataAssociations();
    }

    @Override
    public ParticipantReference getParticipantRef() {
        return this.participantRef;
    }

    @Override
    public BoundaryEvent toBoundary(EventTriggerType triggerType, Activity relatedActivity) {
        this.updateActivityType(BpmnType.BOUNDARY_EVENT, triggerType);
        this.setEventTriggerType(triggerType);
        if (relatedActivity != null) {
            ModelUtils.setAssociatedFlowNodes(this, relatedActivity);
        }
        return this;
    }

    @Override
    public boolean isBoundaryEvent() {
        return this.getBpmnType() == BpmnType.BOUNDARY_EVENT;
    }

    public ActivityType getActivityType() {
        return null;
    }

    public void setActivityType(BpmnType type, EventTriggerType triggerType) {
        String s = this.getDefaultLabel();
        String s1 = this.getBpmnType() != null ? Identifier.valid(this.bpmntype.getString()) : "";
        boolean changeLabel = false;
        boolean sameType = Any.equals(this.bpmntype, type);
        boolean usesDefault = false;
        if (s1 != null && s.startsWith(s1)) {
            if (s.equals(s1)) {
                usesDefault = true;
            } else {
                String s2 = s.substring(s1.length());
                try {
                    Integer.parseInt(s2);
                    usesDefault = true;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (s != null && usesDefault && !sameType) {
            changeLabel = true;
        }
        if (!sameType || !Any.equals(triggerType, this.getEventTriggerType())) {
            this.bpmntype = type;
            this.updateFeatures(triggerType);
            if (triggerType != null) {
                this.updateEventDefinition(triggerType);
            }
            if (changeLabel) {
                this.setDefaultLabel(ModelUtils.generateDefaultLabel(this));
            }
        }
    }

    public FlowNode getActivity() {
        return this;
    }

    @Override
    public NodeContainer getParentObject() {
        return this.container;
    }

    @Override
    public void setBusinessRule(BusinessRule rule) throws ProjectException {
        this.setParticipant(rule);
    }

    @Override
    public String getBusinessRuleName() {
        return this.getParticipantName();
    }

    @Override
    public String getBusinessRuleNativeName() {
        return this.getBusinessRule().getDelegate().asSchemaObject().getName();
    }

    @Override
    public String getFunctionName() {
        return this.getOperationName();
    }

    @Override
    public BusinessRule getBusinessRule() {
        return (BusinessRule)this.getParticipant();
    }

    @Override
    public void setFunction(CatalogMember member) throws ProjectException {
        this.setOperation(member);
    }

    @Override
    public CatalogMember getFunction() {
        return this.getOperation();
    }

    @Override
    public OperationReference getOperationRef() {
        return this.operationRef;
    }

    @Override
    public boolean isAdjustable() {
        return !ModelUtils.isBoundaryEvent(this);
    }

    @Override
    public FlowNode copy() {
        ActivityImpl result = new ActivityImpl(this.getProcess(), this.getParentObject(), this.getBpmnType(), this.getEventTriggerType(), this.getId());
        ActivityImpl.copy(this, result);
        return result;
    }

    @Override
    public void applyFrom(FlowNode flowNode) throws ProjectException {
        if (!this.getBpmnType().getInnerType().equals((Object)flowNode.getBpmnType().getInnerType())) {
            throw new ProjectException(this, Msg.QUOTE("Flow Node is incompatible"));
        }
        if (flowNode.isEvent()) {
            Event event = (Event)flowNode;
            this.setActivityType(flowNode.getBpmnType(), event.getEventTriggerType());
            if (event.getEventDefinition() != null) {
                this.definition = event.getEventDefinition();
            }
        } else {
            this.setActivityType(flowNode.getBpmnType(), null);
        }
        ActivityImpl.copy(flowNode, this);
    }

    @Override
    public ActivityGenerateEvents getGenerateEvents() {
        return (ActivityGenerateEvents)this.getFeature(GenerateEventsFeature.class).getValue();
    }

    @Override
    public void setGenerateEvents(ActivityGenerateEvents generateEvents) {
        this.getFeature(GenerateEventsFeature.class).setValue(generateEvents);
    }

    @Override
    @Nullable
    public Subprocess getSubprocess() {
        NodeContainer parentObject = this.getParentObject();
        return parentObject != null && !parentObject.equals(this.getProcess()) ? (Subprocess)parentObject : null;
    }

    @Override
    public boolean isEnd() {
        return this.getBpmnType() == BpmnType.END_EVENT;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        if (this.isActivity()) {
            visitor.visit(this);
        } else if (this.isBoundaryEvent()) {
            visitor.visit(this);
        } else if (this.isEvent()) {
            visitor.visit((Event)this);
        } else if (this.isGateway()) {
            visitor.visit(this);
        } else {
            visitor.visit((FlowNode)this);
        }
    }

    @Override
    public Expression getActivationCondition() {
        return this.getFeature(ExpressionFeature.class).getValue();
    }

    @Override
    public void setActivationCondition(Expression expression) {
        this.getFeature(ExpressionFeature.class).setValue(expression);
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        return PredefinedVariablesHelper.getPredefinedVariablesForProjectObject(this, this);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return (DataDeclarationContainer)((Object)this.getParentObject());
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return DataDeclarationImpl.findDeclarationPath(this, path);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return false;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public ConversationEnabled getConversationInitiator() {
        ConversationFeature conversationFeature;
        ConversationEnabled result = null;
        if (this.isConversationMember() && (conversationFeature = this.getFeature(ConversationFeature.class)) != null) {
            FlowNode node;
            String initiatorId = conversationFeature.getInitiatiorId();
            Process process = this.getProcess();
            if (process != null && (node = process.findDescendant(FlowNode.class, initiatorId)) != null && node.isConversationMember()) {
                result = (ConversationEnabled)node;
            }
        }
        return result;
    }

    @Override
    public void setConversationInitiator(@Nullable ConversationEnabled initiator) {
        if (this.isConversationMember()) {
            String initiatorId = initiator != null ? initiator.getId() : null;
            this.getFeature(ConversationFeature.class).setInitiatiorId(initiatorId);
        }
    }

    @Override
    public boolean isSync() {
        ConversationEnabled conversationInitiator = this.getConversationInitiator();
        return conversationInitiator != null ? conversationInitiator.isSync() : this.isConversationMember() && this.getFeature(ConversationFeature.class).isSync();
    }

    @Override
    public boolean isConversationInitiator() {
        ConversationFeature conversationFeature = this.getFeature(ConversationFeature.class);
        return conversationFeature != null && Str.isEmpty(conversationFeature.getInitiatiorId());
    }

    @Override
    public void setSync(boolean sync) {
        if (this.isConversationMember()) {
            this.getFeature(ConversationFeature.class).setSync(sync);
        }
    }

    @Override
    @Nullable
    public String getDefinedOperationName() {
        String result = null;
        if (this.isConversationMember()) {
            ConversationFeature conversationFeature = this.getFeature(ConversationFeature.class);
            result = conversationFeature == null ? null : conversationFeature.getDefinedOperationName();
        }
        return result;
    }

    @Override
    public void setDefinedOperationName(@Nullable String operationName) {
        if (this.isConversationMember()) {
            if (ModelUtils.isSameObjectInstance(this.getDefinedOperationName(), operationName)) {
                return;
            }
            this.getFeature(ConversationFeature.class).setDefinedOperationName(operationName);
            if (operationName == null) {
                this.inputArgumentsContainer = null;
                this.outputArgumentsContainer = null;
            }
        }
    }

    @Override
    @Nullable
    public Process getAssociatedProcess() {
        Process process = null;
        if (this.isProcessCommunicationMember()) {
            String associatedProcessId = this.getFeature(ProcessCommunicationFeature.class).getAssociatedProcessId();
            Project project = this.getProject();
            process = project != null ? project.findProcess(associatedProcessId) : null;
        }
        return process;
    }

    @Override
    public void setAssociatedProcess(@Nullable Process process) {
        if (this.isProcessCommunicationMember()) {
            if (ModelUtils.isSameObjectId(this.getAssociatedProcess(), process)) {
                return;
            }
            String associatedProcessId = process != null ? process.getId() : null;
            this.getFeature(ProcessCommunicationFeature.class).setAssociatedProcessId(associatedProcessId);
        }
    }

    @Override
    @Nullable
    public ConversationEnabled getAssociatedNode() {
        ProcessCommunicationFeature processCommunicationFeature;
        ConversationEnabled result = null;
        if (this.isProcessCommunicationMember() && (processCommunicationFeature = this.getFeature(ProcessCommunicationFeature.class)) != null) {
            FlowNode node;
            String associatedNodeId = processCommunicationFeature.getAssociatedNodeId();
            Process process = this.getAssociatedProcess();
            if (process != null && (node = process.findDescendant(FlowNode.class, associatedNodeId)) instanceof ConversationEnabled) {
                result = (ConversationEnabled)node;
            }
        }
        return result;
    }

    @Override
    public void setAssociatedNode(@Nullable ConversationEnabled node) {
        if (this.isProcessCommunicationMember()) {
            if (ModelUtils.isSameObjectId(this.getAssociatedNode(), node)) {
                return;
            }
            this.setAssociatedProcess(node != null ? node.getProcess() : null);
            this.getFeature(ProcessCommunicationFeature.class).setAssociatedNodeId(node == null ? null : node.getId());
            this.clearDataAssociations();
        }
    }

    @Override
    public ErrorObject getAssociatedError() {
        ErrorObject result = null;
        ErrorEventDefinition definition = this.getErrorEventDefinition();
        if (definition != null) {
            result = definition.getError();
        }
        return result;
    }

    @Override
    public void setAssociatedError(ErrorObject error) {
        if (ModelUtils.isSameObjectInstance(this.getAssociatedError(), error)) {
            return;
        }
        ErrorEventDefinition definition = this.getErrorEventDefinition();
        if (definition != null) {
            definition.setError(error);
        }
    }

    public boolean waitForInteraction() {
        WaitForInteractionFeature feature = this.getFeature(WaitForInteractionFeature.class);
        return feature != null && feature.getValue() != false;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        DataDeclarationContainer result = null;
        ConversationEnabled conversationInitiator = this.getConversationInitiator();
        if (this.getOperation() != null) {
            CatalogMember operation = this.getOperation();
            boolean isCallbackService = operation.getParentObject() instanceof ServiceObject && ((ServiceObject)operation.getParentObject()).isCallback();
            boolean mustInvert = this.isConversationMember() && (conversationInitiator != null || ConversationHelper.isCatcher((ConversationEnabled)this)) || isCallbackService;
            result = mustInvert ? operation.getInputArgumentsContainer() : operation.getOutputArgumentsContainer();
        } else if (this.getAssociatedNode() != null) {
            Sequence continuators;
            ConversationEnabled associatedNode = this.getAssociatedNode();
            if (InputArgumentsEnabled.class.isAssignableFrom(associatedNode.getRawClass())) {
                result = ((InputArgumentsEnabled)((Object)associatedNode)).getInputArgumentsContainer();
            } else if (associatedNode.isSync() && !(continuators = ConversationHelper.getContinuatorsThrowers((ConversationEnabled)associatedNode, (boolean)false)).isEmpty()) {
                ConversationEnabled continuator = (ConversationEnabled)continuators.iterator().next();
                result = ((InputArgumentsEnabled)((Object)continuator)).getInputArgumentsContainer();
            }
        } else if (this.getHumanTask() != null) {
            HumanTask humanTask = this.getHumanTask();
            CatalogMember operation = this.usesTransformations() ? humanTask.findMember("invokeXSLT") : humanTask.findMember("invoke");
            result = operation != null ? operation.getOutputArgumentsContainer() : null;
        } else if (this.getCalledElement() != null) {
            Process process = this.getCalledElement();
            result = process.getOutputArgumentsContainer();
        } else if (this.getParentObject() == this.getProcess() && this.getProcess().isCallableSubprocess() && this.isStart() && this.getEventTriggerType() == EventTriggerType.NONE) {
            result = this.getProcess().getInputArgumentsContainer();
        } else if (this.isConversationMember() && ConversationHelper.isCatcher((ConversationEnabled)this) && conversationInitiator != null && ConversationHelper.isCatcher((ConversationEnabled)conversationInitiator) && this.getDefinedOperationName() != null && this.getDefinedOperationName().equals(conversationInitiator.getDefinedOperationName())) {
            result = ((OutputArgumentsEnabled)((Object)conversationInitiator)).getOutputArgumentsContainer();
        }
        if (result == null && this.getEventDefinition() != null) {
            result = this.createEventDefinitionPayloadContainer(this.getEventDefinition(), this.getEventTriggerType(), AccessType.OUT);
        }
        if (result == null) {
            if (this.outputArgumentsContainer == null) {
                this.outputArgumentsContainer = new ProcessArgumentContainer(this.project);
            }
            result = this.outputArgumentsContainer;
        }
        return result;
    }

    @Override
    public void setOutputArgumentsContainer(DataDeclarationContainer outputArgumentsContainer) {
        this.outputArgumentsContainer = outputArgumentsContainer;
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        DataDeclarationContainer result = null;
        if (this.getOperation() != null) {
            CatalogMember operation = this.getOperation();
            boolean mustInvert = !(!this.isConversationMember() || this.getConversationInitiator() == null && !ConversationHelper.isCatcher((ConversationEnabled)this) || this.getConversationInitiator() != null && !ConversationHelper.isCatcher((ConversationEnabled)this) && this.isCallbackService(operation));
            result = mustInvert ? operation.getOutputArgumentsContainer() : operation.getInputArgumentsContainer();
        } else if (this.getAssociatedNode() != null) {
            ConversationEnabled associatedNode = this.getAssociatedNode();
            if (OutputArgumentsEnabled.class.isAssignableFrom(associatedNode.getRawClass())) {
                result = ((OutputArgumentsEnabled)((Object)associatedNode)).getOutputArgumentsContainer();
            }
        } else if (this.getHumanTask() != null) {
            HumanTask humanTask = this.getHumanTask();
            CatalogMember operation = this.usesTransformations() ? humanTask.findMember("invokeXSLT") : humanTask.findMember("invoke");
            result = operation != null ? operation.getInputArgumentsContainer() : null;
        } else if (this.getCalledElement() != null) {
            Process process = this.getCalledElement();
            result = process.getInputArgumentsContainer();
        } else if (this.getParentObject() == this.getProcess() && this.getProcess().isCallableSubprocess() && this.isEnd() && this.getEventTriggerType() == EventTriggerType.NONE) {
            result = this.getProcess().getOutputArgumentsContainer();
        }
        if (result == null && this.getEventDefinition() != null) {
            result = this.createEventDefinitionPayloadContainer(this.getEventDefinition(), this.getEventTriggerType(), AccessType.IN);
        }
        if (result == null) {
            if (this.inputArgumentsContainer == null) {
                this.inputArgumentsContainer = new ProcessArgumentContainer(this.project);
            }
            result = this.inputArgumentsContainer;
        }
        return result;
    }

    @Override
    public void setInputArgumentsContainer(DataDeclarationContainer inputArgumentsContainer) {
        this.inputArgumentsContainer = inputArgumentsContainer;
    }

    @Override
    public void setReinitiateSource(UserTask source) {
        this.getFeature(UserTaskFeature.class).setReinitiateSource(source);
    }

    @Override
    public UserTask getReinitiateSource() {
        return this.getFeature(UserTaskFeature.class).getReinitiateSource();
    }

    protected static void copy(FlowNode source, FlowNode target) {
        target.setDefaultLabel(target.getDefaultLabel());
        target.getFeatures().copyFrom(source.getFeatures());
        target.setLabelMap(source.getLabelMap().clone());
        target.setDescription(source.getDescriptionMap().clone());
        ActivityImpl.copyLoopCharacteristics(source, target);
        ActivityImpl.copyArguments(source, target);
    }

    protected void updateFeatures(EventTriggerType eventTriggerType) {
        Features oldFeatures = this.features;
        this.removeModificationListener(oldFeatures);
        assert (this.getProcess() instanceof ProcessContent) : "model implementation should be process content.";
        this.features = FeaturesByBPMNType.get(this, this.getBpmnType());
        EventTriggerTypeFeature triggerTypeFeature = this.features.getFeature(EventTriggerTypeFeature.class);
        if (triggerTypeFeature != null && eventTriggerType != null) {
            triggerTypeFeature.setValue(eventTriggerType);
        }
        if (eventTriggerType != null) {
            this.features.extendFeatures(FeaturesByEventTrigger.get(this, eventTriggerType));
        }
        this.features.copyFrom(oldFeatures);
        this.addModificationListener(this.features);
    }

    private static void copyLoopCharacteristics(FlowNode source, FlowNode target) {
        if (source instanceof ActivityImpl && target instanceof ActivityImpl) {
            ActivityImpl sourceImpl = (ActivityImpl)source;
            ActivityImpl targetImpl = (ActivityImpl)target;
            targetImpl.loopCharacteristics = sourceImpl.loopCharacteristics;
            targetImpl.loopCharacteristicsContainer = sourceImpl.loopCharacteristicsContainer;
        }
    }

    private static void copyArguments(FlowNode source, FlowNode target) {
        Object targetImpl;
        Object sourceImpl;
        if (source instanceof InputArgumentsEnabled && target instanceof InputArgumentsEnabled) {
            sourceImpl = (InputArgumentsEnabled)((Object)source);
            targetImpl = (InputArgumentsEnabled)((Object)target);
            try {
                ActivityImpl.copyArguments(sourceImpl.getInputArgumentsContainer(), targetImpl.getInputArgumentsContainer());
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        if (source instanceof OutputArgumentsEnabled && target instanceof OutputArgumentsEnabled) {
            sourceImpl = (OutputArgumentsEnabled)((Object)source);
            targetImpl = (OutputArgumentsEnabled)((Object)target);
            try {
                ActivityImpl.copyArguments(sourceImpl.getOutputArgumentsContainer(), targetImpl.getOutputArgumentsContainer());
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    private static void dumpFeature(Feature f) {
        if (f.isSet()) {
            FeatureSet set = (FeatureSet)f;
            for (Feature f1 : set.getFeatures()) {
                ActivityImpl.dumpFeature(f1);
            }
        } else {
            System.out.println(" n=" + f.getName() + " c=" + f.getClass() + " v=" + f.getValue());
        }
    }

    private static void copyArguments(DataDeclarationContainer source, DataDeclarationContainer target) throws ProjectException {
        if (source != null && target != null && source != target && source.isMutableDeclarationContainer() && target.isMutableDeclarationContainer()) {
            target.clearDeclarations();
            Sequence<DataDeclaration> arguments = source.getLocalDeclarations();
            if (arguments != null) {
                for (DataDeclaration arg : arguments) {
                    DataDeclaration newArg = target.createDeclaration(arg.getName(), arg.getType());
                    target.addDeclaration(newArg);
                }
            }
        }
    }

    private boolean isCallbackService(CatalogMember operation) {
        return operation.getParentObject() instanceof InterfaceObject && ((InterfaceObject)operation.getParentObject()).isCallback();
    }

    private ErrorEventDefinition getErrorEventDefinition() {
        ErrorEventDefinition result = null;
        EventDefinition eventDefinition = this.getEventDefinition();
        if (eventDefinition != null && eventDefinition.as(MessageEventDefinition.class) != null) {
            MessageEventDefinition message = eventDefinition.as(MessageEventDefinition.class);
            result = message.getErrorEventDefinition();
        }
        return result;
    }

    private DataDeclarationContainer createEventDefinitionPayloadContainer(@NotNull EventDefinition eventDefinition, @NotNull EventTriggerType type, @NotNull AccessType accessType) {
        MessageEventDefinition message;
        DataDeclarationContainer result = null;
        if (type == EventTriggerType.SIGNAL) {
            SignalEventDefinition signal = eventDefinition.as(SignalEventDefinition.class);
            SignalObject signalObject = signal.getSignal();
            if (signalObject != null) {
                CatalogType payloadType = signalObject.getEventPayloadType();
                result = this.createPayloadContainer("payload", payloadType, accessType);
            }
            if (result == null) {
                result = new ProcessArgumentContainer(this.project);
            }
        } else if (type == EventTriggerType.ERROR) {
            ErrorEventDefinition error = eventDefinition.as(ErrorEventDefinition.class);
            ErrorObject errorObject = error.getError();
            if (errorObject != null) {
                Map<String, CatalogType> attributes = errorObject.getErrorInfoAttributes();
                result = this.createPayloadContainer(attributes, accessType);
            }
            if (result == null) {
                result = new ProcessArgumentContainer(this.project);
            }
        } else if (type == EventTriggerType.MESSAGE && (message = eventDefinition.as(MessageEventDefinition.class)).returnsErrors()) {
            Map<String, CatalogType> attributes = message.getErrorEventDefinition().getError().getErrorInfoAttributes();
            result = this.createPayloadContainer(attributes, accessType);
        }
        return result;
    }

    private DataDeclarationContainer createPayloadContainer(@NotNull String name, CatalogType type, @NotNull AccessType accessType) {
        ProcessArgumentContainer result = new ProcessArgumentContainer(this.project);
        if (type != null) {
            try {
                DataDeclaration dataDeclaration = result.createDeclaration(name, type, accessType);
                result.addDeclaration(dataDeclaration);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private DataDeclarationContainer createPayloadContainer(@NotNull Map<String, CatalogType> errorAttribues, @NotNull AccessType accessType) {
        ProcessArgumentContainer result = new ProcessArgumentContainer(this.project);
        for (Map.Entry<String, CatalogType> entry : errorAttribues.entrySet()) {
            try {
                DataDeclaration dataDeclaration = result.createDeclaration(entry.getKey(), entry.getValue(), accessType);
                result.addDeclaration(dataDeclaration);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void clearDataAssociations() {
        DataAssociationSet outputs;
        DataAssociationSet inputs = this.getInputDataAssociationSet();
        if (inputs != null) {
            inputs.clearDataAssociations();
        }
        if ((outputs = this.getOutputDataAssociationSet()) != null) {
            outputs.clearDataAssociations();
        }
    }

    private void updateLoopCharacteristics() {
        switch (this.getLoopCharacteristicsType()) {
            case LOOP: {
                this.loopCharacteristics = new LoopImpl();
                break;
            }
            case NONE: {
                this.loopCharacteristics = null;
                break;
            }
            case MULTIINSTANCE: {
                this.loopCharacteristics = new MultiInstanceImpl();
                break;
            }
            default: {
                this.loopCharacteristics = null;
            }
        }
        if (this.loopCharacteristics != null) {
            this.loopCharacteristicsContainer = new LoopCharacteristicsContainer(this);
        }
    }

    private void updateEventDefinition(EventTriggerType type) {
        if (type != null) {
            switch (type) {
                case MESSAGE: {
                    this.definition = new MessageEventDefinitionImpl(this);
                    break;
                }
                case TIMER: {
                    this.definition = new TimerEventDefinitionImpl(this);
                    break;
                }
                case ERROR: {
                    this.definition = new ErrorEventDefinitionImpl(this);
                    break;
                }
                case SIGNAL: {
                    this.definition = new SignalEventDefinitionImpl(this);
                    break;
                }
                case TERMINATE: {
                    this.definition = new TerminateEventDefinitionImpl(this);
                    break;
                }
                default: {
                    this.definition = null;
                    break;
                }
            }
        } else {
            this.definition = null;
        }
    }

    private int getOffsetInLane() {
        return ModelUtils.isHorizontal(this.getProcess()) ? this.getY() : this.getX();
    }

    private void updateActivityType(BpmnType type, EventTriggerType triggerType) {
        this.setActivityType(type, triggerType);
    }

    private class ParticipantReferenceAdapter
    implements ParticipantReference {
        private ParticipantReferenceAdapter() {
        }

        @Override
        @Nullable
        public String getId() {
            String baseServiceId = this.getBaseServiceId();
            String result = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operationWrapper = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                if (operationWrapper.isReference()) {
                    String name;
                    ConversationEnabled conversationEnabled = operationWrapper.isInitiator() ? operationWrapper.getConversationEnabled() : operationWrapper.getConversationInitiator();
                    Process associatedProcess = conversationEnabled.getAssociatedProcess();
                    if (conversationEnabled.getParticipant() != null) {
                        ObjectTypeDescription objectTypeDescription = conversationEnabled.getParticipant().getObjectType();
                        name = objectTypeDescription.getText();
                    } else {
                        assert (associatedProcess != null);
                        name = associatedProcess.getId();
                    }
                    result = name + ".reference";
                } else if (operationWrapper.isServiceDefiner()) {
                    result = ActivityImpl.this.getProcess().getId() + ".service";
                } else if (baseServiceId != null) {
                    result = baseServiceId + ".service";
                } else if (ActivityImpl.this.getConversationInitiator() != null && ActivityImpl.this.getConversationInitiator().getParticipantRef() != null) {
                    result = ActivityImpl.this.getConversationInitiator().getParticipantRef().getId();
                }
            } else if (baseServiceId != null) {
                result = baseServiceId + ".reference";
            }
            return result;
        }

        private String getBaseServiceId() {
            String result;
            if (ActivityImpl.this.getParticipant() != null) {
                ObjectTypeDescription otd = ActivityImpl.this.getParticipant().getObjectType();
                if (Boolean.valueOf(otd.getProperty("is.callback")).booleanValue()) {
                    otd = otd.getParent().asObject();
                }
                result = otd.getText();
            } else {
                result = null;
            }
            return result;
        }
    }

    private class OperationReferenceAdapter
    implements OperationReference {
        private Boolean isTwoWay = null;

        private OperationReferenceAdapter() {
        }

        @Override
        public String getName() {
            String result = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                result = operation.getName();
            }
            return result;
        }

        @Override
        public QName getInputType() {
            QName result = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                result = operation.getInputType();
            }
            return result;
        }

        @Override
        public QName getOutputType() {
            QName result = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                result = operation.getOutputType();
            }
            return result;
        }

        @Override
        public QName getFaultCodeError() {
            QName qName = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                qName = operation.getFaultCodeError();
            }
            return qName;
        }

        @Override
        public QName getFaultMessageType() {
            QName qName = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                qName = operation.getFaultMessageType();
            }
            return qName;
        }

        @Override
        public boolean allowsWrappedArguments() {
            boolean result = false;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                result = operation.allowsWrappedArguments();
            }
            return result;
        }

        @Override
        public String findArgumentPartName(String argumentName) {
            ProcessOperationWrapperImpl operation;
            String result = argumentName;
            if (ActivityImpl.this.isConversationMember() && !(operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this)).isServiceDefiner()) {
                ConversationEnabled enabled = operation.getConversationEnabled();
                if (enabled.getParticipant() != null) {
                    Argument argument;
                    MethodTypeDescription methodTypeDescription = operation.getOperationTypeDescription((ConversationEnabled)ActivityImpl.this);
                    Argument argument2 = argument = methodTypeDescription == null ? null : methodTypeDescription.findArgument(argumentName);
                    if (argument != null) {
                        result = argument.getProperty("partName");
                    }
                } else if (operation.hasErrors()) {
                    ErrorObject errorObject = operation.getError();
                    CatalogType argument = errorObject.getErrorInfoAttributes().get(argumentName);
                    assert (argument != null) : "Argument '" + argumentName + "' not found";
                    XmlTypeDescription xmlTd = TypeUtils.getModelObject((ObjectTypeDescription)argument.getDelegate().asObject());
                    assert (xmlTd != null);
                    result = xmlTd.getProperty("partName");
                }
            }
            return result;
        }

        @Override
        public boolean isTwoWay() {
            if (this.isTwoWay == null) {
                this.isTwoWay = this.calculateIsTwoWay();
            }
            return this.isTwoWay;
        }

        @Override
        public QName getPortType() {
            QName result = null;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                result = operation.getPortType();
            }
            return result;
        }

        private boolean calculateIsTwoWay() {
            boolean result = false;
            if (ActivityImpl.this.isConversationMember()) {
                ProcessOperationWrapperImpl operation = new ProcessOperationWrapperImpl((FlowNode)ActivityImpl.this);
                result = operation.isTwoWay();
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private TypeDescriptionInfo getTypeDescriptionInfo() {
            CatalogMember operation = ActivityImpl.this.getOperation();
            if (operation == null) return null;
            MethodTypeDescription method = operation.getMemberType();
            TypeDescriptionInfo result = new TypeDescriptionInfo();
            if (!(method instanceof DelegatedMethodTypeDescription)) throw new IllegalArgumentException("Only Delegated methods can be used in tasks. \nOperation: " + operation.getName() + " Method: " + method.getName());
            DelegatedMethodTypeDescription delegatedMethod = (DelegatedMethodTypeDescription)method;
            String signature = delegatedMethod.getDelegatedMethodSignature();
            TypeRef service = delegatedMethod.getDelegatedService();
            TypeDescription typeDescription = service.get();
            WsdlTypeDescription xmlObjectTypeDescription = (WsdlTypeDescription)typeDescription.asObject();
            result.setMethodTypeDescription(xmlObjectTypeDescription.findMethod(signature));
            result.setXmlObjectTypeDescription(xmlObjectTypeDescription);
            return result;
        }
    }

    private static class TypeDescriptionInfo {
        private MethodTypeDescription methodTypeDescription;
        private WsdlTypeDescription xmlObjectTypeDescription;

        private TypeDescriptionInfo() {
        }

        public MethodTypeDescription getMethodTypeDescription() {
            return this.methodTypeDescription;
        }

        public void setMethodTypeDescription(MethodTypeDescription methodTypeDescription) {
            this.methodTypeDescription = methodTypeDescription;
        }

        public WsdlTypeDescription getXmlObjectTypeDescription() {
            return this.xmlObjectTypeDescription;
        }

        public void setXmlObjectTypeDescription(WsdlTypeDescription wsdlType) {
            this.xmlObjectTypeDescription = wsdlType;
        }
    }

    public static class ActivityLocaleStringMap
    extends ModificationAwareLocaleStringMap {
        private transient FlowNode node;
        private BpmnType type;
        private static final long serialVersionUID = -329454869600275845L;

        protected ActivityLocaleStringMap(FlowNode node) {
            super(node);
            this.node = node;
            this.type = node.getBpmnType();
        }

        public FlowNode getActivity() {
            return this.node;
        }

        @Override
        public LocaleStringMap clone() {
            return super.clone();
        }

        protected static ActivityLocaleStringMap create(ActivityImpl activityImpl) {
            return new ActivityLocaleStringMap(activityImpl);
        }
    }
}

