/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bamdata;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import oracle.bpm.bamdata.BAMResourceRunningInfo;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum UnitIndicator implements Indicator,
I18nProvider
{
    AVG(ProjectMsg.AVG){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return runningInfo.getAvgCount();
        }
    }
    ,
    CURRENT(ProjectMsg.CURRENT){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getCount();
        }
    }
    ,
    MAX(ProjectMsg.MAX){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getMaxCount();
        }
    }
    ,
    AVG_QUEUE(ProjectMsg.AVG_QUEUE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return runningInfo.getAvgQueueCount();
        }
    }
    ,
    MAX_QUEUE(ProjectMsg.MAX_QUEUE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getMaxQueueCount();
        }
    }
    ,
    CURRENT_QUEUE(ProjectMsg.CURRENT_QUEUE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getQueueCount();
        }
    }
    ,
    AVG_WORK(ProjectMsg.AVG_WORK){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return runningInfo.getAvgWorkCount();
        }
    }
    ,
    CURRENT_WORK(ProjectMsg.CURRENT_WORK){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getCurrentWorkCount();
        }
    }
    ,
    MAX_WORK(ProjectMsg.MAX_WORK){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getMaxWorkCount();
        }
    }
    ,
    AVG_PERFORMANCE(ProjectMsg.AVG_PERFORMANCE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return runningInfo.getAvgPerformance();
        }
    }
    ,
    COMPLETED_OPERATIONS(ProjectMsg.COMPLETED_OPERATIONS){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getOperationsCompletedCount();
        }
    }
    ,
    COMPLETED_INSTANCES(ProjectMsg.COMPLETED_INSTANCES){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (long)runningInfo.getInstancesCompletedCount();
        }
    }
    ,
    AVG_RESOURCE_UTILIZATION(ProjectMsg.AVG_RESOURCE_UTILIZATION){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return runningInfo.getAvgResourceUtilization();
        }
    }
    ,
    MAX_RESOURCE_UTILIZATION(ProjectMsg.MAX_RESOURCE_UTILIZATION){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (double)((BAMResourceRunningInfo)runningInfo).getMaxAcquiredCount();
        }
    }
    ,
    RESOURCE_CURRENT_ACQUIRED(ProjectMsg.RESOURCE_CURRENT_ACQUIRED){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (double)((BAMResourceRunningInfo)runningInfo).getCurrentAcquiredCount();
        }
    }
    ,
    RESOURCE_AVG_BUSY(ProjectMsg.RESOURCE_AVG_BUSY){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (double)((BAMResourceRunningInfo)runningInfo).getPercentageBusyTime();
        }
    }
    ,
    RESOURCE_TOTAL_ACQUIRED(ProjectMsg.RESOURCE_TOTAL_ACQUIRED){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (double)((BAMResourceRunningInfo)runningInfo).getTotalAcquiredCount();
        }
    }
    ,
    RESOURCE_WAIT(ProjectMsg.RESOURCE_WAIT){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return (double)((BAMResourceRunningInfo)runningInfo).getWaitCount();
        }
    };

    private transient Msg msg;
    public static final Set<UnitIndicator> DEFAULT_INDICATORS;
    public static final Set<UnitIndicator> RESOURCE_INDICATORS;

    private UnitIndicator(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    @Override
    public Object get(BAMRunningInfo runningInfo) {
        return 0.0;
    }

    @Override
    public boolean isResourceIndicator() {
        return RESOURCE_INDICATORS.contains(this);
    }

    @Override
    public UnitType getUnitType() {
        return UnitType.UNITS;
    }

    static {
        DEFAULT_INDICATORS = EnumSet.of(COMPLETED_INSTANCES, COMPLETED_OPERATIONS, CURRENT, CURRENT_QUEUE, CURRENT_WORK);
        RESOURCE_INDICATORS = EnumSet.range(MAX_RESOURCE_UTILIZATION, RESOURCE_WAIT);
    }
}

