/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.lang.Literals;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HTMLReportGenerator {
    private File html;
    private File resourcesDir;
    private File xml;
    private File xsim;
    private String xsl;

    public HTMLReportGenerator(String xsl, File xml, File xsim, File html, File resourcesDir) {
        this.xsl = xsl;
        this.xml = xml;
        this.html = html;
        this.xsim = xsim;
        this.resourcesDir = resourcesDir;
    }

    public static void convertReport(File xml, File xsim, File html, File resourcesDir) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        String xsl = "/fuego/simulation/report/report2html.xsl";
        HTMLReportGenerator generator = new HTMLReportGenerator(xsl, xml, xsim, html, resourcesDir);
        generator.applyTransformer();
    }

    private void applyTransformer() throws ParserConfigurationException, TransformerException, IOException, SAXException {
        InputStream is = this.getClass().getResourceAsStream(this.xsl);
        assert (is != null);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(this.xml.toURL().openStream()));
        DOMSource domSource = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(is));
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperty("encoding", Literals.DEFAULT_ENCODING);
        transformer.setParameter("resources-dir", this.resourcesDir.getName());
        transformer.setParameter("xsim", this.xsim.getAbsolutePath());
        StreamResult streamResult = new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(this.html), Literals.DEFAULT_ENCODING));
        transformer.transform(domSource, streamResult);
    }
}

