/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.ConditionalSimulationActivityImpl;
import fuego.simulation.DistributionContainer;
import fuego.simulation.Event;
import fuego.simulation.InteractiveSimulationActivityImpl;
import fuego.simulation.JoinSimulationActivityImpl;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationResourceImpl;
import fuego.simulation.SplitSimulationActivityImpl;
import fuego.simulation.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.RelatedBPMNProcessFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.FlowNodeAdapter;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.FirstActivityInFlowFeature;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.simulation.CostType;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ParticipantSelectionPolicy;
import oracle.bpm.project.model.simulation.QueuePolicy;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.util.CalendarRule;
import org.jetbrains.annotations.NotNull;

public class SimulationFlowNodeImpl
extends ProjectObjectImpl
implements DistributionContainer,
ModelEvent,
SimulationFlowNode {
    protected FlowNode flowNode;
    protected List<ModelListener> listeners = new ArrayList<ModelListener>();
    protected ModelSimulation modelSimulation;
    private double abortProbability;
    private double backProbability;
    private List<Distribution> calculatedDistributions = new ArrayList<Distribution>();
    private CalendarRule calendarRule;
    private int capacity = 1;
    private double cost = 0.0;
    private CostType costType = CostType.FIXED_BASE_COST;
    private Distribution distribution;
    private Map<String, SequenceFlow> dynamicTransitions = new HashMap<String, SequenceFlow>();
    private double exceptionProbability;
    private String id;
    private boolean innerSimulation = false;
    private ParticipantSelectionPolicy participantSelectionPolicy = ParticipantSelectionPolicy.MINIMUM_COST;
    private QueuePolicy queuePolicy = QueuePolicy.FIFO;
    private int queueWarningLevel = this.capacity;
    private ModelSimulation relatedSimulationModel;
    private String relatedSimulationModelName;
    private List<SimulationResource> resources = new ArrayList<SimulationResource>();
    private List<SequenceFlow> runtimeOutputTransitions;
    private double sendProbability;
    private double skipProbability;
    private boolean useOrgResources = false;
    protected static final int SHOW_DURATION = 1;
    protected static final int SHOW_RESOURCES = 2;
    protected static final int SHOW_COST = 4;
    protected static final int SHOW_QUEUE_INFO = 8;
    protected static final int SHOW_TRANSITIONS = 16;
    protected static final int SHOW_INNER_ACT = 32;
    protected static final int SHOW_INNER_PROCESS = 64;
    protected static final int SHOW_COPIES_INFO = 128;
    protected static final int SHOW_THREADS = 256;
    protected static final int SHOW_INSTANCE_CREATION = 512;
    protected static final int SHOW_NONE = 0;

    protected SimulationFlowNodeImpl(FlowNode node) {
        super(node.getProject());
        this.flowNode = node;
        this.setId(node.getId());
    }

    public static SimulationFlowNodeImpl create(FlowNode modelNode, ModelSimulation simulationModel) {
        SimulationFlowNodeHandler flowNodeHandler = new SimulationFlowNodeHandler(simulationModel);
        ModelUtils.handleFlowNode(modelNode, flowNodeHandler);
        return flowNodeHandler.getSimulationActivity();
    }

    public static List<SequenceFlow> findExceptionOutputTransitions(FlowNode node, SimulationFlowNodeImpl simulationActivityInfo) {
        ArrayList<SequenceFlow> outputTransitions = new ArrayList<SequenceFlow>();
        for (SequenceFlow t : node.getOutgoingSequenceFlows()) {
            if (!t.isExceptionFlow()) continue;
            outputTransitions.add(t);
        }
        if (node.getSubprocess() != null && (!ModelUtils.isInCompensateLevel(node) || ModelUtils.isInCompensateLevel(node.getSubprocess()))) {
            outputTransitions.addAll(SimulationFlowNodeImpl.findExceptionOutputTransitions(node.getSubprocess(), simulationActivityInfo));
        }
        simulationActivityInfo.assignProbabilityToExceptionTransitions(outputTransitions);
        return outputTransitions;
    }

    public static List<SequenceFlow> findValidForSimulationOutputTransitions(FlowNode node) {
        List<SequenceFlow> outputTransitions = SimulationFlowNodeImpl.findSimulationOutputTransitions(node);
        return outputTransitions;
    }

    public static List<SequenceFlow> findValidInterruptingBoundaryEventsSeqFlows(Activity activity) {
        return SimulationFlowNodeImpl.findValidBoundaryEventsSeqFlows(activity, true);
    }

    public static List<SequenceFlow> findValidNonInterruptingBoundaryEventsSeqFlows(Activity activity) {
        return SimulationFlowNodeImpl.findValidBoundaryEventsSeqFlows(activity, false);
    }

    public void setFlowNode(FlowNode activity) {
        this.flowNode = activity;
    }

    @Override
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public AbstractDistribution getDefaultDistribution() {
        return AbstractDistribution.create(DistributionType.NORMAL);
    }

    public void addOtherTransitions(List<SequenceFlow> list) {
    }

    public int getPanelsToShow() {
        int panelsToShow = ModelUtils.isSubprocess(this.flowNode) ? (this.getInnerSimulation() ? 32 : 63) : (ModelUtils.isAnyInteractive(this.flowNode) ? 31 : (ModelUtils.isCallActivity(this.flowNode) ? (this.getInnerSimulation() ? 80 : 93) : (ModelUtils.isStartEvent(this.flowNode) ? 512 : (!this.flowNode.isGateway() ? 285 : 16))));
        return panelsToShow;
    }

    @Override
    public void setAbortProbability(double abortProbability) {
        this.abortProbability = abortProbability;
    }

    public void setAbortProbability(String prob) {
        this.setAbortProbability(Double.valueOf(prob));
    }

    public void setSkipProbability(String prob) {
        this.setSkipProbability(Double.valueOf(prob));
    }

    @Override
    public void setSkipProbability(double skipProbability) {
        this.skipProbability = skipProbability;
    }

    public void setSendProbability(String prob) {
        this.setSendProbability(Double.valueOf(prob));
    }

    @Override
    public void setSendProbability(double sendProbability) {
        this.sendProbability = sendProbability;
    }

    public void setBackProbability(String prob) {
        this.setBackProbability(Double.valueOf(prob));
    }

    @Override
    public void setBackProbability(double backProbability) {
        this.backProbability = backProbability;
    }

    @Override
    public double getAbortProbability() {
        return this.abortProbability;
    }

    @Override
    public void setCostType(CostType costType) {
        this.costType = costType;
    }

    public void setActivityCostType(String activityCostType) {
        this.setCostType(CostType.valueOf(activityCostType));
    }

    @Override
    public CostType getActivityCostType() {
        return this.costType;
    }

    @Override
    public List<SimulationResource> getAvailableResources() {
        return this.resources;
    }

    public void setCalendarRule(CalendarRule calendarRule) {
        this.calendarRule = calendarRule;
    }

    public CalendarRule getCalendarRule() {
        return this.calendarRule;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.fireCapacityChangedEvent();
    }

    public void setCapacity(String capacity) {
        this.setCapacity(Integer.parseInt(capacity));
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public String getClassName() {
        return "Activity";
    }

    @Override
    public void setCost(double v) {
        this.cost = v;
    }

    public void setCost(String value) {
        this.setCost(Double.valueOf(value));
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public void setDistribution(Distribution distrib) {
        this.distribution = distrib;
    }

    @Override
    public Distribution getDistribution() {
        if (this.distribution == null) {
            this.distribution = this.getDefaultDistribution();
        }
        return this.distribution;
    }

    public void setExceptionProbability(String prob) {
        this.setExceptionProbability(Double.valueOf(prob));
    }

    @Override
    public void setExceptionProbability(double exceptionProbability) {
        this.exceptionProbability = exceptionProbability;
    }

    @Override
    public double getExceptionProbability() {
        return this.exceptionProbability;
    }

    @Override
    public void setInnerSimulation(boolean innerSimulation) {
        this.innerSimulation = innerSimulation;
    }

    public void setInnerSimulation(String innerSimulation) {
        this.innerSimulation = Boolean.valueOf(innerSimulation);
    }

    @Override
    public boolean getInnerSimulation() {
        return this.innerSimulation;
    }

    @Override
    public void setParticipantSelectionPolicy(ParticipantSelectionPolicy policy) {
        this.participantSelectionPolicy = policy;
    }

    public void setParticipantSelectionPolicy(String policy) {
        this.setParticipantSelectionPolicy(ParticipantSelectionPolicy.valueOf(policy));
    }

    @Override
    public ParticipantSelectionPolicy getParticipantSelectionPolicy() {
        return this.participantSelectionPolicy;
    }

    public void setQueuePolicy(String policy) {
        this.setQueuePolicy(QueuePolicy.valueOf(policy));
    }

    @Override
    public void setQueuePolicy(QueuePolicy queuePolicy) {
        this.queuePolicy = queuePolicy;
    }

    @Override
    public QueuePolicy getQueuePolicy() {
        return this.queuePolicy;
    }

    public void setQueueWarningLevel(String queueWarningLevel) {
        this.setQueueWarningLevel(Integer.valueOf(queueWarningLevel));
    }

    @Override
    public void setQueueWarningLevel(int queueWarningLevel) {
        this.queueWarningLevel = queueWarningLevel;
    }

    @Override
    public int getQueueWarningLevel() {
        return this.queueWarningLevel;
    }

    public void setRelatedSimulationModel(ModelSimulation simulationModel) {
        this.relatedSimulationModel = simulationModel;
        this.relatedSimulationModelName = simulationModel != null ? simulationModel.getId() : null;
    }

    public ModelSimulation getRelatedSimulationModel(Simulation simulation) {
        Sequence<ModelSimulation> models;
        Process relatedProcess = this.getFlowNode().getFeature(RelatedBPMNProcessFeature.class).getRelatedProcess(this.getFlowNode().getProject());
        ModelSimulation simulationModel = simulation.getProcessModel(relatedProcess);
        if (simulationModel != null) {
            return simulationModel;
        }
        SimulationsContainer simulationsContainer = relatedProcess.getProject().getSimulations();
        if (this.relatedSimulationModel == null && this.getInnerSimulation() && !(models = simulationsContainer.getModelSimulationsByProcess(relatedProcess)).isEmpty()) {
            this.relatedSimulationModel = models.iterator().next();
        }
        return this.relatedSimulationModel;
    }

    public void setRelatedSimulationModelName(String simulationModelName) {
        this.relatedSimulationModelName = simulationModelName;
    }

    public String getRelatedSimulationModelName() {
        if (this.relatedSimulationModelName == null) {
            this.relatedSimulationModelName = this.relatedSimulationModel != null ? this.relatedSimulationModel.getId() : null;
        }
        return this.relatedSimulationModelName;
    }

    public void setUseOrgResources(String useOrgResources) {
        this.useOrgResources = Boolean.valueOf(useOrgResources);
    }

    @Override
    public void setUseOrgResources(boolean value) {
        this.useOrgResources = value;
    }

    @Override
    public boolean getUseOrgResources() {
        return this.useOrgResources;
    }

    public Collection<SequenceFlow> getValidForSimulationRuntimeOutputTransitions(Token token) {
        List<SequenceFlow> backFromCompensate = this.findBackFromCompensationOutputTransitions(token);
        if (this.runtimeOutputTransitions == null) {
            this.runtimeOutputTransitions = new ArrayList<SequenceFlow>();
            this.runtimeOutputTransitions.addAll(SimulationFlowNodeImpl.findValidForSimulationOutputTransitions(this.flowNode));
            if (this.flowNode.isActivity()) {
                Activity activity = this.flowNode.asAnyNode(Activity.class);
                this.runtimeOutputTransitions.addAll(SimulationFlowNodeImpl.findValidInterruptingBoundaryEventsSeqFlows(activity));
            }
            this.addOtherTransitions(this.runtimeOutputTransitions);
        }
        return backFromCompensate.isEmpty() ? this.runtimeOutputTransitions : CollectionUtils.concat(this.runtimeOutputTransitions, backFromCompensate);
    }

    @Override
    public void addResource(SimulationResource resource) {
        if (!this.getAvailableResources().contains(resource)) {
            this.getAvailableResources().add(resource);
            for (ModelListener listener : this.listeners) {
                ((SimulationResourceImpl)resource).addListener(listener);
            }
        }
    }

    @Override
    public void clearResources() {
        this.resources.clear();
    }

    public void scheduleMove(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        long eventTime = this.getNextIPT(token, currentTime, random);
        this.scheduleMove(eventTime, currentTime, token, eventQueue, random);
    }

    public void scheduleMove(long eventTime, long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        FlowNode act;
        FlowNode flowNode;
        SequenceFlow transition = this.chooseDueTransition(currentTime, eventTime - token.getArrivalTime());
        if (transition == null) {
            transition = this.chooseTransition(currentTime, token, random);
        }
        if (ModelUtils.isDueFlow(transition)) {
            eventTime = currentTime + this.getDueInterval(currentTime, transition.getSource().asAnyNode(BoundaryEvent.class)).getTotalMicroseconds();
            token.setArrivalTime(currentTime);
        }
        if (ModelUtils.isLink(flowNode = transition.getTarget())) {
            oracle.bpm.project.model.processes.Event event = flowNode.asAnyNode(oracle.bpm.project.model.processes.Event.class);
            NodeAssociationFeature feature = event.getFeature(NodeAssociationFeature.class);
            act = feature.getAssociatedNode();
        } else {
            act = transition.getTarget();
        }
        eventQueue.offer(Event.createMoveEvent(token, eventTime, this.getFlowNode(), act, transition));
        if (this.getFlowNode().isActivity()) {
            this.scheduleMoveFromNonInterruptingBoundaryEvents(this.getFlowNode().asAnyNode(Activity.class), eventTime, currentTime, token, eventQueue, random);
        }
    }

    public void scheduleTerminate(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        eventQueue.offer(Event.createTerminateEvent(token, currentTime, this.getFlowNode()));
    }

    public ModelSimulation getModelSimulation() {
        return this.modelSimulation;
    }

    public void setModelSimulation(ModelSimulation modelSimulation) {
        this.modelSimulation = modelSimulation;
    }

    @Override
    public void setId(String activityId) {
        this.id = activityId;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.SIMULATION_ACTIVITY;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.modelSimulation;
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
    }

    public boolean showCopiesInfo() {
        return (this.getPanelsToShow() & 0x80) != 0;
    }

    public boolean showCost() {
        return (this.getPanelsToShow() & 4) != 0;
    }

    public boolean showDuration() {
        return (this.getPanelsToShow() & 1) != 0;
    }

    public boolean showInstanceCreation() {
        return (this.getPanelsToShow() & 0x200) != 0;
    }

    public boolean showInnerAct() {
        return (this.getPanelsToShow() & 0x20) != 0;
    }

    public boolean showInnerProcess() {
        return (this.getPanelsToShow() & 0x40) != 0;
    }

    public boolean showQueueInfo() {
        return (this.getPanelsToShow() & 8) != 0;
    }

    public boolean showResources() {
        return (this.getPanelsToShow() & 2) != 0;
    }

    public boolean showThreads() {
        return (this.getPanelsToShow() & 0x100) != 0;
    }

    public boolean showTransitions() {
        return (this.getPanelsToShow() & 0x10) != 0;
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public double getSkipProbability() {
        return this.skipProbability;
    }

    @Override
    public double getSendProbability() {
        return this.sendProbability;
    }

    @Override
    public double getBackProbability() {
        return this.backProbability;
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addCalculatedDistribution(Distribution d) {
        this.calculatedDistributions.add(d);
        this.events().objectChanged("calculatedDistribution", null, d);
    }

    @Override
    public void removeCalculatedDistribution(Distribution d) {
        if (this.calculatedDistributions.remove(d)) {
            this.events().objectChanged("calculatedDistribution", d, null);
        }
    }

    public Distribution getCalculatedDistributionForType(DistributionType distributionType) {
        for (Distribution otherDistribution : this.calculatedDistributions) {
            if (!otherDistribution.getType().equals(distributionType)) continue;
            return otherDistribution;
        }
        return this.distribution;
    }

    @Override
    public Distribution[] getCalculatedDistributions() {
        return this.calculatedDistributions.toArray(new Distribution[this.calculatedDistributions.size()]);
    }

    protected double getTransitionProbability(SequenceFlow transition, double dflt) {
        SimulationSequenceFlow sequenceFlowInfo = this.asSimulationTransition(transition);
        return sequenceFlowInfo == null ? dflt : sequenceFlowInfo.getProbability();
    }

    protected SequenceFlow getDynamicTransition(String targetActivityId) {
        SequenceFlow transition = this.dynamicTransitions.get(targetActivityId);
        if (transition == null) {
            Process content = this.getFlowNode().getProcess();
            transition = content.createSequenceFlow(this.getFlowNode(), content.findNode(targetActivityId));
            this.dynamicTransitions.put(targetActivityId, transition);
        }
        return transition;
    }

    protected long getNextIPT(Token token, long currentTime, Random random) {
        long interval = this.getDistribution().next(random, currentTime);
        return currentTime + interval;
    }

    protected Subprocess getParentGroup() {
        return Simulation.getParentGroup(this.getFlowNode());
    }

    protected Interval getDueInterval(long currentTime, BoundaryEvent boundaryEvent) {
        TimerEventDefinition timerDef;
        Interval dueInterval = Interval.valueOf(Long.MAX_VALUE);
        if (boundaryEvent.getEventTriggerType() == EventTriggerType.TIMER && (timerDef = boundaryEvent.getEventDefinition().as(TimerEventDefinition.class)).getTimeCycleExpression() != null) {
            try {
                dueInterval = Interval.valueOf(XPathExpression.fromXPathLiteral((String)timerDef.getTimeCycleExpression().getExpressionValue()));
            }
            catch (FormatException e) {
                // empty catch block
            }
        }
        return dueInterval;
    }

    protected SequenceFlow chooseDueTransition(long currentTime, long activityTime) {
        List<BoundaryEvent> timerBoundaries = SimulationFlowNodeImpl.findTimerBoundaries(this.flowNode);
        SequenceFlow result = null;
        if (!timerBoundaries.isEmpty()) {
            BoundaryEvent boundaryEvent = timerBoundaries.get(0);
            result = CollectionUtils.first(boundaryEvent.getOutgoingSequenceFlows());
            Interval due = this.getDueInterval(currentTime, boundaryEvent);
            for (BoundaryEvent be : timerBoundaries) {
                Interval currentDue = this.getDueInterval(currentTime, be);
                if (currentDue.compareTo(due) > 0) continue;
                result = CollectionUtils.first(be.getOutgoingSequenceFlows());
                due = currentDue;
            }
            if (Interval.valueOf(activityTime).compareTo(due) <= 0) {
                result = null;
            }
        }
        return result;
    }

    protected SequenceFlow chooseTransition(long currentTime, Token token, Random random) {
        double prob = random.nextDouble();
        Collection<SequenceFlow> list = this.getValidForSimulationRuntimeOutputTransitions(token);
        int size = list.size();
        double defaultProb = 1.0 / (double)size;
        SequenceFlow last = null;
        for (SequenceFlow transition : list) {
            if ((prob -= this.getTransitionProbability(transition, defaultProb)) < 0.0) {
                return transition;
            }
            last = transition;
        }
        SequenceFlow dueTransition = this.chooseDueTransition(currentTime, Long.MAX_VALUE);
        return dueTransition != null ? dueTransition : last;
    }

    private static List<SequenceFlow> findValidBoundaryEventsSeqFlows(Activity activity, boolean interrupting) {
        ArrayList<SequenceFlow> outputTransitions = new ArrayList<SequenceFlow>();
        for (BoundaryEvent be : activity.getActivityBoundaryEvents()) {
            Sequence<SequenceFlow> flowSequence;
            boolean filter = interrupting ? be.cancelActivity() : !be.cancelActivity();
            if (!filter || be.getEventTriggerType() == EventTriggerType.TIMER || (flowSequence = be.getOutgoingSequenceFlows()).isEmpty()) continue;
            outputTransitions.add(CollectionUtils.first(flowSequence));
        }
        return outputTransitions;
    }

    private static List<SequenceFlow> findSendFromExceptionOutputTransitions(ModelSimulation modelSimulation, FlowNode activity, SimulationFlowNodeImpl simulationActivityInfo) {
        if (ModelUtils.isInExceptionHandlerLevel(activity) && ModelUtils.getOutgoingSequenceFlows(activity).isEmpty()) {
            FlowNode targetNode = SimulationFlowNodeImpl.findActivityTrowedException(activity);
            Subprocess parent = Simulation.getParentGroup(targetNode);
            List<SequenceFlow> outputTransitions = SimulationFlowNodeImpl.findValidForSimulationOutputTransitions(parent);
            double sendProbability = simulationActivityInfo.getCalculatedDistributions() != null && simulationActivityInfo.getCalculatedDistributions().length > 0 ? simulationActivityInfo.getSendProbability() : 1.0 - simulationActivityInfo.getAbortProbability() - simulationActivityInfo.getExceptionProbability();
            return SimulationFlowNodeImpl.buidlCloneTransitionsFromExceptiontoOutputs(modelSimulation, activity, outputTransitions, sendProbability);
        }
        return Collections.emptyList();
    }

    private static List<SequenceFlow> buidlCloneTransitionsFromExceptiontoOutputs(ModelSimulation model, FlowNode activity, List<SequenceFlow> outputTransitions, double sendProbability) {
        ArrayList<SequenceFlow> clonedOutputTransitions = new ArrayList<SequenceFlow>();
        double sum = 0.0;
        for (SequenceFlow outputTransition : outputTransitions) {
            SimulationSequenceFlow info = model.asSimulationSequenceFlow(outputTransition);
            sum += info.getProbability();
        }
        double k = sendProbability / sum;
        for (SequenceFlow outputTransition : outputTransitions) {
            SimulationSequenceFlow info = model.asSimulationSequenceFlow(outputTransition);
            Process content = activity.getProcess();
            SequenceFlow cloneTransition = content.createSequenceFlow(outputTransition.getSource(), outputTransition.getTarget());
            model.asSimulationSequenceFlow(cloneTransition).setProbability(info.getProbability() * k);
            clonedOutputTransitions.add(cloneTransition);
        }
        return clonedOutputTransitions;
    }

    private static List<SequenceFlow> findSkipFromExceptionOutputTransitions(ModelSimulation modelSimulation, FlowNode activity, SimulationFlowNodeImpl simulationActivityInfo) {
        if (ModelUtils.isInExceptionHandlerLevel(activity) && ModelUtils.getOutgoingSequenceFlows(activity).isEmpty()) {
            FlowNode targetNode = SimulationFlowNodeImpl.findActivityTrowedException(activity);
            List<SequenceFlow> outputTransitions = SimulationFlowNodeImpl.findValidForSimulationOutputTransitions(targetNode);
            double skipProbability = simulationActivityInfo.getCalculatedDistributions() != null && simulationActivityInfo.getCalculatedDistributions().length > 0 ? simulationActivityInfo.getSkipProbability() : 1.0 - simulationActivityInfo.getAbortProbability() - simulationActivityInfo.getExceptionProbability();
            return SimulationFlowNodeImpl.buidlCloneTransitionsFromExceptiontoOutputs(modelSimulation, activity, outputTransitions, skipProbability);
        }
        return Collections.emptyList();
    }

    private static List<BoundaryEvent> findTimerBoundaries(FlowNode node) {
        ArrayList<BoundaryEvent> boundaries = new ArrayList<BoundaryEvent>();
        if (node.isActivity()) {
            Activity activity = node.asAnyNode(Activity.class);
            for (BoundaryEvent boundaryEvent : activity.getActivityBoundaryEvents()) {
                Sequence<SequenceFlow> flowSequence;
                if (boundaryEvent.getEventTriggerType() != EventTriggerType.TIMER || !boundaryEvent.cancelActivity() || (flowSequence = boundaryEvent.getOutgoingSequenceFlows()).isEmpty()) continue;
                boundaries.add(boundaryEvent);
            }
        }
        return boundaries;
    }

    private static List<SequenceFlow> findSimulationOutputTransitions(FlowNode flowNode) {
        ArrayList<SequenceFlow> outputTransitions = new ArrayList<SequenceFlow>();
        for (SequenceFlow t : flowNode.getOutgoingSequenceFlows()) {
            outputTransitions.add(t);
        }
        return outputTransitions;
    }

    private static List<SequenceFlow> findBackFromExceptionOutputTransitions(FlowNode activity, SimulationFlowNodeImpl simulationActivityInfo) {
        ArrayList<SequenceFlow> backTransitions = new ArrayList<SequenceFlow>();
        if (ModelUtils.isInExceptionHandlerLevel(activity) && ModelUtils.getOutgoingSequenceFlows(activity).isEmpty()) {
            FlowNode targetNode = SimulationFlowNodeImpl.findActivityTrowedException(activity);
            backTransitions.add(simulationActivityInfo.getDynamicTransition(targetNode.getId()));
        }
        return backTransitions;
    }

    private static FlowNode findActivityTrowedException(FlowNode activity) {
        FirstActivityInFlowFeature feature = activity.getFeature(FirstActivityInFlowFeature.class);
        return activity.getProcess().findActivity(feature.getValue());
    }

    private void scheduleMoveFromNonInterruptingBoundaryEvents(Activity activity, long eventTime, long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        List<SequenceFlow> list = SimulationFlowNodeImpl.findValidNonInterruptingBoundaryEventsSeqFlows(activity);
        for (SequenceFlow sequenceFlow : list) {
            boolean schedule = random.nextDouble() <= this.getTransitionProbability(sequenceFlow, 0.0);
            if (!schedule) continue;
            Event event = Event.createMoveEvent(Token.create(token, currentTime, false), currentTime, activity, sequenceFlow.getTarget(), sequenceFlow);
            eventQueue.offer(event);
        }
    }

    private SimulationSequenceFlow asSimulationTransition(SequenceFlow transition) {
        return this.modelSimulation == null ? null : this.modelSimulation.asSimulationSequenceFlow(transition);
    }

    private SequenceFlow createAbortOutputTransition() {
        SequenceFlow abortTransition = this.getDynamicTransition(ModelUtils.getAnyEndEvent(this.getFlowNode().getParentObject()).getId());
        this.modelSimulation.asSimulationSequenceFlow(abortTransition).setProbability(this.getAbortProbability());
        return abortTransition;
    }

    private List<SequenceFlow> findBackFromCompensationOutputTransitions(Token token) {
        FlowNode caller;
        if (!ModelUtils.getOutgoingSequenceFlows(this.flowNode).isEmpty() || !ModelUtils.isInCompensateLevel(this.flowNode)) {
            return Collections.emptyList();
        }
        ActivitiesToCompensate toCompensate = (ActivitiesToCompensate)token.popData();
        FlowNode nextCompensable = toCompensate.getNextActivityToCompensate(token);
        List<SequenceFlow> result = null;
        if (nextCompensable == null && (result = SimulationFlowNodeImpl.findValidForSimulationOutputTransitions(caller = toCompensate.getCompensate().getFlowNode())).isEmpty()) {
            result.add(toCompensate.getCompensate().createAbortOutputTransition());
            result.addAll(SimulationFlowNodeImpl.findBackFromExceptionOutputTransitions(caller, this));
            result.addAll(toCompensate.getCompensate().findBackFromCompensationOutputTransitions(token));
            result.addAll(SimulationFlowNodeImpl.findSendFromExceptionOutputTransitions(this.modelSimulation, caller, this));
            result.addAll(SimulationFlowNodeImpl.findExceptionOutputTransitions(caller, this));
        }
        return result;
    }

    private void assignProbabilityToExceptionTransitions(List<SequenceFlow> exceptionTransitions) {
        if (this.getCalculatedDistributions() == null || this.getCalculatedDistributions().length == 0) {
            double prob = this.getExceptionProbability() / (double)exceptionTransitions.size();
            for (SequenceFlow transition : exceptionTransitions) {
                this.asSimulationTransition(transition).setProbability(prob);
            }
        }
    }

    private void fireCapacityChangedEvent() {
        for (ModelListener listener : this.listeners) {
            listener.capacityChanged(this);
        }
    }

    private static class SimulationFlowNodeHandler
    extends FlowNodeAdapter {
        private SimulationFlowNodeImpl model;
        private final ModelSimulation modelSimulation;
        private static final int DEFAULT_AUTOMATIC_THREADS_CAPACITY = 100;

        public SimulationFlowNodeHandler(ModelSimulation modelSimulation) {
            this.modelSimulation = modelSimulation;
        }

        @Override
        public void handleCommon(FlowNode node) {
            this.handleAutomaticActivity(node);
        }

        @Override
        public void handleEndEvent(EndEvent node) {
            this.model = new SimulationFlowNodeImpl(node);
        }

        @Override
        public void handleExclusiveGateway(ExclusiveGateway node) {
            this.model = new ConditionalSimulationActivityImpl(node);
        }

        @Override
        public void handleInclusiveGateway(InclusiveGateway node) {
            this.handleGateway(node);
        }

        @Override
        public void handleParallelGateway(ParallelGateway node) {
            this.handleGateway(node);
        }

        @Override
        public void handleStartEvent(StartEvent node) {
            this.model = new SimulationFlowNodeImpl(node);
        }

        @Override
        public void handleUserTask(UserTask node) {
            this.model = new InteractiveSimulationActivityImpl(node);
        }

        @Override
        public void handleManualTask(ManualTask task) {
            this.model = new SimulationFlowNodeImpl(task);
        }

        public SimulationFlowNodeImpl getSimulationActivity() {
            return this.model;
        }

        private void handleGateway(Gateway node) {
            this.model = node.getDirection() == GatewayDirection.DIVERGING ? new SplitSimulationActivityImpl(node) : new JoinSimulationActivityImpl(node);
        }

        private void handleAutomaticActivity(FlowNode node) {
            this.model = new SimulationFlowNodeImpl(node);
            this.model.setCapacity(100);
        }
    }

    protected static class ActivitiesToCompensate {
        private SimulationFlowNodeImpl compensate;
        private ListIterator<FlowNode> iterator;

        protected ActivitiesToCompensate(SimulationFlowNodeImpl compensate, List<FlowNode> compensables) {
            this.compensate = compensate;
            this.iterator = compensables.listIterator(compensables.size());
        }

        protected FlowNode getNextActivityToCompensate(Token token) {
            FlowNode nextCompensable = null;
            while (this.iterator.hasPrevious()) {
                FlowNode candidate = this.iterator.previous();
                if (!token.containsInTrace(candidate.getId())) continue;
                nextCompensable = candidate;
                break;
            }
            return nextCompensable;
        }

        private SimulationFlowNodeImpl getCompensate() {
            return this.compensate;
        }
    }
}

