/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.NormalDistribution;
import fuego.simulation.RealDistributionCriteriaHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;

public class RealDistribution
extends AbstractDistribution {
    private RealDistributionCriteriaHelper info;
    private List<Distribution> slots = new ArrayList<Distribution>();

    private RealDistribution(RealDistributionCriteria criteria) {
        super(DistributionType.REAL);
        this.setRealDistributionCriteria(criteria);
    }

    public static RealDistribution create() {
        return RealDistribution.create(RealDistributionCriteria.DAILY);
    }

    public static RealDistribution createEmpty() {
        return RealDistribution.createEmpty(RealDistributionCriteria.DAILY);
    }

    public static RealDistribution create(RealDistributionCriteria criteria) {
        RealDistribution realDistribution = new RealDistribution(criteria);
        realDistribution.fillDefaultSlots();
        return realDistribution;
    }

    public static RealDistribution createEmpty(RealDistributionCriteria criteria) {
        return new RealDistribution(criteria);
    }

    public void setRealDistributionCriteria(RealDistributionCriteria criteria) {
        this.info = RealDistributionCriteriaHelper.resolve(criteria);
    }

    public RealDistributionCriteria getRealDistributionCriteria() {
        return this.info.getCriteria();
    }

    @Override
    public long getAvgValue() {
        return this.info != null && this.info.size() != 0 ? this.getDistribution(0).getAvgValue() : 0L;
    }

    @Override
    public long next(Random random) {
        return this.info != null && this.info.size() != 0 ? this.getDistribution(0).next(random) : 0L;
    }

    @Override
    public long next(Random random, long currentTime) {
        int origIndex;
        int index = origIndex = this.info.getIndex(Time.valueOf(currentTime));
        Distribution distribution = this.getDistribution(index);
        index = (index + 1) % this.groupsSize();
        while (NormalDistribution.hasNoSample((NormalDistribution)distribution) && origIndex != index) {
            distribution = this.getDistribution(index);
            index = (index + 1) % this.groupsSize();
        }
        if (origIndex == index) {
            return Long.MAX_VALUE;
        }
        int steps = (index >= origIndex ? index - origIndex : this.groupsSize() - origIndex + index) - 1;
        return this.info.getTimeRange().getTotalMicroseconds() * (long)steps + distribution.next(random);
    }

    public void addDistribution(Distribution distribution) {
        this.slots.add(distribution);
    }

    public int groupsSize() {
        return this.info.size();
    }

    public Distribution getDistribution(int i) {
        return this.slots.get(i);
    }

    public List<Distribution> getDistributions() {
        return this.slots;
    }

    public void clearAllSlots() {
        this.slots.clear();
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.slots == null ? 0 : ((Object)this.slots).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealDistribution other = (RealDistribution)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        return !(this.slots == null ? other.slots != null : !((Object)this.slots).equals(other.slots));
    }

    private void fillDefaultSlots() {
        for (int i = 0; i < this.info.size(); ++i) {
            this.addDistribution(new NormalDistribution(Long.MAX_VALUE, 0L));
        }
    }
}

