/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.DistributionContainer;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.SimulationSequenceFlowImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.ModelSimulationProcess;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public class ModelSimulationImpl
extends ResourceObjectImpl
implements DistributionContainer,
ModelListener,
ModelSimulation,
ResourceObject {
    private List<Distribution> calculatedDistributions = new ArrayList<Distribution>();
    private AbstractDistribution[] distributions;
    private List<ModelListener> listeners = Collections.synchronizedList(new ArrayList());
    private int maxInstances = 200;
    private Process model;
    private String modelId;
    private String name;
    private final Map<String, SimulationFlowNode> otherActivities;
    private Path path;
    private ProjectSimulation projectSimulationModel;
    private final Map<String, SimulationFlowNode> simulationActivities;
    private final Map<String, SimulationSequenceFlow> simulationTransitions;
    private boolean useMaxInstances = false;

    public ModelSimulationImpl(@NotNull Project fuegoProject, @NotNull String modelId, @NotNull String name) {
        super(fuegoProject);
        this.modelId = modelId;
        this.name = name;
        this.path = Path.SIMULATIONS.create(name);
        this.simulationActivities = new HashMap<String, SimulationFlowNode>();
        this.simulationTransitions = new HashMap<String, SimulationSequenceFlow>();
        this.otherActivities = new HashMap<String, SimulationFlowNode>();
    }

    @Override
    public void setProjectSimulation(ProjectSimulation projectSimulationModel) {
        this.projectSimulationModel = projectSimulationModel;
    }

    @Override
    public void setDistribution(Distribution distrib) {
        this.ensureDistributions();
        AbstractDistribution oldValue = this.distributions[0];
        this.distributions[0] = (AbstractDistribution)distrib;
        this.events().objectChanged("distribution", oldValue, distrib);
    }

    public AbstractDistribution[] getDistributions() {
        this.ensureDistributions();
        return this.distributions;
    }

    @Override
    public void setMaxInstances(int maxInstances) {
        int oldValue = this.maxInstances;
        this.maxInstances = maxInstances;
        this.events().objectChanged("maxInstances", oldValue, maxInstances);
    }

    @Override
    public int getMaxInstances() {
        return this.maxInstances;
    }

    @Override
    public void setId(String id) {
        this.name = id;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public SimulationSequenceFlow findSimulationSequenceFlow(String transitionId) {
        return this.simulationTransitions.get(transitionId);
    }

    @Override
    public Collection<SimulationSequenceFlow> getSimulationSequenceFlows() {
        return Collections.unmodifiableCollection(this.simulationTransitions.values());
    }

    @Override
    public void removeSequenceFlow(SimulationSequenceFlow simulationSequenceFlow) throws ProjectException {
        String transitionId = simulationSequenceFlow.getId();
        if (!this.simulationTransitions.containsKey(transitionId)) {
            throw new ProjectException(simulationSequenceFlow, ProjectMsg.SIMULATION_TRANSITION_NOT_PRESENT);
        }
        this.events().preObjectRemoved(simulationSequenceFlow, (ProjectObject)this);
        this.simulationTransitions.remove(transitionId);
        this.events().postObjectRemoved(simulationSequenceFlow, (ProjectObject)this);
        ((SimulationSequenceFlowImpl)simulationSequenceFlow).setModelSimulation(null);
    }

    @Override
    public void setUseMaxInstances(boolean useMaxInstances) {
        if (useMaxInstances != this.useMaxInstances) {
            boolean oldValue = this.useMaxInstances;
            this.useMaxInstances = useMaxInstances;
            this.events().objectChanged("useMaxInstances", oldValue, useMaxInstances);
        }
    }

    @Override
    public boolean getUseMaxInstances() {
        return this.useMaxInstances;
    }

    @Override
    public Collection<SimulationFlowNode> getSimulationFlowNodes() {
        return this.simulationActivities.values();
    }

    @Override
    public SimulationFlowNode findSimulationFlowNode(String activityId) {
        SimulationFlowNode activity = this.simulationActivities.get(activityId);
        if (activity == null) {
            activity = this.otherActivities.get(activityId);
        }
        return activity;
    }

    @Override
    public SimulationFlowNode[] getAllBeginFlowNodes() {
        ArrayList<SimulationFlowNode> nodes = new ArrayList<SimulationFlowNode>();
        Sequence<StartEvent> events = ModelUtils.getAllStartEvents(this.getProcess());
        for (StartEvent s : events) {
            try {
                nodes.add(this.getSimulationActivity(s.getId()));
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
        return nodes.toArray(new SimulationFlowNode[nodes.size()]);
    }

    @Override
    public SimulationFlowNode getBeginFlowNode() {
        SimulationFlowNode simulationActivity = null;
        try {
            simulationActivity = this.getSimulationActivity(ModelUtils.getStartEvent(this.getProcess()).getId());
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        return simulationActivity;
    }

    @Override
    public SimulationFlowNode getAnyEndFlowNode() {
        SimulationFlowNode simulationActivity = null;
        try {
            simulationActivity = this.getSimulationActivity(ModelUtils.getAnyEndEvent(this.getProcess()).getId());
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        return simulationActivity;
    }

    @Override
    public SimulationFlowNode createSimulationFlowNode(String activityId) {
        SimulationFlowNodeImpl simulationActivity = null;
        FlowNode fuegoNode = this.getProcess().findDescendant(FlowNode.class, activityId);
        if (fuegoNode != null) {
            simulationActivity = SimulationFlowNodeImpl.create(fuegoNode, this);
        }
        return simulationActivity;
    }

    @Override
    public void addSimulationFlowNode(SimulationFlowNode simulationActivity) throws ProjectException {
        if (this.simulationActivities.containsKey(simulationActivity.getId()) || this.otherActivities.containsKey(simulationActivity.getId())) {
            throw new ProjectException(simulationActivity, ProjectMsg.SIMULATION_MODEL_HAS_ACTIVITY);
        }
        FlowNode fuegoNode = this.getProcess().findNode(simulationActivity.getId());
        if (fuegoNode != null) {
            ((SimulationFlowNodeImpl)simulationActivity).setModelSimulation(this);
            this.events().preObjectAdded(simulationActivity, (ProjectObject)this);
            this.simulationActivities.put(simulationActivity.getId(), simulationActivity);
            this.events().postObjectAdded(simulationActivity, (ProjectObject)this);
        }
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public SimulationSequenceFlow createSimulationSequenceFlow(String transitionId) {
        return new SimulationSequenceFlowImpl(this.getProject(), transitionId);
    }

    @Override
    public void addSimulationSequenceFlow(SimulationSequenceFlow simulationSequenceFlow) throws ProjectException {
        if (this.simulationTransitions.containsKey(simulationSequenceFlow.getId())) {
            throw new ProjectException(simulationSequenceFlow, ProjectMsg.SIMULATION_MODEL_HAS_TRANSITION);
        }
        this.doAddTransition((SimulationSequenceFlowImpl)simulationSequenceFlow);
    }

    @Override
    public void addCalculatedDistribution(Distribution distribution) {
        this.calculatedDistributions.add(distribution);
        this.events().objectChanged("calculatedDistribution", null, distribution);
    }

    @Override
    public void removeCalculatedDistribution(Distribution distribution) {
        if (this.calculatedDistributions.remove(distribution)) {
            this.events().objectChanged("calculatedDistribution", distribution, null);
        }
    }

    public Distribution getCalculatedDistributionForType(DistributionType distributionType) {
        for (Distribution otherDistribution : this.calculatedDistributions) {
            if (!otherDistribution.getType().equals(distributionType)) continue;
            return otherDistribution;
        }
        return null;
    }

    @Override
    public Process getProcess() {
        if (this.model == null) {
            this.model = this.getProject().findProcess(this.modelId);
        }
        return this.model;
    }

    @Override
    public void capacityChanged(ModelEvent e) {
        this.fireCapacityChanged(e);
    }

    public void createInfo() {
        Sequence<FlowNode> nodes = this.getProcess().getFlowNodes();
        for (FlowNode node : nodes) {
            if (this.findSimulationFlowNode(node.getId()) != null) continue;
            SimulationFlowNodeImpl simulationActivityImpl = SimulationFlowNodeImpl.create(node, this);
            try {
                this.addSimulationFlowNode(simulationActivityImpl);
                simulationActivityImpl.addListener(this);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        this.addTransitions(this.getProcess().getSequenceFlows());
    }

    public void addTransitions(Sequence<SequenceFlow> transitions) {
        for (SequenceFlow transition : transitions) {
            String transitionId = transition.getId();
            if (this.findSimulationSequenceFlow(transitionId) != null) continue;
            try {
                this.doAddTransition(new SimulationSequenceFlowImpl(this.getProject(), transitionId));
            }
            catch (ProjectException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void removeSimulationFlowNode(SimulationFlowNode simulationActivity) throws ProjectException {
        this.events().preObjectRemoved(simulationActivity, (ProjectObject)this);
        this.simulationActivities.remove(simulationActivity.getId());
        simulationActivity.removeListener(this);
        this.events().postObjectRemoved(simulationActivity, (ProjectObject)this);
        ((SimulationFlowNodeImpl)simulationActivity).setModelSimulation(null);
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return this.getId();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL_SIMULATION;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProcess().getProject().getSimulations().getModelSimulationsContainer().findChild(ModelSimulationProcess.class, this.model.getId());
    }

    public ProjectSimulation getCurrentProjectSimulation() {
        return this.projectSimulationModel;
    }

    @Override
    public Distribution[] getCalculatedDistributions() {
        return this.calculatedDistributions.toArray(new Distribution[this.calculatedDistributions.size()]);
    }

    @Override
    @NotNull
    public SimulationSequenceFlow asSimulationSequenceFlow(@NotNull SequenceFlow transition) {
        String transitionId = transition.getId();
        SimulationSequenceFlow result = this.findSimulationSequenceFlow(transitionId);
        if (result == null) {
            try {
                result = this.doAddTransition(new SimulationSequenceFlowImpl(this.getProject(), transitionId));
            }
            catch (ProjectException e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    private SimulationSequenceFlowImpl doAddTransition(SimulationSequenceFlowImpl simulationTransition) throws ProjectException {
        simulationTransition.setModelSimulation(this);
        this.events().preObjectAdded(simulationTransition, (ProjectObject)this);
        this.simulationTransitions.put(simulationTransition.getId(), simulationTransition);
        this.events().postObjectAdded(simulationTransition, (ProjectObject)this);
        return simulationTransition;
    }

    private SimulationFlowNode getSimulationActivity(String activityId) throws ProjectException {
        SimulationFlowNode beginSimulationActivity = this.findSimulationFlowNode(activityId);
        if (beginSimulationActivity == null) {
            beginSimulationActivity = this.createSimulationFlowNode(activityId);
            this.addSimulationFlowNode(beginSimulationActivity);
        }
        return beginSimulationActivity;
    }

    private void ensureDistributions() {
        if (this.distributions == null) {
            this.distributions = new AbstractDistribution[1];
            this.setDistribution(AbstractDistribution.create(DistributionType.NORMAL));
        }
    }

    private void fireCapacityChanged(ModelEvent e) {
        for (ModelListener listener : this.listeners) {
            listener.capacityChanged(e);
        }
    }
}

