/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.SimulationFlowNode;

public class GroupActivityInfo
extends ActivityInfo {
    static final long serialVersionUID = 6096228378693835419L;
    static final long serialCheck = -7153328620875608135L;

    protected GroupActivityInfo(ActivityInfo parent, ActivityImpl activityImpl, int capacity) {
        super(parent, activityImpl, capacity);
    }

    @Override
    public boolean queue(Token token) {
        if (!this.getInnerSimulation()) {
            return super.queue(token);
        }
        long currTime = this.getRun().getCurrentTime();
        token.setActivationTime(currTime);
        token.setArrivalTime(currTime);
        this.getRunningInfoImpl().addInstance(currTime, false);
        RunningInfo categoryInfo = this.getCategoryRunningInfo(token.getCategory());
        if (categoryInfo != null) {
            categoryInfo.addInstance(currTime, false);
        }
        return false;
    }

    @Override
    public void remove(Token token, boolean normalTransition) {
        if (!token.containsInTrace(this.getName())) {
            super.remove(token, this.getInnerSimulation());
        }
    }

    private boolean getInnerSimulation() {
        SimulationFlowNode simulationActivity = this.model.findSimulationFlowNode(this.getName());
        if (simulationActivity == null) {
            simulationActivity = this.model.createSimulationFlowNode(this.getName());
            try {
                this.model.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return ((SimulationFlowNodeImpl)simulationActivity).getInnerSimulation();
    }
}

