/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.persistence;

import java.util.Collection;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MdPersistence {
    public <T extends MdProject, K extends ProjectArtifact> T findProjectByName(@NotNull Class<T> var1, @Nullable LocalRef<K> var2, @NotNull String var3, boolean var4) throws PersistenceException;

    public <T extends MdProject, K extends ProjectArtifact> Collection<LocalRef<T>> find(@NotNull Class<T> var1, @Nullable LocalRef<K> var2, @Nullable Predicate<T> var3, boolean var4) throws PersistenceException;

    public <T extends MdProject> LocalRef<T> createMdProject(@NotNull Class<T> var1, @NotNull String var2, @NotNull MetadataType var3) throws MetadataException;

    public <T extends MdProject, K extends ProjectArtifact> MdTree browse(@NotNull Class<T> var1, @Nullable LocalRef<K> var2, @Nullable Predicate<T> var3, boolean var4) throws PersistenceException;

    public DraftProject createDraftProject(@NotNull PublicShareProject var1, @NotNull String var2) throws PersistenceException;

    public PublicShareProject createPublicShareProject(@NotNull PublicShareProject var1, @NotNull String var2, @NotNull VFileSystem var3) throws PersistenceException;

    public <T extends MdProject> boolean existsFolder(@NotNull Class<T> var1, @NotNull ProjectFolder var2) throws PersistenceException;

    public <T extends MdProject> boolean existsProject(@NotNull Class<T> var1, @NotNull ProjectFolder var2) throws PersistenceException;

    public <T extends MdProject> void createFolder(@NotNull Class<T> var1, @NotNull ProjectFolder var2) throws PersistenceException;

    public <T extends MdProject> void removeFolder(@NotNull Class<T> var1, @NotNull ProjectFolder var2, boolean var3) throws PersistenceException;

    public <T extends MdProject> void removeProject(@NotNull Class<T> var1, @NotNull ProjectFolder var2, @NotNull MetadataType var3) throws PersistenceException;

    public void commitChanges(@NotNull MetadataType var1) throws PersistenceException;

    public <T extends MdProject> MetadataType loadMetadataArtifact(@NotNull Class<T> var1, @NotNull ProjectFolder var2) throws PersistenceException;

    public <T extends MdProject> void saveMetadataArtifact(@NotNull Class<T> var1, @NotNull VFileSystem var2, @NotNull MetadataType var3) throws PersistenceException;

    public <T extends MdProject> LocalRef<T> loadMdProject(@NotNull Class<T> var1, @NotNull String var2, boolean var3) throws MetadataException;

    public LocalRef<Project> loadProject(@NotNull MetadataType var1) throws MetadataException;

    public void saveMdProject(@NotNull MdProject var1, @NotNull ProjectType var2) throws PersistenceException;

    public <T extends MdProject> MetadataType createMdProject(@NotNull Class<T> var1, @NotNull String var2, @Nullable String var3, @NotNull String var4, @NotNull Project var5, @NotNull VFileSystem var6) throws PersistenceException;

    public void prepareProjectToDeploy(@NotNull PublicShareProject var1, @NotNull String var2, @NotNull ProjectFolder var3) throws PersistenceException;

    public LockType getLock(@NotNull VFileSystem var1) throws PersistenceException;

    public void acquireLock(@NotNull VFileSystem var1, @NotNull LockType var2) throws PersistenceException;

    public void releaseLock(@NotNull PublicShareProject var1) throws PersistenceException;

    public void releaseFromCache(@NotNull MetadataType var1) throws PersistenceException;
}

