/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.utils;

import java.io.Closeable;
import java.io.IOException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.lang.Str;
import org.jetbrains.annotations.NotNull;

public class ProjectArtifactHelper {
    private static String EMPTY_COMPOSITE_TEMPLATE_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<composite name=\"%PROJECT_NAME\"\n           revision=\"1.0\"\n           label=\"2009-11-24_19-22-05_750\"\n           mode=\"active\"\n           state=\"on\"\n           xmlns=\"http://xmlns.oracle.com/sca/1.0\"\n           xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"\n           xmlns:orawsp=\"http://schemas.oracle.com/ws/2006/01/policy\"\n           xmlns:ui=\"http://xmlns.oracle.com/soa/designer/\">\n</composite>";
    private static String JDEV_PROJECT_JPR_DEPLOYMENT_PROFILE = "   <hash n=\"oracle.jdeveloper.deploy.dt.DeploymentProfiles\">\n      <hash n=\"profileDefinitions\">\n         <hash n=\"%PROJECT_NAME\">\n            <hash n=\"archiveOptions\">\n               <value n=\"hasManifest\" v=\"false\"/>\n            </hash>\n            <hash n=\"fileGroups\">\n               <list n=\"groups\">\n                  <hash>\n                     <list n=\"contributors\">\n                        <hash>\n                           <url n=\"location\" path=\".\"/>\n                           <value n=\"type\" v=\"1\"/>\n                        </hash>\n                     </list>\n                     <value n=\"displayName\" v=\"SOA Files\"/>\n                     <hash n=\"filters\">\n                        <list n=\"rules\">\n                           <hash>\n                              <value n=\"pattern\" v=\".migrated/jaxb_classes\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".rulesdesigner/jaxb_classes\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"merged\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"mdssys\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".designer\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"SCA-INF/classes/scac.log\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"SCA-INF/classes/scac_out.xml\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"*.jpr\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"deploy/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"WEB-INF/temp/**\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"WEB-INF/classes/jsp_servlet/**\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".wlsjsps/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".wlLibs/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/.svn/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/CVS/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/.ade_path\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/.data/**\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**.cdi\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**.contrib\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**.keep\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**.rvi\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".jsps/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".tags/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\".dtags/\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/*.jht\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/*.jjt\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**/*.jxt\"/>\n                              <value n=\"type\" v=\"1\"/>\n                           </hash>\n                           <hash>\n                              <value n=\"pattern\" v=\"**\"/>\n                           </hash>\n                        </list>\n                     </hash>\n                     <value n=\"internalName\" v=\"sar-files\"/>\n                     <value n=\"type\" v=\"1\"/>\n                  </hash>\n               </list>\n            </hash>\n            <url n=\"jarURL\" path=\"deploy/sca_%PROJECT_NAME${composite.revision_id}.jar\"/>\n            <hash n=\"libraryDependencies\">\n               <value n=\"IncludeLibrariesFromOtherContainers\" v=\"true\"/>\n            </hash>\n            <value n=\"profileClass\" v=\"oracle.tip.tools.ide.fabric.deploy.sar.SarProfile\"/>\n            <value n=\"profileName\" v=\"%PROJECT_NAME\"/>\n         </hash>\n      </hash>\n      <list n=\"profileList\">\n         <string v=\"%PROJECT_NAME\"/>\n      </list>\n   </hash>";
    private static String JDEV_PROJECT_JPR_TEMPLATE = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<jpr:project xmlns:jpr=\"http://xmlns.oracle.com/ide/project\">\n   <hash n=\"component-versions\">\n      <value n=\"oracle.adfdt.controller.adfc.source.migration.AdfControllerSchemaMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdt.controller.common.migrator.ProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdt.controller.jsf2.diagram.migrate.JsfNodeMigratorHelper\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdt.controller.struts.addin.db.ADFStrutsProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdt.controller.struts.addin.StrutsProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdtinternal.dvt.datapresdt.migration.DVTDataMapMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdtinternal.model.ide.migration.ProjectMigrator\" v=\"11.1.1.1.0.11.1.1\"/>\n      <value n=\"oracle.adfdtinternal.model.ide.security.wizard.FormPageMigrator\" v=\"11.1.1.0.0\"/>\n      <value n=\"oracle.adfdtinternal.model.ide.security.wizard.JpsFilterMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdtinternal.model.ide.xmled.migration.ADFNodeMigrator\" v=\"11.1.1.1.0.5\"/>\n      <value n=\"oracle.adfdtinternal.model.ide.xmled.migration.PageDefinitionParameterValueMigrator\" v=\"11.1.1.1.0.5\"/>\n      <value n=\"oracle.adfdtinternal.model.ide.xmled.migration.WebXmlMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdtinternal.view.common.migration.wizards.MigrationHelper\" v=\"11.1.1.1.0.3\"/>\n      <value n=\"oracle.adfdtinternal.view.rich.binding.migration.JarResourceMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.adfdtinternal.view.rich.migration.ComponentIdNodeMigratorHelper\" v=\"11.1.1.1.0.01\"/>\n      <value n=\"oracle.adfdtinternal.view.rich.migration.LibraryVersionMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.bm.commonIde.ProjectUpgrader\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.bm.migration.project.MigratorRegistryProjectUpgradeAdapter\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.ide.model.Project\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.ide.model.ResourcePathsMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jbo.dt.jclient.migrator.JCProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jbo.dt.jdevx.deployment.JbdProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jbo.dt.jdevx.ui.appnav.APProjectMigrator\" v=\"11.1.1.0.1.5\"/>\n      <value n=\"oracle.jbo.dt.migrate.ResourceBundlePathMigrator\" v=\"11.1.1.1.0.5\"/>\n      <value n=\"oracle.jbo.dt.migration.ServiceInterfaceMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdeveloper.ejb.EjbMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdeveloper.library.ProjectLibraryMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdeveloper.model.OutputDirectoryMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.deploy.DeploymentProfilesMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.deploy.jps.JpsDataMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.jsp.JspMigrator\" v=\"11.1.1\"/>\n      <value n=\"oracle.jdevimpl.offlinedb.migration.OfflineDBProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.offlinedb.migration.OfflineTransferMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.resourcebundle.XliffAddin$XliffMigratorHelper\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.webapp.jsp.libraries.JspLibraryMigrator\" v=\"11.1.1.1.4\"/>\n      <value n=\"oracle.jdevimpl.webapp.WebAppContentSetNodeMigratorHelper\" v=\"11.1.1\"/>\n      <value n=\"oracle.jdevimpl.webapp.WebAppNodeMigratorHelper\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.webservices.WebServicesMigratorHelper\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.jdevimpl.xml.wl.WeblogicMigratorHelper\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.modeler.bmmigrate.management.Migration\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.tip.tools.ide.fabric.addin.SCAProjectMigrator\" v=\"11.1.1.1.0.06\"/>\n      <value n=\"oracle.tip.tools.ide.pm.addin.migrator.PMProjectMigrator\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.tip.tools.ide.workflow.addin.TaskFormMigratorAddin\" v=\"11.1.1.1.0\"/>\n      <value n=\"oracle.tip.tools.ide.workflow.addin.WorkflowProjectMigrator\" v=\"11.1.1.1.0.08\"/>\n      <value n=\"oracle.toplink.workbench.addin.migration.PersistenceProjectMigrator\" v=\"11.1.1.1.1\"/>\n      <value n=\"oracle.toplink.workbench.addin.migration.TopLinkProjectMigrator\" v=\"11.1.1.1.0\"/>\n   </hash>\n   <list n=\"contentSets\">\n      <string v=\"oracle.jdeveloper.model.PathsConfiguration/javaContentSet\"/>\n      <string v=\"oracle.ide.model.ResourcePaths/resourcesContentSet\"/>\n      <string v=\"oracle.jdeveloper.offlinedb.model.OfflineDBProjectSettings/offlineDBContentSet\"/>\n      <string v=\"oracle.jdeveloper.model.J2eeSettings/webContentSet\"/>\n      <string v=\"oracle.mds.internal.dt.ide.MDSLibraryCustCSProvider/mdsContentSet\"/>\n      <string v=\"oracle.bm.commonIde.data.project.ModelerProjectSettings/modelersContentSet\"/>\n      <string v=\"oracle.adfdtinternal.model.ide.settings.ADFMSettings/adfmContentSet\"/>\n      <string v=\"oracle.tip.tools.ide.fabric.addin.SCAContentSetProvider/sca-content\"/>\n      <string v=\"oracle.bpm.fusion.repository.BPMProjectSettings/bpmProjectsProcessesContentSet\"/>\n      <string v=\"oracle.bpm.fusion.repository.BPMProjectSettings/bpmProjectsOrganizationContentSet\"/>\n      <string v=\"oracle.toplink.workbench.addin/toplinkContentSet\"/>\n   </list>\n   <value n=\"defaultPackage\" v=\"%PROJECT_NAME\"/>\n   <hash n=\"oracle.ide.model.ResourcePaths\">\n      <hash n=\"resourcesContentSet\">\n         <list n=\"url-path\"/>\n      </hash>\n   </hash>\n   <hash n=\"oracle.ide.model.TechnologyScopeConfiguration\">\n      <list n=\"technologyScope\">\n         <string v=\"SOA\"/>\n         <string v=\"BPM\"/>\n      </list>\n   </hash>\n" + JDEV_PROJECT_JPR_DEPLOYMENT_PROFILE + "   <hash n=\"oracle.tip.tools.ide.fabric.addin.SCAContentSetProvider\">\n" + "      <hash n=\"sca-content\">\n" + "         <list n=\"url-path\">\n" + "            <url path=\".\"/>\n" + "         </list>\n" + "      </hash>\n" + "   </hash>\n" + "</jpr:project>";

    public static void writeEmptyComposite(@NotNull VFile compositeFile, @NotNull String projectName) throws IOException {
        if (compositeFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.writeEmptyComposite must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.writeEmptyComposite must not be null");
        }
        String content = Str.replace((String)EMPTY_COMPOSITE_TEMPLATE_CONTENT, (String)"%PROJECT_NAME", (String)projectName);
        ProjectArtifactHelper.saveVFile(compositeFile, content);
    }

    public static void writeBaseProjectJpr(@NotNull VFile projectJrp, @NotNull String projectName) throws IOException {
        if (projectJrp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.writeBaseProjectJpr must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.writeBaseProjectJpr must not be null");
        }
        String content = Str.replace((String)JDEV_PROJECT_JPR_TEMPLATE, (String)"%PROJECT_NAME", (String)projectName);
        ProjectArtifactHelper.saveVFile(projectJrp, content);
    }

    public static void writeProjectJpr(@NotNull VFile oldProjectJpr, @NotNull VFile newProjectJpr) throws IOException {
        if (oldProjectJpr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.writeProjectJpr must not be null");
        }
        if (newProjectJpr == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.writeProjectJpr must not be null");
        }
        String name = VFileUtils.getName((VFile)oldProjectJpr);
        String replacement = VFileUtils.getName((VFile)newProjectJpr);
        VFileUtils.Filter filter = VFileUtils.Filter.Factory.replaceAll((String)name, (String)replacement);
        VFileUtils.copyFileFiltering((VFile)oldProjectJpr, (VFile)newProjectJpr, (VFileUtils.Filter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVFile(@NotNull VFile compositeFile, @NotNull String content) throws IOException {
        if (compositeFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.saveVFile must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/ProjectArtifactHelper.saveVFile must not be null");
        }
        VFileOutputStream out = null;
        try {
            out = new VFileOutputStream(compositeFile);
            out.write(content.getBytes());
        }
        catch (Throwable throwable) {
            StreamUtils.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        StreamUtils.close((Closeable[])new Closeable[]{out});
    }
}

