/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.mds.utils.MdsUtils;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.InvalidNamespaceException;
import oracle.mds.query.Condition;
import oracle.mds.query.ConditionFactory;
import oracle.mds.query.DocumentQuery;
import oracle.mds.query.DocumentResult;
import oracle.mds.query.Query;
import oracle.mds.query.QueryFactory;
import oracle.mds.query.QueryResult;
import oracle.mds.query.ResourceQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MdQueryHelper {
    private static final String MATCH_ALL_WILDCARD = "%";

    MdQueryHelper() {
    }

    public static <T extends MdProject, K extends ProjectArtifact> Collection<QueryResult> findResources(@NotNull MDSInstance mdsInstance, @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, @Nullable FindFilter filter, boolean includeFolders, boolean stopOnFirstFound) throws PersistenceException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findResources must not be null");
        }
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findResources must not be null");
        }
        ResourceQuery resourceQuery = null;
        ArrayList<QueryResult> result = new ArrayList<QueryResult>();
        try {
            String location = MdQueryHelper.resolveLocation(mdType, parent);
            Condition nameCondition = MdQueryHelper.createProjectMetadataCondition(includeFolders, location);
            resourceQuery = QueryFactory.createResourceQuery((MDSInstance)mdsInstance, (Condition)nameCondition);
            MdQueryHelper.processQueryResult(filter, stopOnFirstFound, (Query)resourceQuery, result);
        }
        catch (InvalidNamespaceException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                MdsUtils.closeQuery(resourceQuery);
                throw throwable;
            }
        }
        MdsUtils.closeQuery((Query)resourceQuery);
        return result;
    }

    public static <T extends MdProject, K extends ProjectArtifact> Collection<DocumentResult> findMdProject(@NotNull MDSInstance mdsInstance, @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, @Nullable FindFilter filter, boolean includeFolders, boolean stopOnFirstFound) throws PersistenceException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findMdProject must not be null");
        }
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findMdProject must not be null");
        }
        DocumentQuery resourceQuery = null;
        ArrayList<DocumentResult> result = new ArrayList<DocumentResult>();
        try {
            String location = MdQueryHelper.resolveLocation(mdType, parent);
            Condition nameCondition = MdQueryHelper.createProjectMetadataCondition(includeFolders, location);
            resourceQuery = QueryFactory.createDocumentQuery((MDSInstance)mdsInstance, (Condition)nameCondition);
            MdQueryHelper.processQueryResult(filter, stopOnFirstFound, (Query)resourceQuery, result);
        }
        catch (InvalidNamespaceException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                MdsUtils.closeQuery(resourceQuery);
                throw throwable;
            }
        }
        MdsUtils.closeQuery((Query)resourceQuery);
        return result;
    }

    private static <T extends QueryResult> void processQueryResult(@Nullable FindFilter<T> filter, boolean stopOnFirstFound, @NotNull Query resourceQuery, @NotNull Collection<T> result) throws PersistenceException {
        if (resourceQuery == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.processQueryResult must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.processQueryResult must not be null");
        }
        Iterator queryResultIterator = resourceQuery.execute();
        while (queryResultIterator.hasNext()) {
            QueryResult document = (QueryResult)queryResultIterator.next();
            if (filter != null && !filter.accept(document)) continue;
            result.add(document);
            if (!stopOnFirstFound) continue;
            break;
        }
    }

    private static <T extends MdProject, K extends ProjectArtifact> String resolveLocation(@NotNull Class<T> mdType, @Nullable LocalRef<K> parent) throws InvalidNamespaceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.resolveLocation must not be null");
        }
        String location = MetadataArtifactHelper.getRelativePathFrom(MetadataArtifactHelper.getProjectType(mdType));
        if (parent != null) {
            ProjectArtifact projectArtifact = (ProjectArtifact)parent.get();
            if (projectArtifact instanceof ProjectFolder) {
                String parentLocation = ((ProjectFolder)projectArtifact).getLocation();
                if (!location.endsWith("/") && !parentLocation.startsWith("/")) {
                    location = location + "/";
                }
                location = location + parentLocation;
            } else {
                LocalRef<ProjectFolder> folderRef = projectArtifact.getParentFolder();
                ProjectFolder folder = folderRef.get();
                location = folder.getLocation();
            }
        }
        return location;
    }

    private static Condition createProjectMetadataCondition(boolean includeFolders, String location) {
        String matchExpression = "%projectMetadata.xml";
        return ConditionFactory.createNameCondition((String)location, (String)"%projectMetadata.xml", (boolean)includeFolders);
    }

    public static interface FindFilter<T extends QueryResult> {
        public boolean accept(@NotNull T var1) throws PersistenceException;
    }
}

