/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.metadata.mds.utils.MdsUtils;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.core.MDSInstance;
import oracle.mds.core.MDSObject;
import oracle.mds.core.MDSSession;
import oracle.mds.core.MetadataObject;
import oracle.mds.core.StreamedObject;
import oracle.mds.persistence.PPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public final class MdsTransaction {
    private int activesSessions = 0;
    private boolean autocommit = true;
    private MDSSession currentMDSSession;
    private boolean isCommited = false;
    private boolean isRollback = false;
    private MDSInstance mdsInstance;
    private List<CommitTransactionAction> transactionActionsList = new ArrayList<CommitTransactionAction>();

    public MdsTransaction(@Nullable MDSInstance mdsInstance) {
        this(mdsInstance, true);
    }

    public MdsTransaction(@Nullable MDSInstance mdsInstance, boolean autocommit) {
        this.autocommit = autocommit;
        this.mdsInstance = mdsInstance != null ? mdsInstance : MdsInstanceInitializer.getCurrentMDSInstance();
    }

    public void addTransactionAction(@NotNull CommitTransactionAction transactionActions) {
        if (transactionActions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.addTransactionAction must not be null");
        }
        this.transactionActionsList.add(transactionActions);
    }

    public void begin() {
        if (this.isAutoCommit() || this.currentMDSSession == null) {
            this.currentMDSSession = this.mdsInstance.createSession(null, null);
        }
        this.isRollback = false;
        this.isCommited = false;
        ++this.activesSessions;
    }

    public void setAutoCommit(boolean autocommit) {
        boolean change = this.autocommit != autocommit;
        this.autocommit = autocommit;
        if (change && autocommit) {
            try {
                this.commit();
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
        }
    }

    public boolean isAutoCommit() {
        return this.autocommit;
    }

    public boolean isOpen() {
        return !this.isRollback() && !this.isCommited();
    }

    public void commit() throws PersistenceException {
        if (this.isRollback) {
            throw PersistenceException.createTxRollbackedException();
        }
        if (this.activesSessions == 0) {
            throw PersistenceException.createNoActiveTransactionException();
        }
        if (this.isAutoCommit() || this.activesSessions - 1 <= 0) {
            ArrayList<CommitTransactionAction> commitTransactionActions = new ArrayList<CommitTransactionAction>(this.transactionActionsList);
            this.activesSessions = 0;
            this.transactionActionsList.clear();
            for (CommitTransactionAction commitTransactionAction : commitTransactionActions) {
                commitTransactionAction.preCommit();
            }
            MdsUtils.flushSession(this.currentMDSSession);
            for (CommitTransactionAction commitTransactionAction : commitTransactionActions) {
                commitTransactionAction.postCommit();
            }
            this.currentMDSSession = null;
            this.isCommited = true;
            this.isRollback = false;
        } else {
            --this.activesSessions;
        }
    }

    public void rollback() throws PersistenceException {
        if (this.isAutoCommit() || --this.activesSessions <= 0) {
            if (this.currentMDSSession != null) {
                this.currentMDSSession.cancelChanges();
            }
            this.isRollback = true;
            this.isCommited = false;
            this.releaseSession();
        }
    }

    public PPackage getPackage(@NotNull String resourceLocation) throws PersistenceException {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.getPackage must not be null");
        }
        this.begin();
        PPackage pck = MdsUtils.getPackage(this.currentMDSSession, resourceLocation);
        this.commit();
        return pck;
    }

    public InputStream openInputStream(@NotNull String resourceLocation) throws PersistenceException {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.openInputStream must not be null");
        }
        try {
            this.begin();
            InputStream inputStream = MdsUtils.openInputStream(this.currentMDSSession, resourceLocation);
            this.commit();
            return new BufferedInputStream(inputStream);
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
    }

    public boolean existsResource(@NotNull String location) throws PersistenceException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.existsResource must not be null");
        }
        this.begin();
        boolean exists = MdsUtils.existsResource(this.currentMDSSession, location);
        this.commit();
        return exists;
    }

    public MDSObject getMutableMDSObject(@NotNull String resourceLocation) throws PersistenceException {
        MDSObject metadataObject;
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.getMutableMDSObject must not be null");
        }
        try {
            this.begin();
            metadataObject = MdsUtils.getMutableMDSObject(this.currentMDSSession, resourceLocation);
            this.commit();
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
        return metadataObject;
    }

    public MetadataObject createDocument(@NotNull String documentLocation, @NotNull Document document) throws PersistenceException {
        MetadataObject metadataObject;
        if (documentLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.createDocument must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.createDocument must not be null");
        }
        try {
            this.begin();
            metadataObject = MdsUtils.createDocument(this.currentMDSSession, documentLocation, document);
            this.commit();
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
        return metadataObject;
    }

    public StreamedObject createStreamedObject(@NotNull String resourceLocation, @NotNull InputStream inputStream) throws PersistenceException {
        StreamedObject streamedObject;
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.createStreamedObject must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.createStreamedObject must not be null");
        }
        try {
            this.begin();
            streamedObject = MdsUtils.createStreamedObject(this.currentMDSSession, resourceLocation, inputStream);
            this.commit();
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
        return streamedObject;
    }

    public void createPackage(@NotNull String path) throws PersistenceException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.createPackage must not be null");
        }
        try {
            this.begin();
            MdsUtils.createPackage(this.currentMDSSession, path);
            this.commit();
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
    }

    public boolean deletePackage(@NotNull String path, boolean recursive) throws PersistenceException {
        boolean wasDeleted;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.deletePackage must not be null");
        }
        try {
            this.begin();
            wasDeleted = MdsUtils.deletePackage(this.currentMDSSession, path, recursive);
            this.commit();
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
        return wasDeleted;
    }

    public boolean deleteDocument(@NotNull String documentName) throws PersistenceException {
        boolean wasDeleted;
        if (documentName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.deleteDocument must not be null");
        }
        try {
            this.begin();
            wasDeleted = MdsUtils.deleteDocument(this.currentMDSSession, documentName);
            this.commit();
        }
        catch (PersistenceException e) {
            this.rollback();
            throw e;
        }
        return wasDeleted;
    }

    public boolean existsPackage(@NotNull String canonicalPath) throws PersistenceException {
        if (canonicalPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsTransaction.existsPackage must not be null");
        }
        this.begin();
        boolean exists = MdsUtils.existsPackage(this.currentMDSSession, canonicalPath);
        this.commit();
        return exists;
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    public boolean isCommited() {
        return this.isCommited;
    }

    private void releaseSession() {
        this.currentMDSSession = null;
        this.activesSessions = 0;
        this.transactionActionsList.clear();
    }

    public static interface CommitTransactionAction {
        public void postCommit();

        public void preCommit();
    }
}

