/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.bpm.metadata.mds.Namespace;
import oracle.mds.config.ContentConfig;
import oracle.mds.config.ContentOptions;
import oracle.mds.config.ContentOptionsMapping;
import oracle.mds.config.MDSConfig;
import oracle.mds.config.NamespaceConfig;
import oracle.mds.config.PConfig;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import oracle.mds.persistence.MetadataStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdsInstanceInitializer {
    private static final String OBPM_MDS = "obpm";
    public static final String SOA_INFRA_MDS = "SOAINFRA_MDS";

    public static MDSInstance getMDSInstance(@NotNull URL configFile) throws MDSException, MalformedURLException {
        if (configFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        return MdsInstanceInitializer.getMDSInstance(OBPM_MDS, configFile);
    }

    public static MDSInstance getMDSInstance(@NotNull String instanceName, @NotNull URL urlConfigFile) throws MDSException {
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        if (urlConfigFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        MDSConfig mdsConfig = new MDSConfig(urlConfigFile);
        return MDSInstance.getOrCreateInstance((String)instanceName, (MDSConfig)mdsConfig);
    }

    public static MDSInstance getMDSInstance(@Nullable String instanceName, @NotNull MetadataStore store) throws MDSException {
        if (store == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        if (instanceName == null) {
            instanceName = OBPM_MDS;
        }
        ContentOptionsMapping[] contentOptionsMap = new ContentOptionsMapping[]{new ContentOptionsMapping(Namespace.BPM.getMdsNamespace().getPath() + "/", null, new ContentOptions(true))};
        NamespaceConfig[] namespaceConfig = new NamespaceConfig[]{new NamespaceConfig(oracle.mds.naming.Namespace.create((String)"/"), store)};
        ContentConfig contentConfig = new ContentConfig(contentOptionsMap);
        PConfig pConfig = new PConfig(namespaceConfig, contentConfig, false, Integer.valueOf(0), Integer.valueOf(0));
        MDSConfig mdsConfig = new MDSConfig(null, pConfig, null);
        return MDSInstance.getOrCreateInstance((String)instanceName, (MDSConfig)mdsConfig);
    }

    public static MDSInstance getCurrentMDSInstance() {
        return MDSInstance.getInstance((String)OBPM_MDS);
    }
}

