/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectToDeploy;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.DeployedProjectExt;
import oracle.bpm.metadata.impl.DraftProjectImpl;
import oracle.bpm.metadata.impl.ProjectToDeployExt;
import oracle.bpm.metadata.impl.PublicShareProjectExt;
import oracle.bpm.metadata.impl.TemplateProjectExt;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import org.jetbrains.annotations.NotNull;

public final class ProjectArtifactFactory {
    private ProjectArtifactFactory() {
    }

    public static <T extends MdProject> T create(@NotNull Class<T> type, @NotNull MetadataType metadata, @NotNull MdPersistence persistence) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/ProjectArtifactFactory.create must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/ProjectArtifactFactory.create must not be null");
        }
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/ProjectArtifactFactory.create must not be null");
        }
        MdProject<DraftProject> result = null;
        try {
            if (type.isAssignableFrom(DraftProject.class)) {
                result = DraftProjectImpl.create(persistence, metadata);
            } else if (type.isAssignableFrom(PublicShareProject.class)) {
                result = PublicShareProjectExt.create(persistence, metadata);
            } else if (type.isAssignableFrom(ProjectToDeploy.class)) {
                result = ProjectToDeployExt.create(persistence, metadata);
            } else if (type.isAssignableFrom(DeployedProject.class)) {
                result = DeployedProjectExt.create(persistence, metadata);
            } else if (type.isAssignableFrom(TemplateProject.class)) {
                result = TemplateProjectExt.create(persistence, metadata);
            }
        }
        catch (MetadataException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        return (T)((MdProject)Cast.forceTo((Object)result));
    }
}

