/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.MdsProjectWriter;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.artifact.jaxb.Topology;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.impl.MetadataArtifactBuilder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.impl.TemplateProjectExt;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.bpm.metadata.mds.Namespace;
import oracle.bpm.metadata.mds.persistence.MdsMdPersistence;
import oracle.bpm.metadata.mds.utils.MdsTransactionUtil;
import oracle.bpm.metadata.mock.persistence.MockMdPersistence;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.InvalidNamespaceException;
import oracle.mds.exception.MDSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdDomainImpl
implements MdDomain {
    private MdPersistence mdPersistence;
    private MDSInstance mdsInstance;
    private static final DatatypeFactory datatypeFactory;
    public static final String METADATA_MOCK_WORKSPACEDIR = "metadata.mock.workspacedir";

    public MdDomainImpl() throws MetadataException {
        this.init(null);
    }

    public MdDomainImpl(@NotNull URL resource) throws MetadataException {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        this.init(resource);
    }

    public MdDomainImpl(@NotNull MDSInstance instance) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        this.mdsInstance = instance;
        try {
            String userMock = System.getProperty(METADATA_MOCK_WORKSPACEDIR);
            this.mdPersistence = userMock != null ? new MockMdPersistence() : new MdsMdPersistence(instance);
        }
        catch (InvalidNamespaceException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> MdTree browseProject(@NotNull Class<T> type, @Nullable Predicate<T> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.browseProject must not be null");
        }
        return this.mdPersistence.browse(type, parent, predicate, true);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> clazz, @NotNull String projectLocation, boolean reload) throws MetadataException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadProject must not be null");
        }
        return this.mdPersistence.loadMdProject(clazz, projectLocation, reload);
    }

    @Override
    public <T extends MdProject> boolean existsProject(@NotNull Class<T> type, @NotNull ProjectFolder location) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.existsProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.existsProject must not be null");
        }
        return this.mdPersistence.existsProject(type, location);
    }

    @Override
    public LocalRef<DraftProject> loadDraftProject(@NotNull String projectLocation, @NotNull String username) throws MetadataException {
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadDraftProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadDraftProject must not be null");
        }
        String draftLocation = projectLocation + "/" + username;
        return this.mdPersistence.loadMdProject(DraftProject.class, draftLocation, false);
    }

    @Override
    public void removePublicShare(@NotNull ProjectFolder folder) throws MetadataException {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removePublicShare must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            LocalRef<ProjectFolder> folderRef = new LocalRef<ProjectFolder>(folder.getName(), folder);
            Collection<LocalRef<DraftProject>> refCollection = this.mdPersistence.find(DraftProject.class, folderRef, null, true);
            if (!refCollection.isEmpty()) {
                for (LocalRef<DraftProject> draftProjectLocalRef : refCollection) {
                    DraftProject project = draftProjectLocalRef.get();
                    ProjectFolder draftFolder = project.getFolder().get();
                    this.removeDraft(draftFolder.getLocation());
                }
            }
            this.removeProject(PublicShareProject.class, folder);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject> void removeProject(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeProject must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeProject must not be null");
        }
        if (!this.mdPersistence.existsFolder(type, folder)) {
            throw new MetadataException(MetadataMsg.FOLDER_NOT_EXISTS(folder.getLocation()));
        }
        MetadataType metadata = this.mdPersistence.loadMetadataArtifact(type, folder);
        if (metadata == null) {
            throw MetadataExceptionFactory.createProjectNotFound(folder.getLocation());
        }
        this.mdPersistence.removeProject(type, folder, metadata);
    }

    @Override
    public void updateTemplateProject(@NotNull TemplateProject templateProject) throws MetadataException {
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updateTemplateProject must not be null");
        }
        if (templateProject.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            if (!this.existsProject(TemplateProject.class, templateProject.getFolder().get())) {
                ProjectFolder projectFolder = templateProject.getParentFolder().get();
                throw MetadataExceptionFactory.createProjectNotFound(projectFolder.getLocation());
            }
            this.mdPersistence.saveMdProject(templateProject, ProjectType.TEMPLATE);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public TemplateProject createTemplateProject(@NotNull ProjectFolder location, @NotNull TemplateProject mdTemplateProject, boolean overwrite, boolean checkVersion) throws MetadataException {
        TemplateProject result;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createTemplateProject must not be null");
        }
        if (mdTemplateProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createTemplateProject must not be null");
        }
        if (mdTemplateProject.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        String projectName = mdTemplateProject.getName();
        String relativeProjectLocation = location.getLocation() + "/" + projectName;
        ProjectFolder projectFolder = ProjectFolder.create(relativeProjectLocation);
        mdTemplateProject.setFolder(projectFolder);
        ProjectFolder foundFolder = this.findProjectByName(TemplateProject.class, projectName);
        if (foundFolder != null && !foundFolder.equals(projectFolder)) {
            throw PersistenceException.createArtifactLocationMismatchException(projectName);
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            MdsFileSystem targetFs;
            tx.begin();
            Project sourceProject = mdTemplateProject.getProject().get();
            String absoluteLocation = this.getAbsoluteLocation(TemplateProject.class, location, mdTemplateProject.getName());
            if (foundFolder != null) {
                if (!overwrite) {
                    throw new MetadataException(MetadataMsg.PROJECT_ALREADY_EXISTS(mdTemplateProject.getName(), location.getLocation()));
                }
                TemplateProject loadedTemplate = this.loadProject(TemplateProject.class, projectFolder.getLocation(), false).get();
                Project loadedProject = loadedTemplate.getProject().get();
                VFileSystem loadedFilesystem = loadedProject.getLoader().getProjectFileSystem().getDataFileSystem();
                targetFs = loadedFilesystem;
                ProjectLoader loader = sourceProject.getLoader();
                assert (loader != null);
                VFileSystem sourceFilesystem = loader.getProjectFileSystem().getDataFileSystem();
                if (!loadedFilesystem.equals(sourceFilesystem)) {
                    if (checkVersion) {
                        this.checkTimestamp(loadedTemplate.getMetadata(), mdTemplateProject.getMetadata());
                    }
                    this.removeProject(loadedFilesystem);
                }
            } else {
                targetFs = new MdsFileSystem(this.mdsInstance, absoluteLocation);
            }
            boolean oldValue = sourceProject.getPreferences().isTemplate();
            sourceProject.getPreferences().setTemplate(true);
            String templateDescription = mdTemplateProject.getDescription();
            MetadataType metadataType = this.mdPersistence.createMdProject(TemplateProject.class, projectName, templateDescription, absoluteLocation, sourceProject, targetFs);
            sourceProject.getPreferences().setTemplate(oldValue);
            result = TemplateProjectExt.create(this.mdPersistence, metadataType);
            targetFs.flush();
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (InvalidNamespaceException e) {
            tx.rollback();
            throw PersistenceException.createInvalidPathException(location.getLocation(), e);
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return result;
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.prepareProjectToDeploy must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectFolder folder = ProjectFolder.create(publicShare.getName() + "/" + workflowTicket);
            this.mdPersistence.prepareProjectToDeploy(publicShare, workflowTicket, folder);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void updateDraft(@NotNull DraftProject draftProject) throws MetadataException {
        if (draftProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updateDraft must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            if (!this.existsProject(DraftProject.class, draftProject.getFolder().get())) {
                ProjectFolder projectFolder = draftProject.getParentFolder().get();
                throw MetadataExceptionFactory.createProjectNotFound(projectFolder.getLocation());
            }
            this.mdPersistence.saveMdProject(draftProject, ProjectType.DRAFT);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void updatePublicShare(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updatePublicShare must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectFolder folder = publicShare.getFolder().get();
            if (!this.existsProject(PublicShareProject.class, folder)) {
                throw MetadataExceptionFactory.createProjectNotFound(folder.getLocation());
            }
            this.mdPersistence.saveMdProject(publicShare, ProjectType.PUBLIC_SHARED);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public PublicShareProject createPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject mdPublicShare, boolean overwrite, boolean checkVersion) throws MetadataException {
        PublicShareProject result;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (mdPublicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (mdPublicShare.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        Project sourceProject = mdPublicShare.getProject().get();
        if (sourceProject.getLoader() == null || sourceProject.getLoader().getProjectFileSystem() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        String projectName = mdPublicShare.getName();
        String relativeProjectLocation = location.getLocation() + "/" + projectName;
        ProjectFolder projectFolder = ProjectFolder.create(relativeProjectLocation);
        ProjectFolder foundFolder = this.findProjectByName(PublicShareProject.class, projectName);
        if (foundFolder != null && !foundFolder.equals(projectFolder)) {
            throw PersistenceException.createArtifactLocationMismatchException(projectName);
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            MdsFileSystem targetFs;
            tx.begin();
            String absoluteLocation = this.getAbsoluteLocation(PublicShareProject.class, location, mdPublicShare.getName());
            if (foundFolder == null) {
                targetFs = new MdsFileSystem(this.mdsInstance, absoluteLocation);
            } else {
                if (!overwrite) {
                    throw new MetadataException(MetadataMsg.PUBLIC_SHARE_PROJECT_ALREADY_EXISTS(projectName, location.getLocation()));
                }
                VFileSystem sourceFilesystem = sourceProject.getLoader().getProjectFileSystem().getDataFileSystem();
                PublicShareProject loadedShare = this.loadProject(PublicShareProject.class, projectFolder.getLocation(), false).get();
                Project loadedProject = loadedShare.getProject().get();
                VFileSystem loadedFilesystem = loadedProject.getLoader().getProjectFileSystem().getDataFileSystem();
                targetFs = loadedFilesystem;
                if (!loadedFilesystem.equals(sourceFilesystem)) {
                    if (checkVersion) {
                        this.checkTimestamp(loadedShare.getMetadata(), mdPublicShare.getMetadata());
                    }
                    this.removeProject(loadedFilesystem);
                }
            }
            result = this.mdPersistence.createPublicShareProject(mdPublicShare, absoluteLocation, targetFs);
            this.setHumanTaskNamespaceSuffix(targetFs);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (InvalidNamespaceException e) {
            tx.rollback();
            throw PersistenceException.createInvalidPathException(location.getLocation(), e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (JAXBException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return result;
    }

    @Override
    public PublicShareProject createPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, @NotNull TemplateProject templateProject, boolean overwrite, boolean checkVersion) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (templateProject.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        if (!this.existsProject(TemplateProject.class, templateProject.getFolder().get())) {
            throw MetadataExceptionFactory.createProjectNotFound(templateProject.getParentFolder().get().getLocation());
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        PublicShareProject result = null;
        try {
            tx.begin();
            String publicShareName = publicShareProject.getName();
            Project template = templateProject.getProject().get();
            PublicShareProject ps = new PublicShareProject(publicShareName, template);
            MetadataArtifactHelper.copyPublicShare(ps, publicShareProject);
            result = this.createPublicShare(location, ps, overwrite, checkVersion);
            tx.commit();
            Project project = result.getProject().get();
            ProjectPreferences preferences = project.getPreferences();
            preferences.setTemplate(false);
            MdsProjectWriter writer = (MdsProjectWriter)project.getWriter();
            writer.write(new ProjectObject[]{preferences});
            writer.flushChanges();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (ProjectException e) {
            tx.rollback();
            throw new MetadataException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return result;
    }

    @Override
    public boolean isPublicShareUpToDate(@NotNull ProjectFolder folder, @NotNull PublicShareProject publicShareProject) throws MetadataException {
        boolean result;
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.isPublicShareUpToDate must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.isPublicShareUpToDate must not be null");
        }
        String projectName = publicShareProject.getName();
        String relativeProjectLocation = folder.getLocation() + "/" + projectName;
        ProjectFolder projectFolder = ProjectFolder.create(relativeProjectLocation);
        try {
            MetadataType metadata = this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, projectFolder);
            try {
                result = true;
                this.checkTimestamp(metadata, publicShareProject.getMetadata());
            }
            catch (MetadataException e) {
                result = false;
            }
        }
        catch (MetadataException e) {
            throw MetadataExceptionFactory.createProjectNotFound(folder.getLocation());
        }
        return result;
    }

    @Override
    public DraftProject createDraftProject(@NotNull PublicShareProject publicShareProject, @NotNull String username) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createDraftProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createDraftProject must not be null");
        }
        String location = publicShareProject.getFolder().get().getLocation();
        LocalRef<PublicShareProject> projectLocalRef = this.loadProject(PublicShareProject.class, location, false);
        PublicShareProject savedPublicShare = projectLocalRef.get();
        if (savedPublicShare.isLocked() && !username.equals(savedPublicShare.getUserLock())) {
            throw MetadataExceptionFactory.createProjectLockedException(savedPublicShare.getUserLock());
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            LockType lock = new LockType();
            lock.setUsername(username);
            lock.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
            ProjectLoader loader = savedPublicShare.getProject().get().getLoader();
            assert (loader != null);
            ProjectFileSystem projectFileSystem = loader.getProjectFileSystem();
            VFileSystem dataFileSystem = projectFileSystem.getDataFileSystem();
            this.mdPersistence.acquireLock(dataFileSystem, lock);
            DraftProject draft = this.mdPersistence.createDraftProject(savedPublicShare, username);
            dataFileSystem.flush();
            tx.commit();
            DraftProject draftProject = draft;
            return draftProject;
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (IOException e) {
            tx.rollback();
            throw new MetadataException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void removeDraft(@NotNull String draftLocation) throws MetadataException {
        if (draftLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeDraft must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectFolder folder = ProjectFolder.create(draftLocation);
            MetadataType metadata = this.mdPersistence.loadMetadataArtifact(DraftProject.class, folder);
            if (metadata == null) {
                throw MetadataExceptionFactory.createProjectNotFound(draftLocation);
            }
            this.removeProject(DraftProject.class, folder);
            folder = folder.getParentFolder().get();
            LocalRef<PublicShareProject> projectLocalRef = this.loadProject(PublicShareProject.class, folder.getLocation(), false);
            PublicShareProject publicShareProject = projectLocalRef.get();
            this.mdPersistence.releaseLock(publicShareProject);
            ProjectFolder rootFolder = ProjectFolder.create("/");
            try {
                while (!rootFolder.equals(folder)) {
                    this.mdPersistence.removeFolder(DraftProject.class, folder, false);
                    folder = folder.getParentFolder().get();
                }
            }
            catch (PersistenceException ignore) {
                // empty catch block
            }
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void commitChanges(@NotNull String location) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.commitChanges must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            MetadataType metadata = this.mdPersistence.loadMetadataArtifact(DraftProject.class, ProjectFolder.create(location));
            if (metadata == null) {
                throw MetadataExceptionFactory.createProjectNotFound(location);
            }
            tx.begin();
            this.mdPersistence.commitChanges(metadata);
            this.removeDraft(location);
            Filesystem filesystem = metadata.getTopology().getFilesystem();
            CowFilesystem cowFilesystem = filesystem.getCowFilesystem();
            Filesystem read = cowFilesystem.getRead();
            String basePathPublicShare = MetadataArtifactHelper.getRelativePathFrom(ProjectType.PUBLIC_SHARED);
            String publicShareLocation = read.getSimpleFilesystem().substring(basePathPublicShare.length());
            String publicShareCannonicalPath = VFileUtils.getCannonicalPath((String)publicShareLocation);
            ProjectFolder folder = ProjectFolder.create(publicShareCannonicalPath);
            MetadataType publicShareMetadata = this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, folder);
            publicShareMetadata.setUpdateTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
            MdsFileSystem fileSystem = new MdsFileSystem(this.mdsInstance, basePathPublicShare + publicShareCannonicalPath);
            this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, fileSystem, publicShareMetadata);
            this.mdPersistence.releaseFromCache(publicShareMetadata);
            fileSystem.flush();
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (InvalidNamespaceException e) {
            tx.rollback();
            throw PersistenceException.createInvalidPathException(location, e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder) throws MetadataException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createFolder must not be null");
        }
        this.mdPersistence.createFolder(context, folder);
    }

    @Override
    public <T extends MdProject> void removeFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeFolder must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            Collection<LocalRef<T>> refCollection = this.mdPersistence.find(context, folder.getLocalRef(), null, true);
            if (!refCollection.isEmpty()) {
                if (recursive) {
                    for (LocalRef<T> localRef : refCollection) {
                        MdProject project = (MdProject)localRef.get();
                        ProjectFolder projectFolder = project.getFolder().get();
                        if (project instanceof PublicShareProject) {
                            this.removePublicShare(projectFolder);
                            continue;
                        }
                        if (project instanceof DraftProject) {
                            this.removeDraft(projectFolder.getLocation());
                            continue;
                        }
                        if (!(project instanceof TemplateProject)) continue;
                        this.removeProject(TemplateProject.class, projectFolder);
                    }
                } else {
                    throw new MetadataException(MetadataMsg.FOLDER_NOT_EMPTY(folder.getLocation()));
                }
            }
            this.mdPersistence.removeFolder(context, folder, recursive);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseLock must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            StringBuilder location = new StringBuilder(publicShareProject.getFolder().get().getLocation());
            location.append("/").append(publicShareProject.getUserLock());
            this.removeDraft(location.toString());
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject> void releaseFromCache(@NotNull Class<T> type, @NotNull String projectLocation) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseFromCache must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseFromCache must not be null");
        }
        MetadataType metadataType = this.mdPersistence.loadMetadataArtifact(type, ProjectFolder.create(projectLocation));
        if (metadataType != null) {
            this.mdPersistence.releaseFromCache(metadataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePublicShareProperties(@NotNull String publicShareId, boolean allowSharing, @Nullable String workflow, @Nullable List<String> participantIds) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updatePublicShareProperties must not be null");
        }
        LocalRef<PublicShareProject> publicShareProjectLocalRef = this.loadProject(PublicShareProject.class, publicShareId, false);
        PublicShareProject publicShareProject = publicShareProjectLocalRef.get();
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            PublicShareMetadata type = (PublicShareMetadata)publicShareProject.getMetadata();
            type.setAllowShare(allowSharing);
            LocalRef<Project> projectLocalRef = publicShareProject.getProject();
            Project project = projectLocalRef.get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            VFileSystem system = loader.getProjectFileSystem().getDataFileSystem();
            this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, system, type);
            tx.commit();
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public LocalRef<DeployedProject> getDeployedProject(@NotNull String projectLocation) throws MetadataException {
        String path;
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getDeployedProject must not be null");
        }
        try {
            path = Namespace.SOAINFRA.getMdsNamespace().getPath();
        }
        catch (InvalidNamespaceException e) {
            throw new MetadataException(e);
        }
        String mountPoint = path + "/" + projectLocation;
        MetadataType metadata = MetadataArtifactBuilder.create(projectLocation, "", projectLocation);
        Topology topology = new Topology();
        Filesystem filesystem = new Filesystem();
        filesystem.setSimpleFilesystem(mountPoint);
        topology.setFilesystem(filesystem);
        metadata.setTopology(topology);
        metadata.setName(projectLocation);
        metadata.setProjectType(ProjectType.DEPLOY);
        return this.mdPersistence.createMdProject(DeployedProject.class, projectLocation, metadata);
    }

    @Override
    public void assignLock(@NotNull PublicShareProject publicShareProject, @NotNull String username, boolean forceLock) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.assignLock must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.assignLock must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            boolean hasLock;
            tx.begin();
            String location = publicShareProject.getFolder().get().getLocation();
            ProjectLoader loader = publicShareProject.getProject().get().getLoader();
            assert (loader != null);
            ProjectFileSystem fileSystem = loader.getProjectFileSystem();
            VFileSystem dataFileSystem = fileSystem.getDataFileSystem();
            LockType lock = this.mdPersistence.getLock(dataFileSystem);
            boolean bl = hasLock = lock != null;
            if (hasLock) {
                if (forceLock) {
                    String normalizePath = VFileUtils.getCannonicalPath((String)(location + "/" + lock.getUsername()));
                    this.removeDraft(normalizePath);
                } else {
                    throw MetadataExceptionFactory.createProjectLockedException(lock.getUsername());
                }
            }
            this.createDraftProject(publicShareProject, username);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    private void setHumanTaskNamespaceSuffix(VFileSystem system) throws IOException, JAXBException {
        VFile[] files = system.getRoot().listFiles(new VFileFilter(){

            public boolean accept(@NotNull VFile pathname) throws IOException {
                return pathname.getCanonicalPath().endsWith(".task");
            }
        });
        if (files != null) {
            for (VFile file : files) {
                TaskDefinitionUtil instance = TaskDefinitionUtil.getInstance();
                TaskDefinition definition = (TaskDefinition)instance.unmarshal((InputStream)new VFileInputStream(file));
                definition.setSuffixNamespace(true);
                instance.marshal((Object)definition, (OutputStream)new BufferedOutputStream((OutputStream)new VFileOutputStream(file)));
            }
        }
    }

    private <T extends MdProject> String getAbsoluteLocation(@NotNull Class<T> type, @NotNull ProjectFolder location, @NotNull String projectName) throws InvalidNamespaceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getAbsoluteLocation must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getAbsoluteLocation must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getAbsoluteLocation must not be null");
        }
        ProjectType projectType = MetadataArtifactHelper.getProjectType(type);
        String baseLocation = MetadataArtifactHelper.getRelativePathFrom(projectType);
        return baseLocation + "/" + location.getLocation() + "/" + projectName;
    }

    private void removeProject(@NotNull VFileSystem filesystem) throws IOException {
        VFile[] files;
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeProject must not be null");
        }
        for (VFile file : files = filesystem.list(filesystem.getRoot(), null)) {
            file.delete();
        }
    }

    private <T extends MdProject> ProjectFolder findProjectByName(@NotNull Class<T> type, @NotNull String projectName) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.findProjectByName must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.findProjectByName must not be null");
        }
        ProjectFolder result = null;
        T project = this.mdPersistence.findProjectByName(type, null, projectName, true);
        if (project != null) {
            result = (ProjectFolder)Cast.force((Object)project.getFolder().get());
        }
        return result;
    }

    private void init(@Nullable URL resource) throws MetadataException {
        String userMock = System.getProperty(METADATA_MOCK_WORKSPACEDIR);
        try {
            if (userMock != null) {
                this.mdPersistence = new MockMdPersistence();
            } else {
                assert (resource != null) : "Null resource URL should only be used for the mock";
                this.mdsInstance = MdsInstanceInitializer.getMDSInstance(resource);
                this.mdPersistence = new MdsMdPersistence(this.mdsInstance);
            }
        }
        catch (MDSException e) {
            throw new MetadataException(e);
        }
        catch (MalformedURLException e) {
            throw new MetadataException(e);
        }
    }

    private void checkTimestamp(@NotNull MetadataType originalMetadata, @NotNull MetadataType localMetadata) throws MetadataException {
        if (originalMetadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.checkTimestamp must not be null");
        }
        if (localMetadata == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.checkTimestamp must not be null");
        }
        XMLGregorianCalendar originalTimestamp = originalMetadata.getUpdateTimestamp();
        XMLGregorianCalendar localTimestamp = localMetadata.getUpdateTimestamp();
        if (localTimestamp == null && originalTimestamp != null || originalTimestamp != null && !localTimestamp.equals(originalTimestamp)) {
            throw new MetadataException(MetadataMsg.PROJECT_VERSION_OUTDATED(originalMetadata.getName()));
        }
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

