/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MdProjectImpl;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.mds.exception.InvalidNamespaceException;
import org.jetbrains.annotations.NotNull;

public class DraftProjectImpl
extends MdProjectImpl<DraftProject>
implements DraftProject {
    DraftProjectImpl(@NotNull MdPersistence persistence, @NotNull MetadataType metadataType, @NotNull String location) {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/DraftProjectImpl.<init> must not be null");
        }
        if (metadataType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/DraftProjectImpl.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/DraftProjectImpl.<init> must not be null");
        }
        super(persistence, metadataType, location);
    }

    public static DraftProject create(@NotNull MdPersistence persistence, @NotNull MetadataType metadataType) throws MetadataException {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/DraftProjectImpl.create must not be null");
        }
        if (metadataType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/DraftProjectImpl.create must not be null");
        }
        try {
            String location = MetadataArtifactHelper.resolverRelativeFolder(metadataType);
            return new DraftProjectImpl(persistence, metadataType, location);
        }
        catch (InvalidNamespaceException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public LocalRef<DraftProject> getLocalRef() {
        return new LocalRef<DraftProject>(this.getName(), this);
    }

    @Override
    public String getPublicShareId() {
        return this.getFolder().get().getParentFolder().get().getLocation();
    }
}

