/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.exception;

import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectLockedException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.msg.MetadataMsg;
import org.jetbrains.annotations.NotNull;

public class MetadataExceptionFactory {
    private MetadataExceptionFactory() {
    }

    public static MetadataException createProjectNotFound(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectNotFound must not be null");
        }
        return new ProjectNotFoundException(MetadataMsg.PROJECT_NOT_FOUND(projectName));
    }

    public static MetadataException createProcessNotFoundException(@NotNull String processName) {
        if (processName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProcessNotFoundException must not be null");
        }
        return new MetadataException(MetadataMsg.PROCESS_NOT_FOUND(processName));
    }

    public static MetadataException createInvalidProjectException() {
        return new MetadataException(MetadataMsg.INVALID_PROJECT);
    }

    public static MetadataException createProjectLockedException(@NotNull String username) {
        if (username == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectLockedException must not be null");
        }
        return new ProjectLockedException(username);
    }
}

