/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.entity;

import java.util.Calendar;
import java.util.List;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.impl.MdProjectImpl;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicShareProject
extends MdProjectImpl<PublicShareProject> {
    protected boolean hasDraft;
    protected LockType lockType;

    public PublicShareProject(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        this(name, null, project);
    }

    public PublicShareProject(@NotNull String name, @Nullable String description, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        super(name, project);
        this.metadata = new PublicShareMetadata();
        this.setDescription(description);
        this.setName(name);
    }

    protected PublicShareProject(@NotNull MdPersistence persistence, @NotNull MetadataType metadataType, @NotNull String location) {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (metadataType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        super(persistence, metadataType, location);
    }

    public String getDescription() {
        return this.getMetadata().getDescription();
    }

    public void setDescription(@Nullable String description) {
        this.getMetadata().setDescription(description);
    }

    @Override
    public LocalRef<PublicShareProject> getLocalRef() {
        return new LocalRef<PublicShareProject>(this.getName(), this);
    }

    public boolean hasDraft() {
        return this.hasDraft;
    }

    public boolean isAllowSharing() {
        return ((PublicShareMetadata)this.getMetadata()).isAllowShare();
    }

    public void setAllowSharing(boolean share) {
        ((PublicShareMetadata)this.getMetadata()).setAllowShare(share);
    }

    public boolean isProjectFromScratch() {
        return ((PublicShareMetadata)this.getMetadata()).isIsFromScratch();
    }

    public void setProjectFromScratch(boolean share) {
        ((PublicShareMetadata)this.getMetadata()).setIsFromScratch(share);
    }

    public boolean isApprovalWorkflow() {
        return this.getApprovalWorkflowUrl() != null;
    }

    public String getApprovalWorkflowUrl() {
        return ((PublicShareMetadata)this.getMetadata()).getWorkflowUrl();
    }

    public void setApprovalWorkflowUrl(@Nullable String url) {
        ((PublicShareMetadata)this.getMetadata()).setWorkflowUrl(url);
    }

    public void setWorkflowParticipants(@NotNull List<String> participantIds) {
        if (participantIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.setWorkflowParticipants must not be null");
        }
        MetadataArtifactHelper.setWorkflowParticipants((PublicShareMetadata)this.getMetadata(), participantIds);
    }

    public List<String> getWorkflowParticipants() {
        PublicShareMetadata.WorkflowParticipants participants = MetadataArtifactHelper.getWorkflowParticipants((PublicShareMetadata)this.getMetadata());
        return participants.getParticipantId();
    }

    public boolean isLocked() {
        return this.lockType != null;
    }

    public String getUserLock() {
        return this.lockType != null ? this.lockType.getUsername() : null;
    }

    public Calendar getTimestampLock() {
        return this.lockType != null ? this.lockType.getTimestamp().toGregorianCalendar() : null;
    }
}

