/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.repository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.process.ProcessCreationTemplate;
import oracle.bpm.extensionpoint.metadata.ProjectRepositoryMetadata;
import oracle.bpm.fusion.repository.FusionProjectLoader;
import oracle.bpm.fusion.repository.fs.FusionFileSystem;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.Identifier;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.PropertyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ProjectRepositoryMetadata(type="jdev")
public class FusionProjectRepository
extends FileProjectRepository {
    @NotNull
    private List<oracle.bpm.project.model.Project> bpmProjects = new ArrayList<oracle.bpm.project.model.Project>();
    private boolean initialized;
    @NotNull
    private Map<String, oracle.bpm.project.model.Project> jprojectLabelToBpmProject = new HashMap<String, oracle.bpm.project.model.Project>();
    @Nullable
    private Workspace workspace;
    private Observer workspaceListener;
    private static ProcessCreationTemplate template;

    public FusionProjectRepository() {
    }

    public FusionProjectRepository(@Nullable Workspace workspace) {
        this.setWorkspace(workspace);
    }

    public static boolean isBpmProject(Project jdevProject) {
        TechnologyScope ts = TechnologyScopeConfiguration.getInstance((PropertyStorage)jdevProject).getTechnologyScope();
        TechId bpm = TechnologyRegistry.getInstance().getTechId("BPM");
        if (bpm != null && ts.contains(bpm)) {
            return true;
        }
        try {
            File f = new File(jdevProject.getURL().toURI()).getParentFile();
            if (new File(f, "processes").exists()) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static void setProcessCreationTemplate(ProcessCreationTemplate temp) {
        template = temp;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setTechnologyScope(Project project) {
        TechnologyScope scope = new TechnologyScope();
        scope.setTechnologyKeys(new String[]{"BPM"});
        TechnologyScopeConfiguration.getInstance((PropertyStorage)project).setTechnologyScope(scope);
    }

    @Nullable
    public oracle.bpm.project.model.Project create(@NotNull URI baseLocation, @NotNull String projectName) throws ProjectException {
        try {
            File projectFolder = new File(new File(baseLocation), projectName);
            URL projectURL = URLFactory.newDirURL((File)projectFolder);
            URL jdevProjectUrl = URLFactory.newURL((URL)projectURL, (String)(projectName + ".jpr"));
            boolean existsProject = NodeFactory.find((URL)jdevProjectUrl) != null;
            Project jdevProject = (Project)NodeFactory.findOrCreate(Project.class, (URL)jdevProjectUrl);
            Workspace workspace = this.workspace != null ? this.workspace : Ide.getActiveWorkspace();
            workspace.add((Element)jdevProject, true);
            try {
                if (!existsProject) {
                    this.setTechnologyScope(jdevProject);
                }
                jdevProject.save();
            }
            catch (IOException e) {
                throw ProjectException.wrap(null, (Throwable)e);
            }
            return this.create(jdevProject);
        }
        catch (Exception e) {
            throw new ProjectException(null, null, (Throwable)e);
        }
    }

    public void delete(@NotNull oracle.bpm.project.model.Project project) throws ProjectException {
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            Project jDevProject = this.getJDevProject(project);
            workspace.remove((Element)jDevProject, true);
        }
    }

    @Nullable
    public Project getJDevProject(oracle.bpm.project.model.Project project) {
        return Platform.getAdapterService().adaptTo(project, Project.class);
    }

    public void dispose() {
        this.stopListeningWorkspaceEvents();
        super.dispose();
    }

    @Nullable
    public Workspace getWorkspace() {
        return this.workspace;
    }

    public File getDefaultBaseDir() {
        File baseDir = this.workspace != null ? new File(this.workspace.getBaseDirectory()) : null;
        return baseDir != null ? baseDir : FileSystemTokens.getDefaultProjectsDir();
    }

    public void setWorkspace(@Nullable Workspace workspace) {
        if (this.workspace != null) {
            throw new ProgramException("Workspace was already set into " + ((Object)((Object)this)).getClass().getName());
        }
        this.workspace = workspace;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public oracle.bpm.project.model.Project create(@NotNull Project jdevProject) throws ProjectException {
        String key = jdevProject.getLongLabel();
        if (this.jprojectLabelToBpmProject.containsKey(key)) {
            return this.jprojectLabelToBpmProject.get(key);
        }
        File projectFolder = new File(jdevProject.getBaseDirectory());
        File baseDir = projectFolder.getParentFile();
        oracle.bpm.project.model.Project project = this.createInternal(baseDir.toURI(), projectFolder.getName());
        ProjectObjectImpl.setAdapter((ProjectObject)project, (Object)jdevProject);
        this.bpmProjects.add(project);
        this.jprojectLabelToBpmProject.put(jdevProject.getLongLabel(), project);
        ProjectFileSystem fileSystem = this.createFileSystem(project, baseDir.toURI());
        this.initProject(project, fileSystem);
        if (jdevProject.getProperty("bpm.project.template") != null) {
            ProjectPreferences preferences = project.getPreferences();
            if (!preferences.isTemplate()) {
                preferences.setTemplate(true);
                project.getWriter().write(new ProjectObject[]{preferences});
            }
            jdevProject.getProperties().remove("bpm.project.template");
        }
        this.initJDevProject(jdevProject, fileSystem);
        try {
            if (template != null) {
                FuegoProject fuegoProject = (FuegoProject)project;
                Process process = template.getProcess(fuegoProject);
                if ("".equals(process.getId())) {
                    process.setId(Identifier.classname(fuegoProject.getNextValidNameForProcess(SchemaType.PROCESS.toString()), false));
                }
                project.getModelsRoot().addChild((ProjectObject)process);
                StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
                StudioEditor editor = workbench.findEditorByObject((Object)process);
                if (editor == null) {
                    editor = workbench.openEditorForObject((Object)process);
                }
                if (editor != null) {
                    workbench.activateEditor(editor);
                }
            }
        }
        finally {
            template = null;
        }
        return project;
    }

    public void delete(Project jdevProject) throws ProjectException {
        String longLabel = jdevProject.getLongLabel();
        if (this.jprojectLabelToBpmProject.containsKey(longLabel)) {
            oracle.bpm.project.model.Project project = this.jprojectLabelToBpmProject.get(longLabel);
            super.delete(project);
            this.deleteFromMap(project);
        }
    }

    @Nullable
    public Project getJdevProject(@NotNull URL url) {
        oracle.bpm.project.model.Project project = this.getProject(url);
        return project != null ? this.getJDevProject(project) : null;
    }

    @Nullable
    public oracle.bpm.project.model.Project getProject(@NotNull URL url) {
        oracle.bpm.project.model.Project result = null;
        String urlProtocol = url.getProtocol();
        String urlPath = url.getPath();
        for (oracle.bpm.project.model.Project project : this.bpmProjects) {
            String projectPath;
            URL projectUrl = this.getUrl((ProjectObject)project);
            if (projectUrl == null || !urlProtocol.equals(projectUrl.getProtocol()) || !urlPath.startsWith(projectPath = projectUrl.getPath())) continue;
            result = project;
            break;
        }
        return result;
    }

    protected ProjectLoader createLoader(@NotNull oracle.bpm.project.model.Project project, @NotNull ProjectFileSystem fileSystem) {
        return new FusionProjectLoader((ProjectRepository)this, project, fileSystem);
    }

    @NotNull
    protected VFileSystem createDataFileSystem(@NotNull File projectFolder, @NotNull oracle.bpm.project.model.Project project) {
        Project devProject = this.getJDevProject(project);
        return new FusionFileSystem(projectFolder, this.workspace, devProject);
    }

    protected void initJDevProject(final @NotNull Project jdevProject, @NotNull ProjectFileSystem fileSystem) {
        jdevProject.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                ProjectContent.initializeContentSets((Project)jdevProject);
                ProjectVersion.initializeVersions((PropertyStorage)jdevProject, (String)ProjectMigrator.MIGRATOR_NAME);
            }
        });
        ProjectContent.initializeContentSets((Project)jdevProject);
    }

    String getWorkspacePath() {
        String path = this.getWorkspace().getURL().getPath();
        int index = path.lastIndexOf(47);
        return path.substring(0, index);
    }

    List<String> getAllProjectPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (oracle.bpm.project.model.Project project : this.bpmProjects) {
            result.add(this.getProjectPath(project));
        }
        return result;
    }

    String getProjectPath(oracle.bpm.project.model.Project project) {
        URL url = this.getUrl((ProjectObject)project);
        return url.getPath();
    }

    ProjectObject getProjectObject(@NotNull URL url) {
        oracle.bpm.project.model.Project project = this.getProject(url);
        return project != null ? this.findProjectObjectByUrl((ProjectObject)project, url) : null;
    }

    private void checkStatus() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("This repository was not initialized: " + (Object)((Object)this));
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("This repository was disposed: " + (Object)((Object)this));
        }
    }

    private URL getUrl(ProjectObject project) {
        AdapterService service = Platform.getAdapterService();
        return service.adaptTo(project, URL.class);
    }

    @Nullable
    private ProjectObject findProjectObjectByUrl(@NotNull ProjectObject object, @NotNull URL url) {
        ProjectObject result = null;
        LinkedList<ProjectObject> queue = new LinkedList<ProjectObject>();
        queue.add(object);
        while (!queue.isEmpty()) {
            ProjectObject current = (ProjectObject)queue.remove();
            if (url.equals(this.getUrl(current))) {
                result = current;
                break;
            }
            if (!(current instanceof ProjectObjectContainer)) continue;
            for (ProjectObject child : ((ProjectObjectContainer)current).getChildren()) {
                if (child == null) {
                    throw new IllegalArgumentException("Parent returned list with null element: " + current);
                }
                queue.add(child);
            }
        }
        return result;
    }

    private void deleteFromMap(@NotNull oracle.bpm.project.model.Project project) {
        String jdevLongLabel = this.getJDevProject(project).getLongLabel();
        this.jprojectLabelToBpmProject.remove(jdevLongLabel);
        this.bpmProjects.remove(project);
    }

    private void init() {
        this.initialized = true;
        this.openAlreadyOpenedProject();
        this.startListeningWorkspaceEvents();
    }

    private void startListeningWorkspaceEvents() {
        this.getWorkspace().attach(this.getWorkspaceListener());
    }

    private Observer getWorkspaceListener() {
        if (this.workspaceListener == null) {
            this.workspaceListener = new Observer(){

                public void update(Object observed, UpdateMessage updateMessage) {
                    block10: {
                        List addedObjects;
                        int id;
                        block11: {
                            Project project;
                            block9: {
                                id = updateMessage.getMessageID();
                                if (id != UpdateMessage.CHILD_REMOVED) break block9;
                                List removeObjects = updateMessage.getRemoveObjects();
                                if (removeObjects == null) break block10;
                                for (Object removeObject : removeObjects) {
                                    if (!(removeObject instanceof Project)) continue;
                                    Project jdevProject = (Project)removeObject;
                                    try {
                                        FusionProjectRepository.this.delete(jdevProject);
                                    }
                                    catch (ProjectException e) {
                                        e.printStackTrace();
                                    }
                                }
                                break block10;
                            }
                            if (id != UpdateMessage.ATTRIBUTE_CHANGED) break block11;
                            if (!(observed instanceof Workspace) || (project = ((Workspace)observed).getActiveProject()) == null || !FusionProjectRepository.isBpmProject(project) || FusionProjectRepository.this.jprojectLabelToBpmProject.get(project.getLongLabel()) != null) break block10;
                            try {
                                FusionProjectRepository.this.create(project);
                            }
                            catch (ProjectException e) {
                                e.printStackTrace();
                            }
                            break block10;
                        }
                        if (id == UpdateMessage.CHILD_ADDED && (addedObjects = updateMessage.getAddObjects()) != null) {
                            for (Object addedObject : addedObjects) {
                                Project jdevProject;
                                if (!(addedObject instanceof Project) || !FusionProjectRepository.isBpmProject(jdevProject = (Project)addedObject)) continue;
                                try {
                                    FusionProjectRepository.this.create(jdevProject);
                                }
                                catch (ProjectException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.workspaceListener;
    }

    private void stopListeningWorkspaceEvents() {
        if (this.workspaceListener != null && this.workspace != null) {
            this.workspace.detach(this.workspaceListener);
        }
    }

    private void openAlreadyOpenedProject() {
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            Iterator it = workspace.getChildren();
            while (it.hasNext()) {
                Project jdevProject;
                Element child = (Element)it.next();
                if (!(child instanceof Project) || !FusionProjectRepository.isBpmProject(jdevProject = (Project)child)) continue;
                try {
                    this.create(jdevProject);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

