/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.datacontrol.type;

import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.bpm.bpmobject.datacontrol.type.AccessorDefinitionAdapter;
import oracle.bpm.bpmobject.datacontrol.type.AttributeDefinitionAdapter;
import oracle.bpm.bpmobject.datacontrol.type.DefinitionContainerAdapter;
import oracle.bpm.bpmobject.datacontrol.type.OperationDefinitionAdapter;
import oracle.bpm.bpmobject.datacontrol.type.VariableDefinitionAdapter;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureDefinitionAdapter
extends VariableDefinitionAdapter<ObjectTypeDescription>
implements StructureDefinition {
    public StructureDefinitionAdapter(@NotNull DataControlDefinition dataControl, @NotNull NamedDefinition parent, @NotNull ObjectTypeDescription otd) {
        if (dataControl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/datacontrol/type/StructureDefinitionAdapter.<init> must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/datacontrol/type/StructureDefinitionAdapter.<init> must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/datacontrol/type/StructureDefinitionAdapter.<init> must not be null");
        }
        super(dataControl, parent, otd);
    }

    public DefinitionContainer getAttributeDefinitions() {
        return DefinitionContainerAdapter.asDefinitionContainer(this.flattenAttributes().selectInstanceOf(AttributeTypeDescription.class).select(this.simpleTypePredicate()).map(this.attributeMapper()));
    }

    public DefinitionContainer getAccessorDefinitions() {
        return DefinitionContainerAdapter.asDefinitionContainer(this.flattenAttributes().selectInstanceOf(AttributeTypeDescription.class).select(PredicateUtils.not(this.simpleTypePredicate())).map(this.accessorMapper()));
    }

    public DefinitionContainer getOperationDefinitions() {
        return DefinitionContainerAdapter.asDefinitionContainer(this.flattenMethods().select(this.visibleMethodPredicate()).map(this.operationMapper()));
    }

    public DefinitionContainer getConstructorOperationDefinitions() {
        return DefinitionContainerAdapter.asDefinitionContainer(CollectionUtils.emptySequence());
    }

    public DefinitionContainer getCriteriaDefinitions() {
        return DefinitionContainerAdapter.asDefinitionContainer(CollectionUtils.emptySequence());
    }

    public int getDefinitionType() {
        return 20;
    }

    private Function<AttributeTypeDescription, AttributeDefinition> attributeMapper() {
        return new Function<AttributeTypeDescription, AttributeDefinition>(){

            @Override
            public AttributeDefinition eval(AttributeTypeDescription value) {
                return new AttributeDefinitionAdapter(StructureDefinitionAdapter.this.dataControl, StructureDefinitionAdapter.this, value);
            }
        };
    }

    private Predicate<AttributeTypeDescription> simpleTypePredicate() {
        return new Predicate<AttributeTypeDescription>(){

            @Override
            public boolean check(@Nullable AttributeTypeDescription value) {
                return value != null && StructureDefinitionAdapter.isSimple(value.getType());
            }
        };
    }

    static boolean isSimple(TypeDescription value) {
        return value.isPredefined();
    }

    private Function<AttributeTypeDescription, AttributeDefinition> accessorMapper() {
        return new Function<AttributeTypeDescription, AttributeDefinition>(){

            @Override
            public AttributeDefinition eval(AttributeTypeDescription value) {
                return new AccessorDefinitionAdapter(StructureDefinitionAdapter.this.dataControl, StructureDefinitionAdapter.this, value);
            }
        };
    }

    private Function<MethodTypeDescription, Definition> operationMapper() {
        return new Function<MethodTypeDescription, Definition>(){

            @Override
            public Definition eval(MethodTypeDescription value) {
                return new OperationDefinitionAdapter(StructureDefinitionAdapter.this.dataControl, StructureDefinitionAdapter.this, value);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Predicate<MethodTypeDescription> visibleMethodPredicate() {
        Predicate<MethodTypeDescription> predicate = new Predicate<MethodTypeDescription>(){

            @Override
            public boolean check(@Nullable MethodTypeDescription value) {
                return value != null && value.isVisible();
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/datacontrol/type/StructureDefinitionAdapter.visibleMethodPredicate must not return null");
        }
        return predicate;
    }

    private Sequence<MethodTypeDescription> flattenAttributes() {
        SequenceBuilder<MethodTypeDescription> builder = SequenceBuilder.create();
        builder.append(((ObjectTypeDescription)this.type).getAttributes());
        for (SuperType superType : ((ObjectTypeDescription)this.type).getSuperTypes()) {
            builder.append(superType.getObjectType().getAttributes());
        }
        return builder.build();
    }

    private Sequence<MethodTypeDescription> flattenMethods() {
        SequenceBuilder<MethodTypeDescription> builder = SequenceBuilder.create();
        builder.append(((ObjectTypeDescription)this.type).getMethods());
        for (SuperType superType : ((ObjectTypeDescription)this.type).getSuperTypes()) {
            builder.append(superType.getObjectType().getMethods());
        }
        return builder.build();
    }
}

