/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.datacontrol.type;

import java.util.Iterator;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import org.jetbrains.annotations.Nullable;

class DefinitionContainerAdapter<T extends Definition>
implements DefinitionContainer {
    private final Sequence<T> definitions;

    private DefinitionContainerAdapter(Sequence<T> definitions) {
        this.definitions = definitions;
    }

    public Definition find(final String uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        return (Definition)CollectionUtils.first(this.definitions.select(new Predicate<T>(){

            @Override
            public boolean check(@Nullable T value) {
                return value instanceof NamedDefinition && uniqueId.equals(((NamedDefinition)value).getName());
            }
        }));
    }

    public Iterator iterator() {
        return this.definitions.iterator();
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    static <T extends Definition> DefinitionContainer asDefinitionContainer(Sequence<T> definitions) {
        return new DefinitionContainerAdapter<T>(definitions);
    }
}

