/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit.persistence;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableValuesExt;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.util.ByteArray;

public class AuditPersistence {
    private EntityManager mEntityManager;
    private static final String logClassName = AuditPersistence.class.getName();

    public Object persistEntity(Object entity) throws AuditPersistenceException {
        EntityManager em = this.getEntityManager();
        em.persist(entity);
        return entity;
    }

    public List<AuditQueryVariableMetadata> queryAuditQueryAttributesFindAll() throws AuditPersistenceException {
        return this.getEntityManager().createNamedQuery("AuditQueryAttributes.findAll").getResultList();
    }

    public List<AuditQueryVariableMetadata> queryAuditQueryAttributesFindAllByRange(int firstResult, int maxResults) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQueryAttributes.findAll");
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            query = query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public List<AuditQueryVariableValuesExt> queryAuditQueryAttrValuesExtFindAll() throws AuditPersistenceException {
        return this.getEntityManager().createNamedQuery("AuditQueryAttrValuesExt.findAll").getResultList();
    }

    public List<AuditQueryVariableValuesExt> queryAuditQueryAttrValuesExtFindAllByRange(int firstResult, int maxResults) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQueryAttrValuesExt.findAll");
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            query = query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public List<AuditQuery> queryAuditQueryFindAll() throws AuditPersistenceException {
        return this.getEntityManager().createNamedQuery("AuditQuery.findAll").getResultList();
    }

    public List<AuditQuery> queryAuditQueryFindAllByRange(int firstResult, int maxResults) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQuery.findAll");
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            query = query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public List<AuditQuery> queryAuditQueryFindAllbyProcessId(String processId) throws AuditPersistenceException {
        List result = null;
        result = this.getEntityManager().createNamedQuery("AuditQuery.findAllByInstanceId").setParameter("instanceId", (Object)processId).getResultList();
        return result;
    }

    public List<AuditQuery> getActiveInstancesAsOfQueryId(long queryId) throws AuditPersistenceException {
        List result = null;
        result = this.getEntityManager().createNamedQuery("AuditQuery.getActiveInstancesAsOfQueryId").setParameter("queryId", (Object)queryId).getResultList();
        return result;
    }

    public List<AuditQuery> getAllInstancesAfterQueryId(long queryId) throws AuditPersistenceException {
        List result = null;
        result = this.getEntityManager().createNamedQuery("AuditQuery.getAllInstancesAfterQueryId").setParameter("queryId", (Object)queryId).getResultList();
        return result;
    }

    public List<AuditQuery> queryAudit(String expression, Map<String, Object> parameters) throws AuditPersistenceException {
        String logMethodName = "queryAuditQuery";
        Query query = null;
        if (expression != null) {
            query = this.getEntityManager().createQuery("SELECT aq FROM AuditQuery aq WHERE " + expression);
            if (parameters != null) {
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    query.setParameter(parameter.getKey(), parameter.getValue());
                }
            }
        }
        return query.getResultList();
    }

    public AuditQueryMetadata getAuditQueryMetadata(String compositeDN) throws AuditPersistenceException {
        String logMethodName = "getAuditQueryMetadata";
        AuditQueryMetadata result = null;
        try {
            result = (AuditQueryMetadata)this.getEntityManager().find(AuditQueryMetadata.class, (Object)compositeDN);
            return result;
        }
        catch (NoResultException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAuditQueryMetadata", (String)("No audit metadata found for compositeDN {" + compositeDN + "}"));
            return null;
        }
    }

    public ByteArray getAuditQueryLog(long queryId) throws AuditPersistenceException {
        Query query = this.getEntityManager().createQuery("SELECT NEW oracle.bpm.util.ByteArray(a.auditLog) FROM AuditQuery a WHERE a.queryId = :queryId AND a.auditLog IS NOT NULL");
        query.setParameter("queryId", (Object)queryId);
        ByteArray result = null;
        try {
            result = (ByteArray)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    public ByteArray getAuditDetail(long ciKey, long detailId) throws AuditPersistenceException {
        Query query = this.getEntityManager().createQuery("SELECT NEW oracle.bpm.util.ByteArray(ad.bin) FROM AuditQueryDetails ad WHERE ad.cikey = :ciKey AND ad.detailId = :detailId AND ad.bin IS NOT NULL");
        query.setParameter("ciKey", (Object)ciKey);
        query.setParameter("detailId", (Object)detailId);
        ByteArray result = null;
        try {
            result = (ByteArray)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    public List<AuditQueryVariableRange> getAllVariableRanges(String compositeDN) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQueryVariableRange.getAllRanges");
        query.setParameter("compositeDN", (Object)compositeDN);
        List result = null;
        result = query.getResultList();
        return result;
    }

    public Integer getLastDetailId(Long ciKey) {
        String logMethodName = "getLastDetailId";
        Integer result = null;
        try {
            Query query = this.getEntityManager().createNamedQuery("AuditQueryDetails.getDetailsId");
            query.setParameter("cikey", (Object)ciKey);
            result = (Integer)query.getSingleResult();
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.WARNING, (String)logClassName, (String)"getLastDetailId", (String)("Unable to get the number of items " + e));
            result = null;
        }
        return result;
    }

    public List<AuditQuery> queryLastEventforCompositeDN(String compositeDN, int firstResult, int maxResult) throws AuditPersistenceException {
        String logMethodName = "queryLastEventforCompositeDN";
        Query query1 = this.getEntityManager().createNamedQuery("AuditQuery.queryLastEventforCompositeDN");
        query1.setParameter("compositeDN", (Object)compositeDN);
        if (firstResult > 0) {
            query1.setFirstResult(firstResult);
        }
        if (maxResult > 0) {
            query1.setMaxResults(maxResult);
        }
        List queryResult = null;
        queryResult = query1.getResultList();
        StringBuffer queryIds = new StringBuffer();
        Iterator i = queryResult.iterator();
        while (i.hasNext()) {
            Object[] vals = (Object[])i.next();
            long queryId = (Long)vals[1];
            queryIds.append(String.valueOf(queryId)).append(i.hasNext() ? "," : "");
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.DEBUG, (String)logClassName, (String)"queryLastEventforCompositeDN", (String)("Located end record {" + compositeDN + "} First, Max {" + firstResult + ", " + maxResult + "} {" + queryIds + "}"));
        List result = null;
        if (queryIds != null && queryIds.length() > 0) {
            Query query2 = this.getEntityManager().createQuery("SELECT aq FROM AuditQuery aq WHERE aq.queryId in ( " + queryIds + ") ");
            result = query2.getResultList();
        }
        return result;
    }

    public AuditQueryVariableMetadata findAuditQueryVariableMetadata(String compositeDN) {
        return (AuditQueryVariableMetadata)this.mEntityManager.find(AuditQueryVariableMetadata.class, (Object)compositeDN);
    }

    public List<AuditQuery> queryLastEventforCompositeId(String compositeInstanceId) throws AuditPersistenceException {
        String logMethodName = "getLastEventforProcessId";
        Query query1 = this.getEntityManager().createNamedQuery("AuditQuery.getLastEventforCompositeId");
        query1.setParameter("compositeId", (Object)compositeInstanceId);
        List queryResult = null;
        queryResult = query1.getResultList();
        StringBuffer queryIds = new StringBuffer();
        Iterator i = queryResult.iterator();
        while (i.hasNext()) {
            Object[] vals = (Object[])i.next();
            long queryId = (Long)vals[1];
            queryIds.append(String.valueOf(queryId)).append(i.hasNext() ? "," : "");
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getLastEventforProcessId", (String)("Located end record {" + compositeInstanceId + "} {" + queryIds + "}"));
        List result = null;
        if (queryIds != null && queryIds.length() > 0) {
            Query query2 = this.getEntityManager().createQuery("SELECT aq FROM AuditQuery aq WHERE aq.queryId in ( " + queryIds + ") ");
            result = query2.getResultList();
        }
        return result;
    }

    public List<AuditQuery> queryLastEventforComponentId(String componentInstanceId) throws AuditPersistenceException {
        String logMethodName = "getLastEventforProcessId";
        Query query1 = this.getEntityManager().createNamedQuery("AuditQuery.getLastEventforComponentId");
        query1.setParameter("componentId", (Object)componentInstanceId);
        List queryResult = null;
        queryResult = query1.getResultList();
        StringBuffer queryIds = new StringBuffer();
        Iterator i = queryResult.iterator();
        while (i.hasNext()) {
            Object[] vals = (Object[])i.next();
            long queryId = (Long)vals[1];
            queryIds.append(String.valueOf(queryId)).append(i.hasNext() ? "," : "");
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.DEBUG, (String)logClassName, (String)"getLastEventforProcessId", (String)("Located end record {" + componentInstanceId + "} {" + queryIds + "}"));
        List result = null;
        if (queryIds != null && queryIds.length() > 0) {
            Query query2 = this.getEntityManager().createQuery("SELECT aq FROM AuditQuery aq WHERE aq.queryId in ( " + queryIds + ") ");
            result = query2.getResultList();
        }
        return result;
    }

    public void setEntityManager(EntityManager em) {
        this.mEntityManager = em;
    }

    public EntityManager getEntityManager() throws AuditPersistenceException {
        String logMethodName = logClassName + ".getEntityManager ";
        if (this.mEntityManager == null) {
            throw new AuditPersistenceException(logMethodName + "Unable to locate the Entity Manager");
        }
        return this.mEntityManager;
    }
}

