/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit.impl;

import com.collaxa.cube.engine.ConfigurationHelper;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.audit.IAuditTrail;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.util.CompressUtils;
import com.collaxa.cube.engine.util.EngineRecycleBinRegistry;
import com.oracle.bpel.client.util.TransactionUtils;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.analytics.measurement.impl.MeasurementPublisher;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceLocal;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataServiceFactory;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;
import oracle.bpm.bpmn.engine.service.BPMNInstanceObserver;
import oracle.bpm.bpmn.engine.service.BPMNTransactionSynchronization;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistence;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryDetails;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;
import oracle.bpm.util.ByteArray;
import oracle.soa.common.recycle.IRecyclable;
import oracle.soa.common.recycle.RecycleBin;
import oracle.soa.common.util.CXCompressUtils;
import oracle.soa.common.util.NonSyncStringWriter;
import oracle.soa.common.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuditService
implements IAuditService {
    private transient IMeasurementMetadataServiceLocal mMeasurementService;
    private long mSequence;
    private static final String logClassName = AuditService.class.getName();
    private static final int BUFFER_LIMIT = 2000;
    private static final String BPMN_AUDITDETAILID_CONTEXT_KEY = "bpmauditdetailidcontextkey";
    private static final long STATUS_ACTIVE = new Long(1L);
    private static final long STATUS_DELETED = new Long(-1L);

    public void init() throws Exception {
        this.mSequence = 0L;
    }

    @Override
    public Long logAuditInstance(ICubeContext ctx, BPMNAuditEvent event) throws AuditPersistenceException {
        String logMethodName = "logAuditEvent ";
        BPELExecutionLogger.debug((String)logClassName, (String)"logAuditEvent ", (Object)("BEGIN - Adding IAuditInstance to the list to be persisted {" + event.getActivityId() + "}"));
        this.handleAuditPayload(ctx, event);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        event.setCreateTime(c);
        try {
            AuditService.getAuditTrail(ctx).logEvent(event);
        }
        catch (Exception e) {
            BPELExecutionLogger.warn((String)logClassName, (String)"logAuditEvent ", (Object)("Unable to post audit event " + e.toString()));
            throw new AuditPersistenceException(e);
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"logAuditEvent ", (Object)"END");
        return event.getQueryId();
    }

    @Override
    public void persistAuditMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> allRanges) throws AuditPersistenceException {
        String logMethodName = "persistAuditMetadata";
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditMetadata", (Object)("BEGIN {" + metadata.getCompositeDn() + "}"));
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        if (auditPersistency.getAuditQueryMetadata(metadata.getCompositeDn()) == null) {
            AuditQueryMetadata aqmd = new AuditQueryMetadata();
            aqmd.setCompositeDn(metadata.getCompositeDn());
            aqmd.setStatus(STATUS_ACTIVE);
            CompositeDNModel cm = CompositeDNModel.parseCompositeDN((String)metadata.getCompositeDn());
            aqmd.setApplicationName(cm.getApplicationName());
            aqmd.setCompositeName(cm.getCompositeName());
            aqmd.setLabel(cm.getLabel());
            aqmd.setRevision(cm.getRevision());
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(System.currentTimeMillis());
            aqmd.setCreationDate(c);
            List<AuditQueryVariableMetadata> aqvmd = AuditUtil.createAuditQueryVariableMetadata(metadata, allRanges);
            aqmd.setAuditQueryVariableMetadata(aqvmd);
            auditPersistency.persistEntity(aqmd);
        } else {
            BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditMetadata", (Object)("Variable metadata already exists for the composite domain {" + metadata.getCompositeDn() + "}"));
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditMetadata", (Object)"END");
    }

    @Override
    public void markAuditAsStale(List<AuditQuery> events) throws Exception {
        String logMethodName = "markAuditAsStale";
        BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsStale", (Object)"BEGIN");
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        if (events != null && events.size() > 0) {
            for (AuditQuery event : events) {
                IAuditInstance ai = AuditUtil.createAuditInstance(event, event.getAuditQueryMetadata());
                BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsStale", (Object)("Marking  {" + ai.getOperation().toString() + "}"));
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(System.currentTimeMillis());
                ai.setCreateTime(c);
                if (AuditInstanceOperation.INSTANCE_TERMINATED == AuditInstanceOperation.valueOf((String)event.getOperation())) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsStale", (Object)("Marking  {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to STALE_COMPLETED"));
                    ai.setOperation(AuditInstanceOperation.STALE_COMPLETED);
                } else {
                    BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsStale", (Object)("Marking  {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to STALE_ABORTED"));
                    ai.setOperation(AuditInstanceOperation.STALE_ABORTED);
                }
                ai.setQueryId(null);
                AuditQueryMetadata aqmd = auditPersistency.getAuditQueryMetadata(ai.getCompositeDn());
                aqmd.setUndeployDate(c);
                aqmd.setStatus(STATUS_DELETED);
                Long qId = this.persistAuditQuery(auditPersistency, AuditUtil.createAuditQuery(ai));
                ai.setQueryId(qId);
                this.publishToMeasurement(ai);
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsStale", (Object)"END");
    }

    @Override
    public List<AuditQuery> queryLastEventforCompositeDN(String compositeDN, int firstResult, int maxResult) throws Exception {
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryLastEventforCompositeDN(compositeDN, firstResult, maxResult);
        return events;
    }

    @Override
    public void markAuditAsAborted(String compositeInstanceId) throws Exception {
        String logMethodName = "markAuditAsAborted";
        BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsAborted", (Object)("BEGIN {" + compositeInstanceId + "}"));
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryLastEventforCompositeId(compositeInstanceId);
        if (events != null) {
            for (AuditQuery event : events) {
                IAuditInstance ai = AuditUtil.createAuditInstance(event, event.getAuditQueryMetadata());
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(System.currentTimeMillis());
                ai.setCreateTime(c);
                BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsAborted", (Object)("Marking  {" + ai.getOperation().toString() + "}"));
                BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsAborted", (Object)("Marking  {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to INSTANCE_ABORTED"));
                ai.setOperation(AuditInstanceOperation.INSTANCE_ABORTED);
                ai.setQueryId(null);
                Long qId = this.persistAuditQuery(auditPersistency, AuditUtil.createAuditQuery(ai));
                ai.setQueryId(qId);
                this.publishToMeasurement(ai);
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"markAuditAsAborted", (Object)("END {" + compositeInstanceId + "}"));
    }

    @Override
    public void markAuditCancelled(String instanceId) throws Exception {
        String logMethodName = "markAuditCancelled";
        BPELExecutionLogger.debug((String)logClassName, (String)"markAuditCancelled", (Object)("BEGIN {" + instanceId + "}"));
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryLastEventforComponentId(instanceId);
        if (events != null) {
            for (AuditQuery event : events) {
                IAuditInstance ai = AuditUtil.createAuditInstance(event, event.getAuditQueryMetadata());
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(System.currentTimeMillis());
                ai.setCreateTime(c);
                BPELExecutionLogger.debug((String)logClassName, (String)"markAuditCancelled", (Object)("Marking  {" + ai.getOperation().toString() + "}"));
                BPELExecutionLogger.debug((String)logClassName, (String)"markAuditCancelled", (Object)("Marking  {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to INSTANCE_ABORTED"));
                ai.setOperation(AuditInstanceOperation.INSTANCE_ABORTED);
                ai.setQueryId(null);
                Long qId = this.persistAuditQuery(auditPersistency, AuditUtil.createAuditQuery(ai));
                ai.setQueryId(qId);
                this.publishToMeasurement(ai);
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"markAuditCancelled", (Object)("END {" + instanceId + "}"));
    }

    @Override
    public List<IAuditInstance> queryAuditInstanceByProcessId(String instanceId) throws AuditPersistenceException {
        String logMethodName = "queryAuditInstanceByProcessId ";
        BPELExecutionLogger.debug((String)logClassName, (String)"queryAuditInstanceByProcessId ", (Object)"BEGIN");
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryAuditQueryFindAllbyProcessId(instanceId);
        BPELExecutionLogger.debug((String)logClassName, (String)"queryAuditInstanceByProcessId ", (Object)("END {" + events.toString() + "}"));
        return this.createAuditInstances(events);
    }

    @Override
    public List<IAuditInstance> getActiveInstancesAsOfQueryId(long queryId) throws AuditPersistenceException {
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<AuditQuery> events = auditPersistency.getActiveInstancesAsOfQueryId(queryId);
        return this.createAuditInstances(events);
    }

    @Override
    public List<IAuditInstance> getAllInstancesAfterQueryId(long queryId) throws AuditPersistenceException {
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<AuditQuery> events = auditPersistency.getAllInstancesAfterQueryId(queryId);
        return this.createAuditInstances(events);
    }

    @Override
    public List<IAuditInstance> queryAuditInstances(String expression) throws AuditPersistenceException {
        return this.queryAuditInstances(expression, null);
    }

    @Override
    public List<IAuditInstance> queryAuditInstances(String expression, Map<String, Object> parameters) throws AuditPersistenceException {
        String logMethodName = "queryAuditInstance";
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        try {
            return this.createAuditInstances(auditPersistency.queryAudit(expression, parameters));
        }
        catch (Exception e) {
            BPELExecutionLogger.error((String)logClassName, (String)"queryAuditInstance", (Object)("Unable to query for Audit Instance with the JPQL Query {" + (expression == null ? "null" : expression) + "} " + e.toString()));
            throw new AuditPersistenceException(e);
        }
    }

    @Override
    public byte[] getAuditInstancePayload(long queryId) throws AuditPersistenceException {
        String logMethodName = "getAuditInstancePayload";
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        ByteArray auditLog = auditPersistency.getAuditQueryLog(queryId);
        if (auditLog != null) {
            RecycleBin pool = EngineRecycleBinRegistry.getInstance();
            NonSyncStringWriter sink = (NonSyncStringWriter)pool.get(NonSyncStringWriter.class);
            String payload = null;
            try {
                CXCompressUtils.uncompressStream((byte[])auditLog.getBytes(), (Writer)sink);
                payload = sink.toString();
            }
            catch (Exception e) {
                throw new AuditPersistenceException("Problem inflating the audit log " + e.toString());
            }
            finally {
                pool.release((IRecyclable)sink);
            }
            try {
                BPELExecutionLogger.debug((String)logClassName, (String)"getAuditInstancePayload", (Object)("XML Payload" + payload + "}"));
                Document doc = XMLUtil.parseDocumentFromXMLString((String)payload);
                Document resultDoc = XMLUtil.createDocument();
                if (resultDoc == null) {
                    BPELExecutionLogger.warn((String)"getAuditInstancePayload", (String)logClassName, (Object)"The payload doess not contain the expected auditQueryPayload element.");
                    return new byte[0];
                }
                Element resultRoot = resultDoc.createElement("auditQueryPayload");
                long ciKey = Long.parseLong(doc.getFirstChild().getAttributes().getNamedItem("ciKey").getTextContent());
                resultRoot.setAttribute("ciKey", String.valueOf(ciKey));
                NodeList payloadDataObjects = doc.getElementsByTagName("dataObject");
                for (int i = 0; i < payloadDataObjects.getLength(); ++i) {
                    Element resultDo = resultDoc.createElement("dataObject");
                    Node payloadDataObject = payloadDataObjects.item(i);
                    Node payloadDOValue = payloadDataObject.getFirstChild();
                    if (payloadDOValue == null) {
                        NamedNodeMap n = payloadDataObject.getAttributes();
                        Node detailIdNode = n.getNamedItem("detailId");
                        if (detailIdNode == null) continue;
                        long detailId = Long.parseLong(detailIdNode.getTextContent());
                        ByteArray auditDetail = auditPersistency.getAuditDetail(ciKey, detailId);
                        String detail = null;
                        try {
                            sink.reset();
                            CXCompressUtils.uncompressStream((byte[])auditDetail.getBytes(), (Writer)sink);
                            detail = sink.toString();
                        }
                        catch (Exception e) {
                            throw new AuditPersistenceException("Problem inflating the audit detail " + e.toString());
                        }
                        finally {
                            pool.release((IRecyclable)sink);
                        }
                        Element detailNode = XMLUtil.parseDocumentFromXMLString((String)detail).getDocumentElement();
                        Element resultValue = resultDoc.createElement("value");
                        resultValue.appendChild(XMLUtil.cloneNode((Document)resultDoc, (Node)detailNode));
                        resultDo.appendChild(resultValue);
                        resultRoot.appendChild(resultDo);
                        continue;
                    }
                    resultRoot.appendChild(XMLUtil.cloneNode((Document)resultDoc, (Node)payloadDataObject));
                }
                resultDoc.appendChild(resultRoot);
                byte[] buffer = null;
                payload = XMLUtil.toString((Node)resultDoc);
                BPELExecutionLogger.debug((String)logClassName, (String)"getAuditInstancePayload", (Object)("Reconstituted payload {" + payload + "}"));
                try {
                    buffer = CompressUtils.compressString((String)payload);
                }
                catch (Exception e) {
                    throw new AuditPersistenceException("Unable to compress the audit log information.", e);
                }
                return buffer;
            }
            catch (Exception e) {
                BPELExecutionLogger.error((String)logClassName, (String)"getAuditInstancePayload", (Object)("Problem getting the audit log payload {" + e.toString() + "}"));
                throw new AuditPersistenceException(e);
            }
        }
        return new byte[0];
    }

    @Override
    public IAuditVariableMetadata getAuditVariableMetadata(String compositeDN) throws Exception {
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        List<IAuditVariableRange> allRanges = this.createVariableRanges(auditPersistency.getAllVariableRanges(compositeDN));
        IAuditVariableMetadata varMetadata = AuditUtil.createAuditVariableMetadata(auditPersistency.getAuditQueryMetadata(compositeDN));
        varMetadata.setAllRanges(allRanges);
        return varMetadata;
    }

    @Override
    public AuditQueryMetadata getAuditQueryMetadata(String compositeDN) throws Exception {
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        AuditQueryMetadata metadata = auditPersistency.getAuditQueryMetadata(compositeDN);
        return metadata;
    }

    @Override
    public void setEntityManager(EntityManager em) {
    }

    @Override
    public EntityManager getEntityManager() throws Exception {
        return null;
    }

    @Override
    public void persistAuditData(ICubeContext ctx) throws AuditPersistenceException {
        String logMethodName = "persistAuditData ";
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditData ", (Object)"BEGIN");
        try {
            this.persistAuditData(AuditService.getAuditTrail(ctx));
            AuditService.getAuditTrail(ctx).clear();
        }
        catch (Exception e) {
            throw new AuditPersistenceException(e);
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditData ", (Object)"END");
    }

    @Override
    public void persistAuditData(IAuditTrail auditTrail) throws AuditPersistenceException {
        String logMethodName = "persistAuditData ";
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditData ", (Object)"BEGIN");
        ArrayList<BPMNAuditEvent> auditEventList = new ArrayList<BPMNAuditEvent>();
        if (auditTrail instanceof BPMNAuditTrail) {
            AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
            Iterator events = auditTrail.getEvents();
            while (events.hasNext()) {
                IAuditEvent evt = (IAuditEvent)events.next();
                if (!(evt instanceof BPMNAuditEvent)) continue;
                BPMNAuditEvent event = (BPMNAuditEvent)evt;
                this.persistAuditQuery(auditPersistency, event.getAuditQuery());
                auditEventList.add(event);
            }
            if (auditEventList.size() > 0) {
                this.publishAuditInstanceInBatch(auditEventList);
            }
            ((BPMNAuditTrail)auditTrail).clear();
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditData ", (Object)"END");
    }

    @Override
    public boolean canLog(ICubeContext context, AuditLevel level) {
        ICubeInstanceImpl instance = CubeContextHelper.getCubeInstance((ICubeContext)context);
        AuditLevel auditLevel = ConfigurationHelper.getCurrentAuditLevel((ICubeProcess)instance.getProcessClass(), (ICubeContext)context);
        if (AuditLevel.Off.equals((Object)auditLevel)) {
            return false;
        }
        return !auditLevel.isGreaterThan(level);
    }

    @Override
    public boolean canLog(ICubeContext context, AuditLevel level, IElementContext eCtx) throws Exception {
        String logMethodName = "canLog";
        boolean canLog = this.canLog(context, level);
        if (!canLog) {
            BPELExecutionLogger.debug((String)logClassName, (String)"canLog", (Object)"Officially logging is off - checking the mesasurement framework");
            canLog = this.canPublish(eCtx) != null;
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"canLog", (Object)("requested level {" + level.toString() + "}. Returning {" + canLog + "}"));
        return canLog;
    }

    private void publishAuditInstanceInBatch(List<BPMNAuditEvent> events) throws AuditPersistenceException {
        ArrayList<IAuditInstance> auditInstanceList = new ArrayList<IAuditInstance>();
        for (BPMNAuditEvent event : events) {
            IAuditInstance auditInstance = AuditUtil.createAuditInstance(event.getAuditQuery(), event.getAuditQueryMetadata());
            auditInstance.setAssociatedVariables(event.getAssociatedVariables());
            auditInstanceList.add(auditInstance);
        }
        this.publishToMeasurementInBatch(auditInstanceList);
    }

    private void publishToMeasurement(IAuditInstance event) throws AuditPersistenceException {
        try {
            String logMethodName = "publishToMeasurement";
            IMeasure measure = null;
            IElementContext eCtx = AuditService.getElementContext(event);
            measure = this.canPublish(eCtx);
            MeasurementPublisher measurementPublisher = new MeasurementPublisher();
            if (measurementPublisher != null && measure != null) {
                BPELExecutionLogger.debug((String)logClassName, (String)"publishToMeasurement", (Object)("Measurement is enabled with {" + measure.getActions().size() + "} actions. Publishing AuditInstance {" + event.getQueryId() + "}"));
                measurementPublisher.publish(event, measure);
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"publishToMeasurement", (Object)("Measurement is disabled or there are no pending actions. Not publishing {" + event.getQueryId() + "}"));
            }
        }
        catch (Exception e) {
            throw new AuditPersistenceException(e);
        }
    }

    private void publishToMeasurementInBatch(List<IAuditInstance> auditInstanceList) throws AuditPersistenceException {
        try {
            String logMethodName = "publishToMeasurement";
            MeasurementPublisher pub = new MeasurementPublisher();
            ArrayList<IMeasure> measuresList = new ArrayList<IMeasure>();
            ArrayList<IAuditInstance> pubAuditInstanceList = new ArrayList<IAuditInstance>();
            for (IAuditInstance ai : auditInstanceList) {
                IElementContext eCtx = AuditService.getElementContext(ai);
                IMeasure measure = this.canPublish(eCtx);
                if (pub != null && measure != null) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"publishToMeasurement", (Object)("Measurement is enabled with {" + measure.getActions().size() + "} actions. Publishing AuditInstance {" + ai.getQueryId() + "}"));
                    measuresList.add(measure);
                    pubAuditInstanceList.add(ai);
                    continue;
                }
                BPELExecutionLogger.debug((String)logClassName, (String)"publishToMeasurement", (Object)("Measurement is disabled or there are no pending actions. Not publishing {" + ai.getQueryId() + "}"));
            }
            if (pub != null && measuresList.size() > 0) {
                pub.publishBatchAsList(pubAuditInstanceList, measuresList);
            }
        }
        catch (Exception e) {
            throw new AuditPersistenceException(e);
        }
    }

    private IMeasure canPublish(IElementContext eCtx) throws Exception {
        String logMethodName = "canPublish";
        IMeasure measure = null;
        if (!Util.isEnvMeasurementDisabled(eCtx.getCompositeDN()) && !(measure = this.getMeasurementService().isElementRegistered(eCtx)).isMeasurementEnabled()) {
            measure = null;
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"canPublish", (Object)("Measurement enabled status {" + (measure != null ? "true" : "false") + "}"));
        if (measure != null && measure.getActions() != null && measure.getActions().size() > 0) {
            String disabledActions = Util.getEnvDisabledActions();
            measure.setActions(MeasurementUtil.getEnabledActionsList((IMeasure)measure, (String)disabledActions));
        }
        return measure;
    }

    private List<IAuditInstance> createAuditInstances(List<AuditQuery> auditQuery) throws AuditPersistenceException {
        String logMethodName = "createAuditInstances";
        ArrayList<IAuditInstance> instances = new ArrayList<IAuditInstance>();
        try {
            for (AuditQuery aq : auditQuery) {
                String varCSV;
                String[] names;
                AuditQueryMetadata amd = aq.getAuditQueryMetadata();
                IAuditInstance ai = AuditUtil.createAuditInstance(aq, amd);
                if (aq.getElementVariableCSV() != null && (names = (varCSV = aq.getElementVariableCSV()).replaceFirst("\\[", "").replaceFirst("\\]", "").split(",")) != null && names.length > 0) {
                    for (int i = 0; i < names.length; ++i) {
                        ai.addAssociatedVariable(names[i].trim());
                    }
                }
                BPELExecutionLogger.debug((String)logClassName, (String)"createAuditInstances", (Object)("Associated varaibles Query ID {" + ai.getQueryId() + "} Activity {" + ai.getActivityId() + "} Operation {" + ai.getOperation() + "} {" + ai.getVariables().toString() + "}"));
                instances.add(ai);
            }
        }
        catch (Exception e) {
            BPELExecutionLogger.error((String)logClassName, (String)"createAuditInstances", (Object)("Unable to convert AuditQuery to IAuditInstance " + e.toString()));
            throw new AuditPersistenceException("Unable to convert AuditQuery to IAuditInstance " + e.toString(), e);
        }
        return instances;
    }

    private List<IAuditVariableRange> createVariableRanges(List<AuditQueryVariableRange> allRanges) throws AuditPersistenceException {
        String logMethodName = "createVariableRanges";
        ArrayList<IAuditVariableRange> ranges = new ArrayList<IAuditVariableRange>();
        try {
            for (AuditQueryVariableRange range : allRanges) {
                IAuditVariableRange ar = AuditUtil.createAuditvariableRange(range);
                ranges.add(ar);
            }
        }
        catch (Exception e) {
            BPELExecutionLogger.error((String)logClassName, (String)"createVariableRanges", (Object)("Unable to convert AuditQueryVariableRange to IAuditVariableRange " + e.toString()));
            throw new AuditPersistenceException("Unable to convert AuditQueryVariableRange to IAuditVariableRange " + e.toString(), e);
        }
        return ranges;
    }

    private Long persistAuditQuery(AuditPersistence auditPersistency, AuditQuery auditQuery) throws AuditPersistenceException {
        AuditQueryMetadata aqmd = auditPersistency.getAuditQueryMetadata(auditQuery.getCompositeDn());
        return this.persistAuditQuery(auditPersistency, auditQuery, aqmd);
    }

    private Long persistAuditQuery(AuditPersistence auditPersistency, AuditQuery auditQuery, AuditQueryMetadata metadata) throws AuditPersistenceException {
        String logMethodName = "persistAuditQuery ";
        auditQuery.setAuditQueryMetadata(metadata);
        auditQuery = (AuditQuery)auditPersistency.persistEntity(auditQuery);
        BPELExecutionLogger.debug((String)logClassName, (String)"persistAuditQuery ", (Object)("Persisted {" + auditQuery.getQueryId() + "} {" + auditQuery.getActivityId() + "} {" + auditQuery.getActivityName() + "} {" + auditQuery.getOperation().toString() + "}"));
        return auditQuery.getQueryId();
    }

    private void handleAuditPayload(ICubeContext ctx, BPMNAuditEvent event) throws AuditPersistenceException {
        String logMethodName = "handleAuditPayload";
        BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditPayload", (Object)"BEGIN");
        Map<String, IAuditVariable> payloadElements = event.getPayloadElements();
        if (payloadElements == null || payloadElements.size() == 0) {
            BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditPayload", (Object)"END - No payload elements provided");
            return;
        }
        int combinedSize = 0;
        StringBuffer buffer = new StringBuffer();
        String v = null;
        byte[] log = null;
        AuditPersistence auditPersistency = AuditServiceFactory.getInstance().getAuditPersistence();
        buffer.append("<?xml version=\"1.0\"?><auditQueryPayload ciKey=\"" + event.getCompositeInstanceId().toString() + "\">");
        Set<Map.Entry<String, IAuditVariable>> payloadSet = payloadElements.entrySet();
        for (Map.Entry<String, IAuditVariable> entry : payloadSet) {
            int vLength;
            log = null;
            IAuditVariable variable = entry.getValue();
            String name = variable.getName();
            Object value = variable.getValue();
            String variableType = null;
            if (variable.getType() != null) {
                variableType = "D".equals(variable.getType()) ? "DIMENSION" : ("M".equals(variable.getType()) ? "MEASURE" : ("C".equals(variable.getType()) ? "COUNTER" : ""));
            }
            if ((vLength = (v = value instanceof Element ? XMLUtil.toString((Node)((Element)value)) : (value != null ? "<![CDATA[" + String.valueOf(value) + "]]>" : "")).length()) > 2000 || combinedSize + vLength > 2000) {
                try {
                    log = CompressUtils.compressString((String)v);
                }
                catch (Exception e) {
                    throw new AuditPersistenceException("Unable to compress the audit log information.", e);
                }
                try {
                    long ciKey = Long.parseLong(event.getCompositeInstanceId());
                    int detailId = this.getNextDetailId(auditPersistency, ctx, ciKey);
                    this.persistAuditDetail(auditPersistency, ciKey, detailId, log, event.getPartitionDate());
                    buffer.append("<dataObject name=\"" + name + "\" detailId=\"" + detailId + "\"" + " isBusinessIndicator=\"" + (variable.isCounter() || variable.isMeasure() || variable.isDimension() ? "true" : "false") + "\"" + (variable.getType() != null ? " type=\"" + variableType + "\"" : "") + "/>");
                }
                catch (NumberFormatException e) {
                    BPELExecutionLogger.error((String)logClassName, (String)"handleAuditPayload", (Object)("The compositeInstanceId {" + event.getCompositeInstanceId() + "} can not be converted to Long. Audit Detail will not be persisted"));
                }
            } else {
                buffer.append("<dataObject name=\"" + name + "\"" + " isBusinessIndicator=\"" + (variable.isCounter() || variable.isMeasure() || variable.isDimension() ? "true" : "false") + "\"" + (variable.getType() != null ? " type=\"" + variableType + "\"" : "") + "><value>").append(v).append("</value></dataObject>");
            }
            combinedSize += vLength;
        }
        buffer.append("</auditQueryPayload>");
        try {
            log = CompressUtils.compressString((String)buffer.toString());
        }
        catch (Exception e) {
            throw new AuditPersistenceException("Unable to compress the audit log information.", e);
        }
        event.setAuditLog(log);
        BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditPayload", (Object)("END {" + buffer + "}"));
    }

    private void persistAuditDetail(AuditPersistence auditPersistency, long ciKey, int detailId, byte[] buffer, Calendar partitionDate) throws AuditPersistenceException {
        AuditQueryDetails ad = new AuditQueryDetails();
        ad.setCikey(ciKey);
        ad.setDetailId(detailId);
        ad.setBinCsize(buffer.length);
        ad.setBinUsize(buffer.length);
        ad.setBin(buffer);
        ad.setPartitionDate(partitionDate.getTime());
        ad = (AuditQueryDetails)auditPersistency.persistEntity(ad);
    }

    private static BPMNAuditTrail getAuditTrail(ICubeContext ctx) throws Exception {
        String logMethodName = "getAuditTrail";
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IAuditTrail auditTrail = cubeInstance.getAuditTrail();
        BPELExecutionLogger.debug((String)logClassName, (String)"getAuditTrail", (Object)("Obtained an audit trail {" + auditTrail.getClass().getName() + "}"));
        if (auditTrail == null || !(auditTrail instanceof BPMNAuditTrail)) {
            BPELExecutionLogger.debug((String)logClassName, (String)"getAuditTrail", (Object)"Initializing the BPMNInstanceObserver for Audit Persistence");
            BPMNAuditTrail bpmnAuditTrail = new BPMNAuditTrail((ICubeInstance)cubeInstance, ctx);
            cubeInstance.setAuditTrail((IAuditTrail)bpmnAuditTrail);
            if (TransactionUtils.isActive()) {
                TransactionSynchronizationRegistry txRegistiry = TransactionUtils.getTransactionSynchronizationRegistry();
                BPMNTransactionSynchronization sync = new BPMNTransactionSynchronization(bpmnAuditTrail, BPMNUtility.getInternalManagementservice(ctx));
                txRegistiry.registerInterposedSynchronization((Synchronization)sync);
            }
            BPMNInstanceObserver.addBPMNObserver(ctx);
            auditTrail = bpmnAuditTrail;
        }
        return (BPMNAuditTrail)auditTrail;
    }

    private int getNextDetailId(AuditPersistence auditPersistency, ICubeContext ctx, Long ciKey) {
        String logMethodName = "getNextDetailId";
        Integer detailId = (Integer)ctx.removeFromEnvironment(BPMN_AUDITDETAILID_CONTEXT_KEY);
        if (detailId == null && ((detailId = auditPersistency.getLastDetailId(ciKey)) == null || detailId.compareTo(0) < 1)) {
            detailId = new Integer(0);
        }
        ctx.addToEnvironment(BPMN_AUDITDETAILID_CONTEXT_KEY, (Object)new Integer(detailId + 1));
        BPELExecutionLogger.debug((String)logClassName, (String)"getNextDetailId", (Object)"Next Detail ID {detailId.intCValue() + 1}");
        return detailId + 1;
    }

    public static IElementContext getElementContext(IAuditInstance event) {
        IElementContext eCtx = MeasurementUtil.getElementContext((IAuditInstance)event);
        return eCtx;
    }

    protected IMeasurementMetadataServiceLocal getMeasurementService() throws Exception {
        if (this.mMeasurementService == null) {
            this.mMeasurementService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
        }
        return this.mMeasurementService;
    }
}

