/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceRemote;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;
import oracle.bpm.services.instancequery.impl.AuditInstance;
import oracle.bpm.services.instancequery.impl.AuditVariable;
import oracle.bpm.services.instancequery.impl.AuditVariableMetadata;
import oracle.bpm.services.instancequery.impl.AuditVariableRange;
import oracle.xml.jaxb.JaxbDatatypeConverter;
import org.w3c.dom.Element;

public class AuditUtil {
    private static final String logClassName = AuditUtil.class.getName();
    private static Map<String, EVariableType> sVariableTypeMap = new HashMap<String, EVariableType>();

    public static IAuditInstance createNewAuditInstance(IAuditVariableMetadata metadata) {
        return AuditInstance.newInstance((IAuditVariableMetadata)metadata);
    }

    public static IAuditVariable createNewAuditVariable() {
        return AuditVariable.newInstance();
    }

    private static IAuditVariableRange createNewAuidtVariableRange() {
        return AuditVariableRange.newInstance();
    }

    public static IAuditVariableMetadata createNewAuditVariableMetadata() {
        return AuditVariableMetadata.newInstance();
    }

    public static IAuditInstance createAuditInstance(AuditQuery auditQuery, AuditQueryMetadata metadata) {
        IAuditVariableMetadata avmd = AuditUtil.createAuditVariableMetadata(metadata);
        IAuditInstance ai = AuditUtil.createNewAuditInstance(avmd);
        ai.setActivityId(auditQuery.getActivityId());
        ai.setActivityName(auditQuery.getActivityName());
        ai.setActivityType(auditQuery.getActivityType());
        ai.setAuditInstanceType(auditQuery.getAuditInstanceType());
        ai.setComponentInstanceId(auditQuery.getComponentInstanceId());
        ai.setComponentName(auditQuery.getComponentName());
        ai.setComponentType(auditQuery.getComponentType());
        ai.setCompositeDn(auditQuery.getCompositeDn());
        ai.setCompositeInstanceId(auditQuery.getCompositeInstanceId());
        ai.setCompositeName(auditQuery.getCompositeName());
        ai.setProcessName(auditQuery.getProcessName());
        ai.setStep(auditQuery.getStep());
        ai.setLoopCount(auditQuery.getLoopCount());
        ai.setCreateTime(auditQuery.getCreateTime());
        ai.setDueDate(auditQuery.getDueDate());
        ai.setFaultIsrecoverable("Y".equals(auditQuery.getFaultIsrecoverable()));
        ai.setFaultType(auditQuery.getFaultType());
        ai.setInvokedComponentName(auditQuery.getInvokedComponentName());
        ai.setLabel(auditQuery.getLabel());
        ai.setInstanceCount(auditQuery.getInstanceCount());
        ai.setOperation(auditQuery.getOperation() != null ? AuditInstanceOperation.valueOf((String)auditQuery.getOperation()) : null);
        ai.setParentThreadId(auditQuery.getParentThreadId());
        ai.setParticipant(auditQuery.getParticipant());
        ai.setPartitionDate(auditQuery.getPartitionDate());
        ai.setPriority(auditQuery.getPriority());
        ai.setProcessDueDate(auditQuery.getProcessDueDate());
        ai.setQueryId(auditQuery.getQueryId());
        ai.setReferenceId(auditQuery.getReferenceId());
        ai.setRoleId(auditQuery.getRoleId());
        ai.setScopeId(auditQuery.getScopeId());
        ai.setSourceActivity(auditQuery.getSourceActivity());
        ai.setTargetActivity(auditQuery.getTargetActivity());
        ai.setThreadId(auditQuery.getThreadId());
        ai.setTitle(auditQuery.getTitle());
        ai.setAuditLog(auditQuery.getAuditLog());
        ai.setFlowElementType(auditQuery.getFlowElementType());
        ai.setDateValues(auditQuery.getDateValues());
        ai.setNumberValues(auditQuery.getNumberValues());
        ai.setStringValues(auditQuery.getStringValues());
        return ai;
    }

    public static IAuditVariableRange createAuditvariableRange(AuditQueryVariableRange range) {
        IAuditVariableRange varRange = AuditUtil.createNewAuidtVariableRange();
        varRange.setCompositeDN(range.getCompositeDN());
        varRange.setVarLabel(range.getVarLabel());
        varRange.setRangeName(range.getRangeName());
        varRange.setNumberRangeStart(range.getNumberRangeStart());
        varRange.setNumberRangeEnd(range.getNumberRangeEnd());
        return varRange;
    }

    public static void insertVariableMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> ranges) throws Exception {
        AuditUtil.getService().insertAuditVariableMetadata(metadata, ranges);
    }

    public static void markAuditAsStale(String compositeDN) throws Exception {
        List<AuditQuery> events = null;
        int firstResult = 0;
        int maxResult = 10;
        IInternalInstanceManagementServiceRemote service = AuditUtil.getService();
        do {
            if ((events = service.queryLastEventforCompositeDN(compositeDN, firstResult, maxResult)) == null || events.size() <= 0) continue;
            service.markAuditAsStale(events);
            firstResult += events.size();
        } while (events != null && events.size() > 0);
    }

    public static void markAuditAsAborted(IBPMContext context, String compositeInstanceId) throws Exception {
        AuditUtil.getService().markAuditAsAborted(context, compositeInstanceId);
    }

    public static AuditQuery createAuditQuery(IAuditInstance auditInstance) {
        AuditQuery aq = new AuditQuery();
        aq.setActivityId(auditInstance.getActivityId());
        aq.setActivityName(auditInstance.getActivityName());
        aq.setActivityType(auditInstance.getActivityType());
        aq.setAuditInstanceType(auditInstance.getAuditInstanceType());
        aq.setComponentInstanceId(auditInstance.getComponentInstanceId());
        aq.setComponentName(auditInstance.getComponentName());
        aq.setComponentType(auditInstance.getComponentType());
        aq.setCompositeDn(auditInstance.getCompositeDn());
        aq.setCompositeInstanceId(auditInstance.getCompositeInstanceId());
        aq.setCompositeName(auditInstance.getCompositeName());
        aq.setProcessName(auditInstance.getProcessName());
        aq.setStep(auditInstance.getStep());
        aq.setLoopCount(auditInstance.getLoopCount());
        aq.setCreateTime(auditInstance.getCreateTime());
        aq.setDueDate(auditInstance.getDueDate());
        aq.setFaultIsrecoverable(auditInstance.getFaultIsrecoverable() ? "Y" : "N");
        aq.setFaultType(auditInstance.getFaultType());
        aq.setInvokedComponentName(auditInstance.getInvokedComponentName());
        aq.setLabel(auditInstance.getLabel());
        aq.setInstanceCount(auditInstance.getInstanceCount());
        aq.setOperation(auditInstance.getOperation().toString());
        aq.setParentThreadId(auditInstance.getParentThreadId());
        aq.setParticipant(auditInstance.getParticipant());
        aq.setPartitionDate(auditInstance.getPartitionDate());
        aq.setPriority(auditInstance.getPriority());
        aq.setProcessDueDate(auditInstance.getProcessDueDate());
        aq.setQueryId(auditInstance.getQueryId());
        aq.setReferenceId(auditInstance.getReferenceId());
        aq.setRoleId(auditInstance.getRoleId());
        aq.setScopeId(auditInstance.getScopeId());
        aq.setSourceActivity(auditInstance.getSourceActivity());
        aq.setTargetActivity(auditInstance.getTargetActivity());
        aq.setThreadId(auditInstance.getThreadId());
        aq.setTitle(auditInstance.getTitle());
        aq.setAuditLog(auditInstance.getAuditLog());
        aq.setFlowElementType(auditInstance.getFlowElementType());
        aq.setDateValues(auditInstance.getDateValues());
        aq.setNumberValues(auditInstance.getNumberValues());
        aq.setStringValues(auditInstance.getStringValues());
        return aq;
    }

    public static AuditQueryVariableMetadata createAuditQueryVariableMetadataX(IAuditVariableMetadata metadata) {
        AuditQueryVariableMetadata aqvmd = new AuditQueryVariableMetadata();
        aqvmd.setCompositeDn(metadata.getCompositeDn());
        aqvmd.setDateNames(metadata.getDateNames());
        aqvmd.setDateTypes(metadata.getDateTypes());
        aqvmd.setNumberNames(metadata.getNumberNames());
        aqvmd.setNumberTypes(metadata.getNumberTypes());
        aqvmd.setStringNames(metadata.getStringNames());
        aqvmd.setStringTypes(metadata.getStringTypes());
        return aqvmd;
    }

    public static List<AuditQueryVariableMetadata> createAuditQueryVariableMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> allRanges) {
        AuditQueryVariableMetadata aqvmd = null;
        ArrayList<AuditQueryVariableMetadata> varMetadata = new ArrayList<AuditQueryVariableMetadata>();
        aqvmd = new AuditQueryVariableMetadata();
        aqvmd.setCompositeDn(metadata.getCompositeDn());
        aqvmd.setExtensionId(0L);
        aqvmd.setDateNames(metadata.getDateNames());
        aqvmd.setDateTypes(metadata.getDateTypes());
        aqvmd.setNumberNames(metadata.getNumberNames());
        aqvmd.setNumberTypes(metadata.getNumberTypes());
        aqvmd.setStringNames(metadata.getStringNames());
        aqvmd.setStringTypes(metadata.getStringTypes());
        aqvmd.setAuditQueryVariableRange(allRanges);
        varMetadata.add(aqvmd);
        return varMetadata;
    }

    public static IAuditVariableMetadata createAuditVariableMetadata(AuditQueryMetadata metadata) {
        IAuditVariableMetadata avm = AuditUtil.createNewAuditVariableMetadata();
        if (metadata.getAuditQueryVariableMetadata() != null) {
            for (AuditQueryVariableMetadata md : metadata.getAuditQueryVariableMetadata()) {
                avm.setCompositeDn(md.getCompositeDn());
                avm.setDateNames(md.getDateNames());
                avm.setDateTypes(md.getDateTypes());
                avm.setNumberNames(md.getNumberNames());
                avm.setNumberTypes(md.getNumberTypes());
                avm.setStringNames(md.getStringNames());
                avm.setStringTypes(md.getStringTypes());
                if (md.getAuditQueryVariableRange() == null || md.getAuditQueryVariableRange().size() <= 0) continue;
                ArrayList<IAuditVariableRange> allRanges = new ArrayList<IAuditVariableRange>();
                for (AuditQueryVariableRange range : md.getAuditQueryVariableRange()) {
                    allRanges.add(AuditUtil.createAuditvariableRange(range));
                }
                avm.setAllRanges(allRanges);
            }
        }
        return avm;
    }

    public static void addVariableMetadata(IAuditVariableMetadata metadata, String name, String dataType, String type) {
        String logMethodName = "addVariableMetadata";
        BPELExecutionLogger.debug((String)logClassName, (String)"addVariableMetadata", (Object)"BEGIN");
        String vt = null;
        vt = type.length() > 1 ? type.substring(0, 1).toUpperCase() : type;
        EVariableType vx = sVariableTypeMap.get(dataType.toLowerCase());
        if (vx == null) {
            BPELExecutionLogger.debug((String)logClassName, (String)"addVariableMetadata", (Object)("Unable to find Variable tyep for data Type " + dataType));
            return;
        }
        switch (vx) {
            case DATE: {
                metadata.addDateVariable(name, type);
                break;
            }
            case NUMBER: {
                metadata.addNumberVariable(name, type);
                break;
            }
            case STRING: {
                metadata.addStringVariable(name, type);
                break;
            }
            default: {
                BPELExecutionLogger.debug((String)logClassName, (String)"addVariableMetadata", (Object)("Unable to recognize the variable data type {" + dataType + "} for variable {" + name + "}"));
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"addVariableMetadata", (Object)"END");
    }

    public static void setAuditVariableValue(IScope scope, IAuditVariableMetadata metadata, IAuditInstance event, String name) throws CubeException {
        String logMethodName = "setAuditVariableValue";
        BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("BEGIN {" + name + "}"));
        Object valueObj = DataHandlingUtils.getVariableValue(name, scope);
        if (valueObj == null) {
            BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)"END variable value is null ");
            return;
        }
        if (metadata == null) {
            BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("END Metadata is null for variable name " + name));
            return;
        }
        int slot = metadata.getSlot(name);
        if (slot == 0) {
            BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("END Unable to locate the slot for the variable {" + name + "}"));
            return;
        }
        EVariableType vx = AuditUtil.getAuditVariableType(metadata, name);
        if (vx == EVariableType.UNKNOWN) {
            BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)"END Unable to find Variable type for data Type.");
            return;
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("Variable Name {" + name + "} Normalized Data Type {" + vx.toString() + "} Value Class {" + valueObj.getClass().getName() + "}"));
        String v = null;
        switch (vx) {
            case STRING: {
                v = valueObj instanceof Element ? ((Element)valueObj).getTextContent() : String.valueOf(valueObj);
                BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("Converting value {" + v + "} to string"));
                event.setStringValue(slot, String.valueOf(v));
                break;
            }
            case NUMBER: {
                v = valueObj instanceof Element ? ((Element)valueObj).getTextContent() : String.valueOf(valueObj);
                BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("Converting value {" + v + "} to BigDecimal"));
                event.setNumberValue(slot, new BigDecimal(v));
                break;
            }
            case DATE: {
                v = valueObj instanceof Element ? ((Element)valueObj).getTextContent() : String.valueOf(valueObj);
                BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("Converting value {" + v + "} to Date"));
                event.setDateValue(slot, JaxbDatatypeConverter.parseDateTime((String)v));
                break;
            }
            default: {
                BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)("The type {" + vx.toString() + "} for variable {" + name + "} is not supported. Setting to type STRING"));
                event.setStringValue(slot, String.valueOf(valueObj));
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"setAuditVariableValue", (Object)"END");
    }

    public static String getProjectVariableType(Object variable) {
        QName dataType = null;
        if (variable instanceof CXTypeVariable) {
            dataType = ((CXTypeVariable)variable).getType();
        } else if (variable instanceof CXElementVariable) {
            dataType = ((CXElementVariable)variable).getEntityDef().getElementQName();
        } else {
            throw new IllegalArgumentException();
        }
        return dataType.getLocalPart();
    }

    public static EVariableType getAuditVariableType(IAuditVariableMetadata metadata, String name) {
        EVariableType vx = null;
        vx = metadata.getNumberNames().contains(name) ? EVariableType.NUMBER : (metadata.getStringNames().contains(name) ? EVariableType.STRING : (metadata.getDateNames().contains(name) ? EVariableType.DATE : EVariableType.UNKNOWN));
        return vx;
    }

    public static String getActivityType(FlowNode flowNode, BpmnType bpmnType) {
        String result = bpmnType.getInnerType() == BpmnType.InnerType.EVENT ? ((Event)flowNode.asAnyNode(Event.class)).getEventTriggerType().name() : null;
        return result;
    }

    private static IInternalInstanceManagementServiceRemote getService() throws Exception {
        InitialContext jContext = new InitialContext();
        return (IInternalInstanceManagementServiceRemote)jContext.lookup("InternalInstanceManagementService#oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceRemote");
    }

    static {
        sVariableTypeMap.put("Time", EVariableType.DATE);
        sVariableTypeMap.put("Int", EVariableType.NUMBER);
        sVariableTypeMap.put("String", EVariableType.STRING);
        sVariableTypeMap.put("Bool", EVariableType.STRING);
        sVariableTypeMap.put("boolean", EVariableType.STRING);
        sVariableTypeMap.put("Decimal", EVariableType.NUMBER);
        sVariableTypeMap.put("Real", EVariableType.NUMBER);
        sVariableTypeMap.put("time", EVariableType.DATE);
        sVariableTypeMap.put("dateTime", EVariableType.DATE);
        sVariableTypeMap.put("int", EVariableType.NUMBER);
        sVariableTypeMap.put("string", EVariableType.STRING);
        sVariableTypeMap.put("bool", EVariableType.STRING);
        sVariableTypeMap.put("real", EVariableType.NUMBER);
        sVariableTypeMap.put("decimal", EVariableType.NUMBER);
    }

    private static enum EVariableType {
        DATE,
        NUMBER,
        STRING,
        UNKNOWN;

    }
}

