/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit;

import com.collaxa.cube.engine.core.BPELExecutionLogger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.impl.AuditService;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistence;

public final class AuditServiceFactory {
    private Context mContext;
    private static final String logClassName = AuditServiceFactory.class.getName();
    private static final AuditServiceFactory sFactoryInstance = new AuditServiceFactory();

    private AuditServiceFactory() {
    }

    public static AuditServiceFactory getInstance() {
        return sFactoryInstance;
    }

    public IAuditService getAuditService() throws Exception {
        String logMethodName = "getAuditService";
        BPELExecutionLogger.debug((String)logClassName, (String)"getAuditService", (Object)"BEGIN Creating a new Audit Service");
        AuditService as = new AuditService();
        BPELExecutionLogger.debug((String)logClassName, (String)"getAuditService", (Object)"END Creating a new Audit Service");
        return as;
    }

    public AuditPersistence getAuditPersistence() {
        AuditPersistence p = new AuditPersistence();
        p.setEntityManager(this.getEntityManager());
        return p;
    }

    public void setEntityManager(EntityManager em) throws Exception {
        String logMethodName = "setEntityManager";
        BPELExecutionLogger.debug((String)logClassName, (String)"setEntityManager", (Object)"Setting the entity manager from an external source.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManager getEntityManager() {
        String logMethodName = "getEntityManager";
        try {
            EntityManager em;
            if (this.mContext == null) {
                this.mContext = new InitialContext();
            }
            if ((em = (EntityManager)this.mContext.lookup("java:comp/env/persistence/BPELEntityManager")) != null) {
                BPELExecutionLogger.debug((String)logClassName, (String)"getEntityManager", (Object)("Got container managed entity manager " + em.getDelegate()));
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"getEntityManager", (Object)"Got NULL container managed entity manager ");
            }
            EntityManager entityManager = em;
            return entityManager;
        }
        catch (Exception e) {
            BPELExecutionLogger.debug((String)logClassName, (String)"getEntityManager", (Object)("No implementation for the entity manager {java:comp/env/persistence/BPELEntityManager} was found." + e));
            EntityManager entityManager = null;
            return entityManager;
        }
    }
}

