/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.engine.dispatch.DispatchLogger;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import com.collaxa.cube.engine.dispatch.message.IMessageHandler;
import com.collaxa.cube.engine.util.EngineBeanCache;
import com.oracle.bpel.client.ejb.interfaces.ICubeInstanceManagerLocalBean;
import java.util.Properties;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessage;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.dms.context.ExecutionContext;
import oracle.soa.management.ComponentDN;

public class CreateComponentInstanceMessageHandler
implements IMessageHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IMessage handle(IMessage msg) throws Exception {
        CreateComponentInstanceMessage em = (CreateComponentInstanceMessage)msg;
        String domainId = em.getApplicationName();
        ComponentDN processDN = em.getProcessId();
        DispatchLogger.debug((String)"CreateInstanceMessageHandler", (String)"handle", (Object)"Processing process message ", (Object)processDN, (Object)" for domain ", (Object)domainId);
        this.restoreDMSExecutionContext(em);
        try {
            ICubeInstanceManagerLocalBean cubeInstanceManagerBean = EngineBeanCache.getInstanceManagerLocalBean((String)msg.getEngineType());
            IBPMNCubeInstanceManagerLocalBean localBean = (IBPMNCubeInstanceManagerLocalBean)cubeInstanceManagerBean;
            Properties customProperties = new Properties();
            customProperties.put("START_EVENT_ID_PROPERTY", em.getStartEventId());
            customProperties.put("tracking.ecid", ExecutionContext.get().getECID());
            localBean.createComponentInstance(processDN, customProperties);
        }
        finally {
            ExecutionContext.deactivateContext();
        }
        return null;
    }

    private void restoreDMSExecutionContext(CreateComponentInstanceMessage em) {
        String ecWrap = em.getProperties().getProperty("tracking.ecwrap");
        boolean ok = ExecutionContext.unwrap((String)ecWrap);
        assert (ok) : "ExecutionContext was not propagated as expected! ExectionContext wrap: '" + ecWrap + "'";
    }
}

