/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.engine.core.BPELExecutionLogger;
import javax.transaction.Synchronization;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;

public class BPMNTransactionSynchronization
implements Synchronization {
    private BPMNAuditTrail mAuditTrail;
    private IInternalInstanceManagementServiceLocal mLocalBean = null;
    private static final String logClassName = BPMNTransactionSynchronization.class.getName();

    public BPMNTransactionSynchronization(BPMNAuditTrail auditTrail, IInternalInstanceManagementServiceLocal localBean) {
        this.mAuditTrail = auditTrail;
        this.mLocalBean = localBean;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        String logMethodName = "afterCompletion";
        BPELExecutionLogger.debug((String)logClassName, (String)"afterCompletion", (Object)("BEGIN - Flushing {" + this.mAuditTrail.getEventCount() + "} audit records."));
        try {
            if (this.mAuditTrail.getEventCount() > 0) {
                if (i != 3) {
                    BPELExecutionLogger.warn((String)logClassName, (String)"afterCompletion", (Object)("Commiting  {" + this.mAuditTrail.getEventCount() + "} audit logs for transaction state " + i));
                }
                this.mLocalBean.persistAuditData(this.mAuditTrail);
            }
        }
        catch (Throwable e) {
            BPELExecutionLogger.error((String)logClassName, (String)"afterCompletion", (Object)("Unable to commit the last {" + this.mAuditTrail.getEventCount() + "} audit logs " + e.toString()), (Throwable)e);
        }
        finally {
            this.mLocalBean = null;
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"afterCompletion", (Object)"END");
    }
}

