/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.bpel.dms.DMSInstrumentationServiceImpl;
import com.collaxa.cube.ICubeResourceBundleManager;
import com.collaxa.cube.ResourceBundleHelper;
import com.collaxa.cube.engine.agents.recovery.BPELRecoveryListener;
import com.collaxa.cube.engine.deployment.CubeProcessorFactory;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.dispatch.message.IMessageHandler;
import com.collaxa.cube.engine.dispatch.message.MessageRegistry;
import com.collaxa.cube.engine.util.EngineBeanCache;
import com.collaxa.cube.engine.util.EngineRecycleBinRegistry;
import com.collaxa.cube.persistence.BpelDaoFactory;
import com.collaxa.cube.persistence.IDaoFactory;
import com.collaxa.cube.util.logging.ICubeLoggerManager;
import com.collaxa.cube.util.logging.LogFactory;
import com.collaxa.cube.xml.xpath.BPELXPathFunctionResolver;
import com.oracle.bpel.client.ejb.interfaces.ICubeInstanceManagerLocalBean;
import com.oracle.bpel.client.ejb.interfaces.ICubeProcessManagerLocalBean;
import com.oracle.bpel.client.util.ExceptionUtils;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceRemote;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataServiceFactory;
import oracle.bpm.bpmn.engine.instancemanagement.IInternalInstanceManagementService;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.model.BPMNCubeProcessorFactory;
import oracle.bpm.bpmn.engine.model.deploy.schema.BpmnDesignSchema;
import oracle.bpm.bpmn.engine.model.runtime.BPMNWaitListener;
import oracle.bpm.bpmn.engine.resource.BPMNResourceBundleManager;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.ProcessRoleCache;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionResolver;
import oracle.bpm.bpmn.engine.service.BPMNDMSConstants;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessage;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessageHandler;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNProcessManagerLocalBean;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.DeployedProjectService;
import oracle.bpm.pml.service.impl.DeployedProjectServiceImpl;
import oracle.bpm.pml.service.util.DeployedProjectUtil;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.model.Organization;
import oracle.fabric.CubeServiceEngine;
import oracle.fabric.ICubeDMSMetadata;
import oracle.fabric.blocks.ImplementationType;
import oracle.fabric.common.FabricDeploymentException;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.integration.platform.blocks.cluster.ClusterInterface;
import oracle.integration.platform.blocks.mesh.FabricLifecycleListener;
import oracle.integration.platform.common.FabricMDSAccessor;
import oracle.mds.core.MDSInstance;
import oracle.soa.common.recycle.IRecyclable;
import oracle.soa.common.recycle.RecycleBin;
import oracle.soa.common.util.CXCompressUtils;
import oracle.soa.common.util.NonSyncStringWriter;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.config.ConfigDefs;
import oracle.soa.management.config.bpel.BPELConfig;
import oracle.soa.management.config.bpmn.BPMNConfig;
import oracle.soa.management.internal.facade.bpm.BPMFaultImpl;
import oracle.soa.management.internal.facade.bpm.BPMInstanceImpl;
import oracle.soa.management.internal.facade.bpmn.BPMNFaultImpl;
import oracle.soa.management.internal.facade.bpmn.BPMNInstanceImpl;
import org.w3c.dom.Document;

public class BPMNServiceEngine
extends CubeServiceEngine
implements FabricLifecycleListener {
    private BPMNConfig bpmnConfig;
    private BPMNXPathFunctionContext bpmnXPathFunctionContext;
    private BPMNXPathFunctionResolver bpmnXPathFunctionResolver;
    private ClusterInterface mClusterInterface;
    private IDaoFactory mDaoFactory;
    private List<String> mDeployedDN;
    private static DeployedProjectService sService = null;
    private static final Object lock = new Object();
    private static final String logClassName = BPMNServiceEngine.class.getName();
    private static BPMNServiceEngine sEngine = null;
    private static final String DEPLOYMENT_DESCRIPTOR_FILE_NAME = "bpmDeploymentDescriptor.xml";
    private static final String ORGANIZATION_FILE_NAME = "organization.xml";

    public BPMNServiceEngine() {
        CubeProcessorFactory.registerProcessor((ImplementationType)ImplementationType.BPMN, (CubeProcessorFactory)new BPMNCubeProcessorFactory());
        System.out.println("BPMNServiceEngine=> constructed ....");
        MessageRegistry.registerMessage(CreateComponentInstanceMessage.class, (IMessageHandler)new CreateComponentInstanceMessageHandler());
        sEngine = this;
        this.registerBPMNLoggerAndResource();
        this.mDMSMetadata = new ICubeDMSMetadata(){

            public String getEngineType() {
                return "bpmn";
            }

            public String getFaultExecutionTimeSensorName() {
                return "faultedExecutionTime";
            }

            public String getBusinessFaultsSensorName() {
                return "businessFaults";
            }

            public String getSystemFaultsSensorName() {
                return "systemFaults";
            }

            public String getMessageProcessingNounPath() {
                return "/soainfra/engines/message_processing/bpmn";
            }

            public String getComponentRequestsNounType() {
                return "soainfra_bpmn_requests";
            }

            public String getActiveRequestSensorName() {
                return "active";
            }

            public String getScheduledRequestSensorName() {
                return "scheduled";
            }

            public String getRequestThreadCountSensorName() {
                return "threadCount";
            }

            public String getRequestNounPath(String requestType) {
                return BPMNDMSConstants.getBPMNRequestNounPath(requestType);
            }

            public String getActivityNounType() {
                return "soainfra_bpmn_activity";
            }

            public String getExecutionTimeSensorName() {
                return "executionTime";
            }
        };
        this.mDMSService = new DMSInstrumentationServiceImpl(this.mDMSMetadata);
        this.mDeployedDN = new ArrayList<String>();
    }

    public static BPMNServiceEngine getInstance() {
        return sEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployedProjectService getDeployedProjectServiceImpl() throws MetadataException {
        if (sService == null) {
            Object object = lock;
            synchronized (object) {
                if (sService == null) {
                    MDSInstance mInstance = FabricMDSAccessor.getMDSInstance();
                    sService = new DeployedProjectServiceImpl(mInstance);
                }
            }
        }
        return sService;
    }

    public void setClusterInterface(ClusterInterface clusterInterface) {
        this.mClusterInterface = clusterInterface;
    }

    public ClusterInterface getClusterInterface() {
        return this.mClusterInterface;
    }

    public void setBPMNXPathFunctionResolver(BPMNXPathFunctionResolver resolver) {
        this.bpmnXPathFunctionResolver = resolver;
    }

    public BPMNXPathFunctionResolver getBPMNXPathFunctionResolver() {
        return this.bpmnXPathFunctionResolver;
    }

    public void setBPMNXPathFunctionContext(BPMNXPathFunctionContext context) {
        this.bpmnXPathFunctionContext = context;
    }

    public BPMNXPathFunctionContext getBPMNXPathFunctionContext() {
        return this.bpmnXPathFunctionContext;
    }

    public BPELXPathFunctionResolver getBPELXPathFunctionResolver() {
        return this.getBPMNXPathFunctionResolver();
    }

    public String getEngineType() {
        return "bpmn";
    }

    public IDaoFactory getDaoFactory() {
        if (this.mDaoFactory == null) {
            this.mDaoFactory = new BpelDaoFactory(this.getBPMNConfig().getQualityOfService());
        }
        return this.mDaoFactory;
    }

    public Class getWaitListenerClass() {
        return BPMNWaitListener.class;
    }

    public Class<BPELRecoveryListener> getRecoveryListenerClass() {
        return BPELRecoveryListener.class;
    }

    public BPELConfig getBpelConfig() {
        return this.getBPMNConfig();
    }

    public void setBpelConfig(BPELConfig bpelConfig) {
        this.bpmnConfig = (BPMNConfig)bpelConfig;
    }

    public BPMNConfig getBPMNConfig() {
        if (this.bpmnConfig == null) {
            this.bpmnConfig = (BPMNConfig)this.getFabricConfigManager().getConfigObject(ConfigDefs.URL_BPMN_CONFIG);
        }
        return this.bpmnConfig;
    }

    public void createComponentInstance(ComponentDN targetComponent, Properties customProperties) throws Exception {
        ICubeInstanceManagerLocalBean localBean = EngineBeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
        customProperties.put("START_EVENT_ID_PROPERTY", "START_EVENT_USER_INITIATE");
        ((IBPMNCubeInstanceManagerLocalBean)localBean).createComponentInstance(targetComponent, customProperties);
    }

    public Object executeEngineMethod(String methodName, Object[] parameters) throws Exception {
        if ("createComponentInstance".equals(methodName)) {
            ComponentDN target = (ComponentDN)parameters[0];
            Properties properties = (Properties)parameters[1];
            this.createComponentInstance(target, properties);
            return null;
        }
        return super.executeEngineMethod(methodName, parameters);
    }

    public Object executeComponentMethod(CompositeDN compositeDN, String componentName, String methodName, Object[] parameters) throws Exception {
        if ("getBPMNProcessModel".equals(methodName)) {
            return this.getBPMNProcessModel(compositeDN, componentName);
        }
        return super.executeComponentMethod(compositeDN, componentName, methodName, parameters);
    }

    public Object executeComponentInstanceMethod(String instanceId, String methodName, Object[] parameters) throws Exception {
        if ("getAuditInstancePayload".equals(methodName)) {
            long queryId = (Long)parameters[0];
            return this.getAuditInstancePayload(queryId);
        }
        if ("getBPMNAudit".equals(methodName)) {
            ICubeInstanceManagerLocalBean localBean = EngineBeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
            List<IAuditInstance> auditInstances = ((IBPMNCubeInstanceManagerLocalBean)localBean).getBPMNAudit(instanceId);
            return auditInstances;
        }
        return super.executeComponentInstanceMethod(instanceId, methodName, parameters);
    }

    public String[] getConfigFileURLs() {
        String[] urls = new String[]{ConfigDefs.URL_BPMN_CONFIG, ConfigDefs.URL_SOA_INFRA_CONFIG};
        return urls;
    }

    public void deploy(ComponentModel componentModel) {
        super.deploy(componentModel);
        if (!this.mClusterInterface.isLeader()) {
            return;
        }
        CompositeModel compositeModel = componentModel.getComposite();
        Organization organization = this.getBPMOrganization(compositeModel);
        if (organization != null) {
            try {
                this.importOrganization(organization);
            }
            catch (Exception e) {
                throw new FabricDeploymentException((Throwable)e);
            }
        }
        BpmnDesignSchema designSchema = null;
        try {
            designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN, organization);
            designSchema.init();
            designSchema.populate();
        }
        catch (Throwable t) {
            if (designSchema != null) {
                designSchema.rollback();
            }
            throw new FabricDeploymentException(t);
        }
        finally {
            if (designSchema != null) {
                designSchema.cleanup();
            }
        }
        String compositeDN = componentModel.getComposite().getDN();
        DeploymentDescriptorUtil.addToCache(compositeDN, organization);
        if (!this.mDeployedDN.contains(compositeDN)) {
            this.mDeployedDN.add(compositeDN);
        }
    }

    public void undeploy(ComponentModel componentModel) throws FabricDeploymentException {
        super.undeploy(componentModel);
        try {
            BpmnDesignSchema designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN);
            IInternalInstanceManagementService service = (IInternalInstanceManagementService)BPMServiceLocator.getService((String)"internalInstanceManagementService");
            String componentName = componentModel.getName();
            String compositeDN = componentModel.getComposite().getDN();
            String componentDN = compositeDN + "/" + componentName;
            AuditUtil.markAuditAsStale(compositeDN);
            designSchema.undeploy();
            service.markInstanceAsStaleAndRemoveFlexFieldMapping(componentDN);
            IBpmAGMetadataService agMetadataSvc = BPMServiceLocator.getBpmAGMetadataService();
            agMetadataSvc.purgeAGDefinitionFromCache(compositeDN);
            CompositeModel compositeModel = componentModel.getComposite();
            String projectName = DeployedProjectUtil.buildDeployedCompositeName((String)compositeModel.getName(), (String)compositeModel.getRevision());
            BPMNServiceEngine.getDeployedProjectServiceImpl().releaseCachedProject(projectName);
            DeploymentDescriptorUtil.removeFromCache(compositeDN);
            ProcessRoleCache.clearCache(compositeDN);
            IMeasurementMetadataServiceRemote mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceRemote();
            mService.unload(componentModel);
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    public void load(ComponentModel componentModel) throws FabricDeploymentException {
        super.load(componentModel);
        try {
            IMeasurementMetadataServiceRemote mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceRemote();
            mService.load(componentModel);
        }
        catch (Exception e) {
            Object mService = null;
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    public Organization getBPMOrganization(String compositeDN) {
        CompositeModel compositeModel = this.lookupCompositeModel(compositeDN);
        return this.getBPMOrganization(compositeModel);
    }

    public Organization getBPMOrganization(CompositeModel compositeModel) {
        Document dom = compositeModel.getMetadataManager().getDocumentAsDOM(ORGANIZATION_FILE_NAME);
        if (dom != null) {
            Organization organization = DeploymentDescriptorUtil.getBPMOrganization(dom);
            return organization;
        }
        return null;
    }

    public String getCompositeName(String compositeDN) {
        CompositeModel compositeModel = this.lookupCompositeModel(compositeDN);
        return compositeModel.getName();
    }

    public PropertyModel getCompositeProperty(String compositeDN, String propertyName) {
        CompositeModel compositeModel = this.lookupCompositeModel(compositeDN);
        PropertyModel prop = compositeModel.getProperty(propertyName);
        return prop;
    }

    public String getDeployedCompositeBaseURL(String compositeDN) throws Exception {
        StringBuffer url = new StringBuffer();
        url.append(this.getFabricConfigManager().getApplicationURLBase());
        url.append(compositeDN);
        url.append('/');
        return url.toString();
    }

    public void commitConfigChange(ComponentModel componentModel, boolean commit) throws FabricDeploymentException {
        super.commitConfigChange(componentModel, commit);
        if (commit) {
            try {
                BpmnDesignSchema designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN);
                designSchema.setActive(this.isActive(componentModel));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stateChanged(int newState) {
        super.stateChanged(newState);
        if (newState == 3) {
            try {
                if (WorkflowUtil.isBPMInstall()) {
                    DeploymentDescriptorUtil.grantBPMOrganizationAdminRoleToSOAOperator();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int abortInstancesByCompositeInstanceId(long compositeInstanceId) throws Exception {
        String logMethodName = "abortInstancesByCompositeInstanceId";
        DeploymentLogger.debug((String)logClassName, (String)"abortInstancesByCompositeInstanceId", (Object)"BEGIN");
        AuditUtil.markAuditAsAborted(Util.getInternalWorkflowContext(), String.valueOf(compositeInstanceId));
        int instances = super.abortInstancesByCompositeInstanceId(compositeInstanceId);
        IInternalInstanceManagementService service = (IInternalInstanceManagementService)BPMServiceLocator.getService((String)"internalInstanceManagementService");
        service.abortInstancesByCompositeInstanceId(Util.getInternalWorkflowContext(), compositeInstanceId);
        DeploymentLogger.debug((String)logClassName, (String)"abortInstancesByCompositeInstanceId", (Object)"END");
        return instances;
    }

    public int deleteInstancesByCompositeInstanceId(long compositeInstanceId) throws Exception {
        String logMethodName = "deleteInstancesByCompositeInstanceId";
        DeploymentLogger.debug((String)logClassName, (String)"deleteInstancesByCompositeInstanceId", (Object)"BEGIN");
        AuditUtil.markAuditAsAborted(Util.getInternalWorkflowContext(), String.valueOf(compositeInstanceId));
        int instances = super.deleteInstancesByCompositeInstanceId(compositeInstanceId);
        DeploymentLogger.debug((String)logClassName, (String)"deleteInstancesByCompositeInstanceId", (Object)"END");
        return instances;
    }

    protected BPMFaultImpl createFault() {
        return new BPMNFaultImpl();
    }

    protected BPMInstanceImpl createInstance() {
        return new BPMNInstanceImpl();
    }

    private String getBPMNProcessModel(CompositeDN compositeDN, String componentName) throws Exception {
        ComponentDN componentDN = new ComponentDN(compositeDN.getDomainName(), compositeDN.getCompositeName(), compositeDN.getRevision(), null, componentName);
        ICubeProcessManagerLocalBean localBean = EngineBeanCache.getProcessManagerLocalBean((String)this.getEngineType());
        String modelXML = ((IBPMNProcessManagerLocalBean)localBean).getBPMNProcessModelXML(componentDN);
        return modelXML;
    }

    private CompositeModel lookupCompositeModel(String compositeDN) {
        return this.getMesh().getComposite(compositeDN);
    }

    private String getAuditInstancePayload(long queryId) throws Exception {
        RecycleBin pool = EngineRecycleBinRegistry.getInstance();
        NonSyncStringWriter sink = (NonSyncStringWriter)pool.get(NonSyncStringWriter.class);
        ICubeInstanceManagerLocalBean localBean = EngineBeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
        try {
            byte[] bs = ((IBPMNCubeInstanceManagerLocalBean)localBean).getAuditInstancePayload(queryId);
            CXCompressUtils.uncompressStream((byte[])bs, (Writer)sink);
            String string = sink.toString();
            return string;
        }
        catch (Throwable t) {
            throw ExceptionUtils.handleServerException((Throwable)t);
        }
        finally {
            pool.release((IRecyclable)sink);
        }
    }

    private void registerBPMNLoggerAndResource() {
        LogFactory.addLoggerManager((String)this.getEngineType(), (ICubeLoggerManager)BPMNLoggerManager.getInstance());
        ResourceBundleHelper.addResourceBundleManager((String)"bpmn", (ICubeResourceBundleManager)BPMNResourceBundleManager.getInstance());
    }

    private boolean isActive(ComponentModel componentModel) {
        CompositeModel compositeModel = componentModel.getComposite();
        return "active".equals(compositeModel.getMode()) && "on".equals(compositeModel.getState());
    }

    private void importOrganization(Organization organization) throws Exception {
        IBPMContext ctx = this.getInternalBPMContext();
        DeploymentDescriptorUtil.importOrganization(ctx, organization);
    }

    private IBPMContext getInternalBPMContext() throws BPMException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InternalBPMContext.getInternalBPMContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof BPMException) {
                throw (BPMException)orgEx;
            }
            throw new BPMException((Exception)pae);
        }
    }
}

