/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BaseCubeInstanceObserver;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeInstanceObserver;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;

public class BPMNInstanceObserver
extends BaseCubeInstanceObserver
implements ICubeInstanceObserver {
    private static final String BPMN_OBSERVER_CONTEXT_KEY = "bpmobservercontextkey";
    private static final String logClassName = BPMNInstanceObserver.class.getName();

    public static void addBPMNObserver(ICubeContext ctx) {
        Boolean observerAdded = (Boolean)ctx.getFromEnvironment(BPMN_OBSERVER_CONTEXT_KEY);
        if (observerAdded == null || !observerAdded.booleanValue()) {
            BPMNInstanceObserver instanceObserver = new BPMNInstanceObserver();
            ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
            cubeInstance.addObserver((ICubeInstanceObserver)instanceObserver);
            ctx.addToEnvironment(BPMN_OBSERVER_CONTEXT_KEY, (Object)Boolean.TRUE);
        }
    }

    public void onPersist(ICubeContext ctx) {
        String logMethodName = "onPersist";
        try {
            BPMNUtility.persistProcessInstances(ctx);
            ctx.removeFromEnvironment(BPMN_OBSERVER_CONTEXT_KEY);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Throwable)e);
        }
    }
}

