/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.audit.IAuditTrail;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import java.util.Iterator;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.audit.BatchEvent;

public class BPMNAuditTrail
implements IAuditTrail {
    transient ICubeInstance mInstance;
    int defaultBatchThreshold = 10;
    transient BatchEvent mBatch = new BatchEvent();
    private int mBatchThreshold;
    private ICubeContext mCubeContext = null;
    private static final String logClassName = BPMNAuditTrail.class.getName();

    public BPMNAuditTrail(ICubeInstance cubeInstance, ICubeContext ctx) {
        this.setCubeInstance(cubeInstance);
        this.mBatchThreshold = this.defaultBatchThreshold;
        this.mCubeContext = ctx;
    }

    public BPMNAuditTrail(BatchEvent event) {
        this.mBatch = event;
    }

    public final void logEvent(IAuditEvent event) throws CubeException {
        String logMethodName = "logEvent";
        if (event instanceof BPMNAuditEvent) {
            if (this.mBatch.getInstanceCreationDate() == null && this.mInstance != null) {
                this.mBatch.setInstanceCreationDate(this.mInstance.getCreationDate());
            }
            if (this.mBatch.size() == this.mBatchThreshold) {
                try {
                    BPMNUtility.persistAuditData(this.mCubeContext);
                }
                catch (Exception e) {
                    BPELExecutionLogger.error((String)logClassName, (String)"logEvent", (Object)("Exception when attempting to persist a batch of audit events. " + e.toString()));
                    throw new CubeException((Throwable)e);
                }
                this.mBatch = new BatchEvent();
                if (this.mInstance != null) {
                    this.mBatch.setInstanceCreationDate(this.mInstance.getCreationDate());
                    this.mBatch.setCikey(this.mInstance.getId());
                }
            }
            this.mBatch.add(event);
            BPELExecutionLogger.debug((String)logClassName, (String)"logEvent", (Object)("Added an event to batch {" + event + "} current batch size {" + this.mBatch.size() + "}"));
        }
    }

    public void setCubeInstance(ICubeInstance ci) {
        if (ci != null) {
            this.mInstance = ci;
            this.mBatch.setCikey(this.mInstance.getId());
        }
    }

    public final ICubeInstance getCubeInstance() {
        return this.mInstance;
    }

    public final int getEventCount() {
        return this.mBatch.size();
    }

    public final boolean hasEvents() {
        return this.mBatch.size() > 0;
    }

    public final Iterator<IAuditEvent> getEvents() {
        return this.mBatch.getEvents().iterator();
    }

    public final void clear() {
        this.mBatch.getEvents().clear();
        this.mBatch.setInstanceCreationDate(null);
    }
}

