/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.xml.xpath.XPathException;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.impl.xpath.BPMNWorkflowXPathContext;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.ProcessRoleCache;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GetPerformer
implements XPathFunction,
IXPathFunction {
    BPMNWorkflowXPathContext bpmnWorkflowXPathContext = null;
    public static String FUNCTION_NAME = "getPerformer";

    public GetPerformer() {
    }

    public GetPerformer(BPMNWorkflowXPathContext bpmnWorkflowXPathContext) {
        this.bpmnWorkflowXPathContext = bpmnWorkflowXPathContext;
    }

    public Object evaluate(List args) throws XPathFunctionException {
        try {
            if (this.bpmnWorkflowXPathContext == null) {
                return null;
            }
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluate", (Object)"Evaluating the getPerformer xpath");
            Task taskObject = this.bpmnWorkflowXPathContext.getTask();
            String compositeDN = taskObject.getSca().getCompositeDN();
            String activityId = taskObject.getSystemAttributes().getActivityId();
            String processName = taskObject.getProcessInfo().getProcessId();
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluate", (Object)("Process name = " + processName));
            String swimlaneRole = ProcessRoleCache.getSwimlaneRole(compositeDN, processName, activityId);
            List<Participant> participants = DeploymentDescriptorUtil.getParticipantsForProcessRole(compositeDN, swimlaneRole, null);
            if (participants != null && !participants.isEmpty()) {
                Participant appRole = participants.get(0);
                BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluate", (Object)("App role name is  = " + ((PrincipleRefType)appRole.getValue()).getName()));
                taskObject.setApplicationContext(((PrincipleRefType)appRole.getValue()).getApplicationContext());
                return this.createNodeSet(participants);
            }
            throw new XPathException(77002, new Object[]{"[" + swimlaneRole + "]", processName});
        }
        catch (Throwable e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{"bpmn:getPerformer"}, e);
            throw new XPathFunctionException(wfe);
        }
    }

    public Object call(IXPathContext context, List args) throws oracle.fabric.common.xml.xpath.XPathFunctionException {
        try {
            return this.evaluate(args);
        }
        catch (Throwable e) {
            throw new oracle.fabric.common.xml.xpath.XPathFunctionException(e);
        }
    }

    private NodeList createNodeSet(Collection values) throws Exception {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        for (Participant obj : values) {
            Node node = this.createNode(obj, document);
            document.appendChild(node);
        }
        return document.getElementsByTagName("appRole");
    }

    private Node createNode(Participant participant, Document document) throws Exception {
        String namespaceURI = "http://xmlns.oracle.com/bpel/services/IdentityService";
        ParticipantTypeEnum type = ((PrincipleRefType)participant.getValue()).getType();
        String nodeName = null;
        if (ParticipantTypeEnum.USER == type) {
            nodeName = "user";
        } else if (ParticipantTypeEnum.GROUP == type) {
            nodeName = "group";
        } else if (ParticipantTypeEnum.APPROLE == type) {
            nodeName = "appRole";
        }
        Element elem = document.createElementNS(namespaceURI, nodeName);
        Text text = document.createTextNode(((PrincipleRefType)participant.getValue()).getName());
        elem.appendChild(text);
        return elem;
    }
}

