/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import java.math.BigDecimal;
import java.util.List;
import oracle.bpm.lang.Time;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BpmUtil {
    private BpmUtil() {
    }

    public static final class Convert
    implements IXPathFunction {
        public Object call(IXPathContext ixPathContext, List list) throws XPathFunctionException {
            Convert.checkArguments(list);
            int kind = Convert.getInt(list, 1);
            int length = Convert.getInt(list, 2);
            int scale = Convert.getInt(list, 3);
            if (kind != 6) {
                throw new XPathFunctionException("unsupported conversion: " + kind);
            }
            return Time.valueOf((String)Convert.getString(list, 0)).toXMLString(scale);
        }

        private static String getString(List<?> list, int position) {
            Object o = Convert.unwrapNode(list, position);
            return o == null ? "" : o.toString();
        }

        private static Object unwrapNode(List<?> list, int position) {
            Object o = list.get(position);
            if (o instanceof NodeList) {
                o = ((NodeList)o).item(0);
            }
            if (o instanceof Node) {
                Node nl = (Node)o;
                o = nl.getTextContent();
            }
            return o;
        }

        private static int getInt(List<?> list, int position) {
            Object o = Convert.unwrapNode(list, position);
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o != null && !(o instanceof Number)) {
                try {
                    o = new BigDecimal(o.toString());
                }
                catch (NumberFormatException ignore) {
                    o = null;
                }
            }
            double d = o == null ? Double.NaN : ((Number)o).doubleValue();
            return (int)Math.round(d);
        }

        private static void checkArguments(List<?> arguments) throws XPathFunctionException {
            int actual = arguments.size();
            if (actual == 4) {
                return;
            }
            throw new XPathFunctionException("convert requires 4 arguments but " + actual + " supplied");
        }
    }
}

