/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.xml.xpath.XPathException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.xpath.functions.BaseBPMNXpathFunction;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.xml.parser.v2.XMLElement;

public abstract class BaseGetDataFunction
extends BaseBPMNXpathFunction {
    public static final String BPMNEXPRESSION_EXECUTIONCONTEXT = "BPMNEXPRESSION_EXECUTIONCONTEXT";
    static final int ARG_DATAELEMENT = 0;
    static final int FUNCTION_ARITY = 1;
    private static Map<BPMNExpressionDataElementContextType, String> dataElementNameFromContext = new HashMap<BPMNExpressionDataElementContextType, String>();

    protected abstract BPMNExpressionDataElementContextType getType();

    @Override
    protected int getArgCount() {
        return 1;
    }

    @Override
    protected Object call(IXPathContext context, List args, ICubeContext cubeContext, IScope scope) throws Exception {
        Object dataElementValue = null;
        String dataElement = this.getStringArgument(args, 0);
        BPMNExpressionExecutionContext bpmnExpressionExecutionContext = (BPMNExpressionExecutionContext)context.getVariableValue(null, null, BPMNEXPRESSION_EXECUTIONCONTEXT);
        String flowElementName = "UNKNOWN";
        if (bpmnExpressionExecutionContext != null) {
            FlowNode flowNode = bpmnExpressionExecutionContext.getFlowNode();
            if (flowNode != null) {
                flowElementName = flowNode.toString();
            }
            DataElementVariable dataElementVariable = null;
            if (this.getType().equals((Object)bpmnExpressionExecutionContext.getExpressionData().getDataContextType())) {
                dataElementVariable = bpmnExpressionExecutionContext.resolve(dataElement);
            }
            if (dataElementVariable == null && this.getType().equals((Object)bpmnExpressionExecutionContext.getExpressionData().getExternalDataContextType())) {
                dataElementVariable = bpmnExpressionExecutionContext.resolveExternal(dataElement);
            }
            if (dataElementVariable != null) {
                dataElementValue = this.getDataElementValue(context, dataElementVariable);
            } else {
                throw new XPathException(77004, new Object[]{dataElementNameFromContext.get((Object)this.getType()), dataElement, bpmnExpressionExecutionContext.getFlowNode().toString()});
            }
        }
        if (dataElementValue == null) {
            throw new XPathException(77005, new Object[]{dataElementNameFromContext.get((Object)this.getType()), dataElement, flowElementName});
        }
        return dataElementValue;
    }

    private Object getDataElementValue(IXPathContext context, DataElementVariable dataElementVariable) throws Exception {
        Object xpathVariableContext;
        Object dataElementValue = null;
        if (dataElementVariable != null && (dataElementValue = dataElementVariable.getValue()) instanceof XMLElement && !dataElementVariable.isNativeStructure() && (xpathVariableContext = context.getVariableValue(null, null, "xpath-variable-context")) != null) {
            ((XMLElement)dataElementValue).setProperty("xpath-variable-context", xpathVariableContext);
        }
        return dataElementValue;
    }

    static {
        dataElementNameFromContext.put(BPMNExpressionDataElementContextType.DATAINPUTS_CONTEXT, "DataInput");
        dataElementNameFromContext.put(BPMNExpressionDataElementContextType.DATAOUTPUTS_CONTEXT, "DataOutput");
        dataElementNameFromContext.put(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, "DataObject");
    }
}

