/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.CXElementDataElementVariable;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.xml.parser.v2.XMLElement;
import org.collaxa.thirdparty.jaxen.UnresolvableException;
import org.collaxa.thirdparty.jaxen.VariableContext;

public class BPMNXPathVariableContext
implements VariableContext {
    private BPMNExpressionExecutionContext bpmnExpressionExecutionContext;
    private VariableContext variableContext;

    public BPMNXPathVariableContext(BPMNExpressionExecutionContext bpmnExpressionExecutionContext, VariableContext variableContext) {
        this.bpmnExpressionExecutionContext = bpmnExpressionExecutionContext;
        this.variableContext = variableContext;
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    public BPMNExpressionExecutionContext getBpmnExpressionExecutionContext() {
        return this.bpmnExpressionExecutionContext;
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        QName dataElementQName = new QName(namespaceURI, localName);
        Object result = this.resolveDataElement(dataElementQName);
        if (result == null) {
            result = this.getVariableContext().getVariableValue(namespaceURI, prefix, localName);
        }
        if (result == null) {
            throw new UnresolvableException(localName);
        }
        return result;
    }

    protected Object resolveDataElement(QName dataElementQName) {
        Object dataElementValue = null;
        String namespaceURI = dataElementQName.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.equals("")) {
            String dataElement = dataElementQName.getLocalPart();
            DataElementVariable dataElementVariable = this.getBpmnExpressionExecutionContext().resolve(dataElement);
            if (dataElementVariable != null) {
                dataElementValue = dataElementVariable.getValue();
                if ((dataElementValue = BPMNXPathUtil.adjustXPathReturnValue(dataElementValue)) instanceof XMLElement && dataElementVariable instanceof CXElementDataElementVariable) {
                    Object xpathVariableContext = null;
                    try {
                        xpathVariableContext = this.getVariableValue(null, null, "xpath-variable-context");
                    }
                    catch (UnresolvableException e) {
                        throw new RuntimeException(e);
                    }
                    if (xpathVariableContext != null) {
                        ((XMLElement)dataElementValue).setProperty("xpath-variable-context", xpathVariableContext);
                    }
                }
            }
        }
        return dataElementValue;
    }
}

