/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.xml.CubeXMLLogger;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionResolver;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathVariableResolver;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.blocks.AssemblyModelObject;
import oracle.fabric.common.xml.xpath.FabricXPathContext;
import oracle.fabric.common.xml.xpath.FabricXPathUtil;
import oracle.fabric.common.xml.xpath.FabricXPathVariableResolver;
import oracle.fabric.composite.model.ComponentModel;
import oracle.integration.platform.blocks.xpath.XPathContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPMNXPathUtil
extends FabricXPathUtil {
    private static Map<BPMNExpression.BPMNExpressionResultType, QName> resultTypes = new HashMap<BPMNExpression.BPMNExpressionResultType, QName>();

    public static Object adjustXPathReturnValue(Object value) {
        Object result = value;
        if (value != null && !(value instanceof Element)) {
            result = FabricXPathUtil.adjustXPathReturnValue((Object)value);
        }
        return result;
    }

    public static XPath createXPath(BPMNExpressionExecutionContext bpmnExpressionExecutionContext, NamespaceContext namespaceContext, ICubeContext ctx, IScope scope) throws CubeException {
        XPath xpath = BPMNXPathUtil.getXPath((NamespaceContext)namespaceContext);
        xpath.setXPathFunctionResolver((XPathFunctionResolver)((Object)BPMNXPathUtil.getFunctionResolver(ctx)));
        xpath.setXPathVariableResolver(BPMNXPathUtil.getVariableResolver(scope, ctx, bpmnExpressionExecutionContext));
        return xpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluate(String xpathExpressionText, XPath xpath, ICubeContext ctx, QName returnType, ComponentModel scaComponent) throws CubeException {
        Object object;
        try {
            XPathContext.setXPathContext((AssemblyModelObject)scaComponent);
            XPathExpression xPathExpression = BPMNXPathUtil.getXPathExpression(xpathExpressionText, xpath);
            object = xPathExpression.evaluate(BPMNXPathUtil.getXPathContext(null, xpath.getNamespaceContext(), ctx, xpath.getXPathVariableResolver(), scaComponent), returnType);
        }
        catch (Throwable throwable) {
            try {
                XPathContext.unsetXPathContext();
                throw throwable;
            }
            catch (XPathExpressionException e) {
                CubeXMLLogger.warn((String)"BPELXPathUtil", (String)"evaluate", (Object)e);
                throw new XPathException(9500, new Object[]{xpathExpressionText, e.getMessage()});
            }
        }
        XPathContext.unsetXPathContext();
        return object;
    }

    public static Object evaluate(String xpathExpressionText, XPath xpath, ICubeContext ctx) throws CubeException {
        return BPMNXPathUtil.evaluate(xpathExpressionText, xpath, ctx, oracle.xml.xpath.XPathContext.OBJECT, CubeContextHelper.getScaComponent((ICubeContext)ctx));
    }

    public static XPathExpression getXPathExpression(String xpathExpressionText, XPath xpath) throws CubeException, XPathExpressionException {
        xpathExpressionText = StringEscapeUtils.unescapeXml((String)xpathExpressionText);
        return xpath.compile(xpathExpressionText);
    }

    public static XPathVariableResolver getVariableResolver(IScope scope, ICubeContext ctx, BPMNExpressionExecutionContext bpmnExpressionExecutionContext) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (scope != null) {
            dataMap.put("IScope", scope);
        }
        boolean relaxQNameTest = false;
        if (ctx != null) {
            dataMap.put("ICubeContext", ctx);
            ICubeInstance ci = (ICubeInstance)ctx.getFromEnvironment("__cube-instance");
            if (ci != null && CubeFabricUtil.isRelaxXPathQName((ComponentModel)ci.getProcessClass().getScaComponent())) {
                relaxQNameTest = true;
            }
        }
        FabricXPathVariableResolver xPathVariableResolver = new FabricXPathVariableResolver();
        BPMNXPathVariableResolver bpmnxPathVariableResolver = new BPMNXPathVariableResolver(bpmnExpressionExecutionContext, scope);
        xPathVariableResolver.addSecondaryResolver((XPathVariableResolver)bpmnxPathVariableResolver);
        if (relaxQNameTest) {
            xPathVariableResolver.addVariable(new QName("variable-relax-qname-test"), (Object)Boolean.TRUE);
        }
        xPathVariableResolver.addVariable(new QName("xpath-function-data"), dataMap);
        xPathVariableResolver.addVariable(new QName("BPMNEXPRESSION_EXECUTIONCONTEXT"), (Object)bpmnExpressionExecutionContext);
        return xPathVariableResolver;
    }

    public static Object checkExpressionValue(Object value, String expression, boolean expectSingleNode, int lineNumber) throws CubeException {
        if (value instanceof NodeList) {
            value = BPMNXPathUtil.convertResultList((NodeList)((NodeList)value));
        }
        if (expectSingleNode && value == null) {
            String lineStr = String.valueOf(lineNumber);
            throw new BPELFault(BPELDefs.QN_SELECTION_FAILURE, new XPathException(9504, new Object[]{expression, lineStr}).getMessage());
        }
        return value;
    }

    public static QName mapBPMNExpressionResultType(BPMNExpression.BPMNExpressionResultType bpmnExpressionResultType) {
        QName resultType = resultTypes.get((Object)bpmnExpressionResultType);
        if (resultType == null) {
            resultType = oracle.xml.xpath.XPathContext.OBJECT;
        }
        return resultType;
    }

    static BPMNXPathFunctionResolver getFunctionResolver(ICubeContext ctx) throws CubeException {
        return ((BPMNServiceEngine)CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine()).getBPMNXPathFunctionResolver();
    }

    private static oracle.xml.xpath.XPathContext getXPathContext(Node node, NamespaceContext namespaceContext, ICubeContext ctx, XPathVariableResolver variableResolver, ComponentModel scaComponent) {
        return new FabricXPathContext(node, variableResolver, namespaceContext, scaComponent);
    }

    static {
        resultTypes.put(BPMNExpression.BPMNExpressionResultType.BOOLEAN, XPathConstants.BOOLEAN);
        resultTypes.put(BPMNExpression.BPMNExpressionResultType.NUMBER, XPathConstants.NUMBER);
        resultTypes.put(BPMNExpression.BPMNExpressionResultType.STRING, XPathConstants.STRING);
    }
}

