/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import com.collaxa.cube.xml.CubeXMLLogger;
import com.collaxa.cube.xml.xpath.jaxen.XPathFunctionWrapper;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.XPathFunctionRegistration;
import oracle.bpm.lang.Platform;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import org.collaxa.thirdparty.jaxen.Function;
import org.collaxa.thirdparty.jaxen.SimpleFunctionContext;
import org.collaxa.thirdparty.jaxen.UnresolvableException;
import org.collaxa.thirdparty.jaxen.XPathFunctionContext;

public class BPMNXPathFunctionContext
extends SimpleFunctionContext {
    public void loadFunctions() {
        ExtensionService service = Platform.getExtensionService();
        List extensions = service.getExtensionsByPoint(XPathFunctionRegistration.class);
        for (Extension extension : extensions) {
            try {
                XPathFunctionRegistration pathFunctionRegistration = (XPathFunctionRegistration)extension.getMetadata();
                QName functionQName = new QName(pathFunctionRegistration.namespaceURI(), pathFunctionRegistration.localPart());
                IXPathFunction xPathFunction = (IXPathFunction)extension.instantiateAs(IXPathFunction.class);
                this.registerFunction(functionQName.getNamespaceURI(), functionQName.getLocalPart(), (Function)new XPathFunctionWrapper(xPathFunction));
            }
            catch (InstantiationException e) {
                CubeXMLLogger.error((String)"BPMNXPathFunctionContext", (String)"loadFunctions", (Object)"Failed to instantiate XPath function ", (Throwable)e);
            }
        }
    }

    public Function getFunction(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        Function function;
        try {
            function = XPathFunctionContext.getInstance().getFunction(namespaceURI, prefix, localName);
        }
        catch (UnresolvableException e) {
            function = super.getFunction(namespaceURI, prefix, localName);
        }
        return function;
    }
}

