/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.xml.xpath.jaxen.CubeDOMNavigator;
import com.collaxa.cube.xml.xpath.jaxen.DOMXPath;
import java.util.HashMap;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathVariableContext;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import org.collaxa.thirdparty.jaxen.ExtendedVariableContext;
import org.collaxa.thirdparty.jaxen.FunctionContext;
import org.collaxa.thirdparty.jaxen.JaxenException;
import org.collaxa.thirdparty.jaxen.NamespaceContext;
import org.collaxa.thirdparty.jaxen.Navigator;
import org.collaxa.thirdparty.jaxen.VariableContext;
import org.w3c.dom.Node;

public class BPMNJaxenXPathUtil {
    private static CubeDOMNavigator singleton = new CubeDOMNavigator(){

        public String getTextStringValue(Object obj) {
            return this.getNodeStringValue((Node)obj);
        }

        public String getElementStringValue(Object obj) {
            return this.getNodeStringValue((Node)obj);
        }

        public String getAttributeStringValue(Object obj) {
            return this.getNodeStringValue((Node)obj);
        }

        private String getNodeStringValue(Node node) {
            return node.getTextContent();
        }
    };

    public static Object evaluate(String xpathExpressionText, BPMNExpressionExecutionContext bpmnExpressionExecutionContext, javax.xml.namespace.NamespaceContext namespaceContext, ICubeContext ctx, IScope scope) throws CubeException {
        try {
            DOMXPath xpath = new DOMXPath(xpathExpressionText){

                public Navigator getNavigator() {
                    return singleton;
                }
            };
            xpath.setVariableContext(BPMNJaxenXPathUtil.getVariableContext(scope, ctx, bpmnExpressionExecutionContext));
            xpath.setNamespaceContext(BPMNJaxenXPathUtil.getNamespaceContext(namespaceContext));
            xpath.setFunctionContext(BPMNJaxenXPathUtil.getFunctionContext(ctx));
            return xpath.selectSingleNode(null);
        }
        catch (JaxenException e) {
            throw new CubeException((Throwable)e);
        }
    }

    public static NamespaceContext getNamespaceContext(final javax.xml.namespace.NamespaceContext namespaceContext) {
        return new NamespaceContext(){

            public String translateNamespacePrefixToUri(String prefix) {
                return namespaceContext.getNamespaceURI(prefix);
            }
        };
    }

    public static VariableContext getVariableContext(IScope scope, ICubeContext ctx, BPMNExpressionExecutionContext bpmnExpressionExecutionContext) {
        ExtendedVariableContext variableContext = new ExtendedVariableContext();
        variableContext.setVariableValue("variable-ignore-errors", (Object)Boolean.TRUE);
        variableContext.setVariableValue("variable-init-mode", (Object)Boolean.TRUE);
        variableContext.setVariableValue("schema-manager", (Object)DataHandlingUtils.getSchemaManager(ctx));
        HashMap schemaComponents = (HashMap)bpmnExpressionExecutionContext.getDirectives().get("variable-schema-components");
        if (schemaComponents == null) {
            schemaComponents = new HashMap();
        }
        variableContext.setVariableValue("variable-schema-components", schemaComponents);
        variableContext.setVariableValue("initializeUnusedElements", (Object)Boolean.TRUE);
        variableContext.setVariableValue("xpath-variable-context", (Object)variableContext);
        variableContext.setVariableValue("BPMNEXPRESSION_EXECUTIONCONTEXT", (Object)bpmnExpressionExecutionContext);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (scope != null) {
            dataMap.put("IScope", scope);
        }
        if (ctx != null) {
            dataMap.put("ICubeContext", ctx);
        }
        variableContext.setVariableValue("xpath-function-data", dataMap);
        return new BPMNXPathVariableContext(bpmnExpressionExecutionContext, (VariableContext)variableContext);
    }

    private static FunctionContext getFunctionContext(ICubeContext ctx) throws CubeException {
        return ((BPMNServiceEngine)CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine()).getBPMNXPathFunctionContext();
    }
}

